/*
 * Decompiled with CFR 0.152.
 */
package com.profesorfalken.jsensors;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SensorsConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SensorsConfig.class);
    private static final String CONFIG_FILENAME = "jsensors.properties";
    private static Properties config;

    private SensorsConfig() {
    }

    private static Properties getConfig() {
        if (config == null) {
            config = new Properties();
            try {
                config.load(SensorsConfig.class.getClassLoader().getResourceAsStream(CONFIG_FILENAME));
            }
            catch (IOException ex) {
                LOGGER.error("Cannot load config file jsensors.properties", (Throwable)ex);
            }
        }
        return config;
    }

    static Map<String, String> getConfigMap() {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        Properties configProps = SensorsConfig.getConfig();
        for (String propertyName : configProps.stringPropertyNames()) {
            returnMap.put(propertyName, configProps.getProperty(propertyName));
        }
        return returnMap;
    }
}

