/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prowidesoftware.JsonSerializable;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.FileFormat;
import com.prowidesoftware.swift.model.MessageIOType;
import com.prowidesoftware.swift.model.MessageMetadataStrategy;
import com.prowidesoftware.swift.model.MessageStandardType;
import com.prowidesoftware.swift.model.SwiftMessageNote;
import com.prowidesoftware.swift.model.SwiftMessageRevision;
import com.prowidesoftware.swift.model.SwiftMessageStatusInfo;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

@Entity
@Table(name="swift_msg")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="type", length=2)
public abstract class AbstractSwiftMessage
implements Serializable,
JsonSerializable {
    public static final transient String PROPERTY_NAME = "name";
    protected static final String IDENTIFIER_ACK = "ACK";
    protected static final String IDENTIFIER_NAK = "NAK";
    private static final transient Logger log = Logger.getLogger(AbstractSwiftMessage.class.getName());
    private static final long serialVersionUID = 3769865560736793606L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(length=40)
    protected String identifier;
    @Column(length=12)
    protected String sender;
    @Column(length=12)
    protected String receiver;
    @Lob
    private String message;
    @Enumerated(value=EnumType.STRING)
    @Column(length=8)
    private MessageIOType direction;
    @Column(length=32, name="checksum")
    private String checksum;
    @Column(length=32, name="checksum_body")
    private String checksumBody;
    @Column(name="last_modified")
    private Calendar lastModified = Calendar.getInstance();
    @Column(name="creation_date")
    private Calendar creationDate = Calendar.getInstance();
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="msg_id", nullable=false)
    @OrderColumn(name="sort_key")
    private List<SwiftMessageStatusInfo> statusTrail = new ArrayList<SwiftMessageStatusInfo>();
    @Column(length=50)
    private String status;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="msg_id", nullable=false)
    @OrderColumn(name="sort_key")
    private List<SwiftMessageNote> notes = new ArrayList<SwiftMessageNote>();
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="swift_msg_properties", joinColumns={@JoinColumn(name="id")})
    @MapKeyColumn(name="property_key", length=200)
    @Column(name="property_value")
    @Lob
    private Map<String, String> properties = new HashMap<String, String>();
    @Column(length=100)
    private String filename;
    @Transient
    private FileFormat fileFormat;
    @Column(length=35)
    private String reference;
    @Column(length=3)
    private String currency;
    private BigDecimal amount;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="msg_id", nullable=false)
    @OrderColumn(name="sort_key")
    private List<SwiftMessageRevision> revisions = new ArrayList<SwiftMessageRevision>();
    @Temporal(value=TemporalType.DATE)
    private Calendar valueDate;
    @Temporal(value=TemporalType.DATE)
    private Calendar tradeDate;

    public AbstractSwiftMessage() {
    }

    @Deprecated
    protected AbstractSwiftMessage(String content) {
        this.message = content;
        this.updateFromMessage();
    }

    @Deprecated
    protected AbstractSwiftMessage(String content, FileFormat fileFormat) {
        this.message = content;
        this.fileFormat = fileFormat;
        this.updateFromMessage();
    }

    protected AbstractSwiftMessage(String content, FileFormat fileFormat, MessageMetadataStrategy metadataStrategy) {
        Validate.notNull((Object)metadataStrategy, (String)"the strategy for metadata extraction cannot be null", (Object[])new Object[0]);
        this.message = content;
        this.fileFormat = fileFormat;
        this.updateFromMessage(metadataStrategy);
    }

    @Deprecated
    protected AbstractSwiftMessage(InputStream stream) throws IOException {
        this.message = Lib.readStream(stream);
        this.updateFromMessage();
    }

    @Deprecated
    protected AbstractSwiftMessage(InputStream stream, FileFormat fileFormat) throws IOException {
        this.message = Lib.readStream(stream);
        this.fileFormat = fileFormat;
        this.updateFromMessage();
    }

    protected AbstractSwiftMessage(InputStream stream, FileFormat fileFormat, MessageMetadataStrategy metadataStrategy) throws IOException {
        Validate.notNull((Object)metadataStrategy, (String)"the strategy for metadata extraction cannot be null", (Object[])new Object[0]);
        this.message = Lib.readStream(stream);
        this.fileFormat = fileFormat;
        this.updateFromMessage(metadataStrategy);
    }

    @Deprecated
    protected AbstractSwiftMessage(File file) throws IOException {
        this.message = Lib.readFile(file);
        this.filename = file.getAbsolutePath();
        this.updateFromMessage();
    }

    @Deprecated
    protected AbstractSwiftMessage(File file, FileFormat fileFormat) throws IOException {
        this.message = Lib.readFile(file);
        this.filename = file.getAbsolutePath();
        this.fileFormat = fileFormat;
        this.updateFromMessage();
    }

    protected AbstractSwiftMessage(File file, FileFormat fileFormat, MessageMetadataStrategy metadataStrategy) throws IOException {
        Validate.notNull((Object)file, (String)"the file parameter cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)metadataStrategy, (String)"the strategy for metadata extraction cannot be null", (Object[])new Object[0]);
        this.message = Lib.readFile(file);
        this.filename = file.getAbsolutePath();
        this.fileFormat = fileFormat;
        this.updateFromMessage(metadataStrategy);
    }

    protected abstract void updateFromMessage();

    protected void updateFromMessage(MessageMetadataStrategy metadataStrategy) {
        this.updateFromMessage();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String message() {
        return this.message;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getChecksumBody() {
        return this.checksumBody;
    }

    public void setChecksumBody(String checksumBody) {
        this.checksumBody = checksumBody;
    }

    @XmlTransient
    public Calendar getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Calendar lastModified) {
        this.lastModified = lastModified;
    }

    @XmlTransient
    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
    }

    public List<SwiftMessageNote> getNotes() {
        return this.notes;
    }

    public void setNotes(List<SwiftMessageNote> notes) {
        this.notes = notes;
    }

    @XmlTransient
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public List<SwiftMessageStatusInfo> getStatusTrail() {
        return this.statusTrail;
    }

    public void setStatusTrail(List<SwiftMessageStatusInfo> statusTrail) {
        this.statusTrail = statusTrail;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setStatus(SwiftMessageStatusInfo status) {
        this.addStatus(status);
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public MessageIOType getDirection() {
        return this.direction;
    }

    public void setDirection(MessageIOType direction) {
        this.direction = direction;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getMessageName() {
        Map<String, String> p = this.getProperties();
        if (p != null && p.containsKey(PROPERTY_NAME) && StringUtils.isNotBlank((CharSequence)p.get(PROPERTY_NAME))) {
            return p.get(PROPERTY_NAME);
        }
        return null;
    }

    public void addStatus(SwiftMessageStatusInfo status) {
        if (status != null) {
            if (this.getStatusTrail() == null) {
                this.setStatusTrail(new ArrayList<SwiftMessageStatusInfo>());
            }
            this.statusTrail.add(status);
            this.setStatus(status.getName());
        }
    }

    public boolean isOutgoing() {
        return this.direction == MessageIOType.outgoing;
    }

    public boolean isInput() {
        return this.isOutgoing();
    }

    public Boolean isIncoming() {
        return this.direction == MessageIOType.incoming;
    }

    public Boolean isOutput() {
        return this.isIncoming();
    }

    public boolean isStatus(String status) {
        return StringUtils.equals((CharSequence)status, (CharSequence)this.getStatus());
    }

    public boolean isStatus(Enum status) {
        if (status != null) {
            return this.isStatus(status.name());
        }
        return false;
    }

    public SwiftMessageStatusInfo getStatusInfo() {
        List<SwiftMessageStatusInfo> l = this.getStatusTrail();
        if (l != null && !l.isEmpty()) {
            return l.get(l.size() - 1);
        }
        return null;
    }

    public SwiftMessageStatusInfo getPreviousStatusInfo() {
        List<SwiftMessageStatusInfo> l = this.getStatusTrail();
        if (l != null && l.size() >= 2) {
            return l.get(l.size() - 2);
        }
        return null;
    }

    public boolean contains(Enum ... statuses) {
        boolean result = false;
        List<SwiftMessageStatusInfo> l = this.getStatusTrail();
        if (l != null && !l.isEmpty()) {
            for (SwiftMessageStatusInfo s : this.getStatusTrail()) {
                for (Enum e : statuses) {
                    if (e == null || !StringUtils.equals((CharSequence)s.getName(), (CharSequence)e.name())) continue;
                    result = true;
                }
            }
        }
        return result;
    }

    public boolean contains(String ... statuses) {
        boolean result = false;
        List<SwiftMessageStatusInfo> l = this.getStatusTrail();
        if (l != null && !l.isEmpty()) {
            for (SwiftMessageStatusInfo s : this.getStatusTrail()) {
                for (String e : statuses) {
                    if (e == null || !StringUtils.equals((CharSequence)s.getName(), (CharSequence)e)) continue;
                    result = true;
                }
            }
        }
        return result;
    }

    public boolean isStatus(String ... statuses) {
        for (String s : statuses) {
            if (!this.isStatus(s)) continue;
            return true;
        }
        return false;
    }

    public boolean isStatus(Enum ... statuses) {
        for (Enum e : statuses) {
            if (e == null || !this.isStatus(e.name())) continue;
            return true;
        }
        return false;
    }

    public String getLastData(String ... statuses) {
        List<SwiftMessageStatusInfo> l = this.getStatusTrail();
        if (l != null && !l.isEmpty()) {
            for (int i = l.size() - 1; i >= 0; --i) {
                String d = l.get(i).getData();
                if (d == null || statuses != null && !ArrayUtils.contains((Object[])statuses, (Object)l.get(i).getName())) continue;
                return d;
            }
        }
        return "";
    }

    public String getLastData() {
        return this.getLastData(null);
    }

    public SwiftMessageStatusInfo findStatusInfo(String ... statusNames) {
        List<SwiftMessageStatusInfo> l = this.getStatusTrail();
        if (l != null && !l.isEmpty()) {
            for (SwiftMessageStatusInfo sms : l) {
                if (!ArrayUtils.contains((Object[])statusNames, (Object)sms.getName())) continue;
                return sms;
            }
        }
        return null;
    }

    public SwiftMessageStatusInfo findStatusInfo(String statusName) {
        String[] statuses = new String[]{statusName};
        return this.findStatusInfo(statuses);
    }

    public SwiftMessageStatusInfo findStatusInfoLast(String ... statusNames) {
        List<SwiftMessageStatusInfo> l = this.getStatusTrail();
        if (l != null && !l.isEmpty()) {
            for (int i = l.size() - 1; i >= 0; --i) {
                if (!ArrayUtils.contains((Object[])statusNames, (Object)l.get(i).getName())) continue;
                return l.get(i);
            }
        }
        return null;
    }

    public SwiftMessageStatusInfo findStatusInfoLast(String statusName) {
        String[] statuses = new String[]{statusName};
        return this.findStatusInfoLast(statuses);
    }

    public void addNote(SwiftMessageNote n) {
        if (this.notes == null) {
            this.notes = new ArrayList<SwiftMessageNote>();
        }
        this.notes.add(n);
    }

    public void sanityCheckProperties() {
        try {
            Map<String, String> p = this.getProperties();
            for (Map.Entry<String, String> entry : p.entrySet()) {
                String v = entry.getValue();
                if (v != null && v.length() > 500) {
                    log.severe("Value for key=" + entry.getKey() + " too long, will be truncated. value=" + v);
                    p.put(entry.getKey(), v.substring(0, 500));
                }
                if (entry.getKey().length() <= 200) continue;
                log.severe("Key too long: " + entry.getKey() + " will be truncated");
                p.remove(entry.getKey());
                p.put(entry.getKey().substring(0, 200), v);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error cheking properties", e);
        }
    }

    public String getProperty(String key) {
        if (this.properties != null) {
            return StringUtils.trimToNull((String)this.properties.get(key));
        }
        return null;
    }

    public String getProperty(Enum key) {
        return this.getProperty(key.name());
    }

    public void setProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.properties.put(key, value);
        }
    }

    public void setProperty(Enum key, String value) {
        this.setProperty(key.name(), value);
    }

    public boolean getPropertyBoolean(String key) {
        return this.propertyEquals("true", key);
    }

    public boolean getPropertyBoolean(Enum key) {
        return this.getPropertyBoolean(key.name());
    }

    public boolean propertyEquals(String key, String expectedValue) {
        return StringUtils.equals((CharSequence)expectedValue, (CharSequence)this.getProperty(key));
    }

    public boolean propertyEquals(Enum key, String expectedValue) {
        return this.propertyEquals(key.name(), expectedValue);
    }

    public boolean propertyEquals(Enum key, Enum expectedValue) {
        return this.propertyEquals(key.name(), expectedValue.name());
    }

    public String getPaddedId() {
        String id = this.id != null ? this.id.toString() : "0";
        return StringUtils.leftPad((String)id, (int)10, (String)"0");
    }

    public void copyTo(AbstractSwiftMessage msg) {
        Object copy;
        msg.setMessage(this.getMessage());
        msg.setIdentifier(this.getIdentifier());
        msg.setSender(this.getSender());
        msg.setReceiver(this.getReceiver());
        msg.setDirection(this.getDirection());
        msg.setChecksum(this.getChecksum());
        msg.setChecksumBody(this.getChecksumBody());
        msg.setLastModified(this.getLastModified());
        msg.setCreationDate(this.getCreationDate());
        msg.setStatusTrail(null);
        for (SwiftMessageStatusInfo status : this.getStatusTrail()) {
            msg.addStatus(new SwiftMessageStatusInfo(status.getComments(), status.getCreationDate(), status.getCreationUser(), status.getName(), status.getData()));
        }
        msg.setStatus(this.getStatus());
        msg.setNotes(null);
        for (SwiftMessageNote note : this.getNotes()) {
            copy = new SwiftMessageNote(note.getCreationUser(), note.getText());
            ((SwiftMessageNote)copy).setCreationDate(note.getCreationDate());
            msg.addNote((SwiftMessageNote)copy);
        }
        msg.setProperties(this.getProperties());
        msg.setFilename(this.getFilename());
        msg.setFileFormat(this.getFileFormat());
        msg.setReference(this.getReference());
        msg.setCurrency(this.getCurrency());
        msg.setAmount(this.getAmount());
        msg.setValueDate(this.getValueDate());
        msg.setTradeDate(this.getTradeDate());
        msg.setRevisions(null);
        for (SwiftMessageRevision rev : this.getRevisions()) {
            copy = new SwiftMessageRevision();
            ((SwiftMessageRevision)copy).setCreationDate(rev.getCreationDate());
            ((SwiftMessageRevision)copy).setCreationUser(rev.getCreationUser());
            ((SwiftMessageRevision)copy).setMessage(rev.getMessage());
            ((SwiftMessageRevision)copy).setJson(rev.getJson());
            msg.addRevision((SwiftMessageRevision)copy);
        }
    }

    public List<SwiftMessageRevision> getRevisions() {
        return this.revisions;
    }

    public void setRevisions(List<SwiftMessageRevision> revisions) {
        this.revisions = revisions;
    }

    public void addRevision(SwiftMessageRevision revision) {
        if (this.revisions == null) {
            this.revisions = new ArrayList<SwiftMessageRevision>();
        }
        this.revisions.add(revision);
    }

    public SwiftMessageRevision createRevision() {
        SwiftMessageRevision rev = new SwiftMessageRevision(this);
        this.addRevision(rev);
        return rev;
    }

    public Calendar getValueDate() {
        return this.valueDate;
    }

    public void setValueDate(Calendar valueDate) {
        this.valueDate = valueDate;
    }

    public Calendar getTradeDate() {
        return this.tradeDate;
    }

    public void setTradeDate(Calendar tradeDate) {
        this.tradeDate = tradeDate;
    }

    public boolean isMT() {
        return this.getClass().getSimpleName().startsWith("Mt");
    }

    public boolean isMX() {
        return this.getClass().getSimpleName().startsWith("Mx");
    }

    public MessageStandardType messageStandardType() {
        if (this.isMT()) {
            return MessageStandardType.MT;
        }
        if (this.isMX()) {
            return MessageStandardType.MX;
        }
        return null;
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public boolean match(String regex) {
        return this.identifier != null && StringUtils.isNotBlank((CharSequence)regex) && this.identifier.matches(regex);
    }

    public String formattedAmount() {
        return this.formattedAmount(null, true);
    }

    public String formattedAmount(Locale locale, boolean includeCurrency) {
        StringBuilder result = new StringBuilder();
        if (this.amount != null) {
            if (includeCurrency && this.currency != null) {
                result.append(this.currency);
                result.append(" ");
            }
            NumberFormat formatter = locale != null ? NumberFormat.getInstance(locale) : NumberFormat.getInstance();
            result.append(formatter.format(this.amount));
        }
        return result.toString();
    }

    public boolean identifiedAsACK() {
        return StringUtils.equals((CharSequence)this.identifier, (CharSequence)IDENTIFIER_ACK);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractSwiftMessage that = (AbstractSwiftMessage)o;
        return Objects.equals(this.message, that.message) && Objects.equals(this.identifier, that.identifier) && Objects.equals(this.sender, that.sender) && Objects.equals(this.receiver, that.receiver) && this.direction == that.direction && Objects.equals(this.checksum, that.checksum) && Objects.equals(this.checksumBody, that.checksumBody) && Objects.equals(this.lastModified, that.lastModified) && Objects.equals(this.creationDate, that.creationDate) && Objects.equals(this.statusTrail, that.statusTrail) && Objects.equals(this.status, that.status) && Objects.equals(this.notes, that.notes) && Objects.equals(this.properties, that.properties) && Objects.equals(this.filename, that.filename) && this.fileFormat == that.fileFormat && Objects.equals(this.reference, that.reference) && Objects.equals(this.currency, that.currency) && Objects.equals(this.amount, that.amount) && Objects.equals(this.revisions, that.revisions) && Objects.equals(this.valueDate, that.valueDate) && Objects.equals(this.tradeDate, that.tradeDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.message, this.identifier, this.sender, this.receiver, this.direction, this.checksum, this.checksumBody, this.lastModified, this.creationDate, this.statusTrail, this.status, this.notes, this.properties, this.filename, this.fileFormat, this.reference, this.currency, this.amount, this.revisions, this.valueDate, this.tradeDate});
    }

    public boolean identifiedAsNAK() {
        return StringUtils.equals((CharSequence)this.identifier, (CharSequence)IDENTIFIER_NAK);
    }

    protected String bic11(String address) {
        if (address != null) {
            return new BIC(address).getBic11();
        }
        return null;
    }

    public BIC getCorrespondentBIC() {
        String sender;
        String receiver;
        if (this.isOutgoing() && (receiver = this.getReceiver()) != null) {
            return new BIC(receiver);
        }
        if (this.isIncoming().booleanValue() && (sender = this.getSender()) != null) {
            return new BIC(sender);
        }
        return null;
    }

    public String getCreationYear() {
        return String.valueOf(this.creationDate.get(1));
    }

    public String getCreationMonth() {
        int imonth = this.creationDate.get(2) + 1;
        return (imonth < 10 ? "0" : "") + imonth;
    }

    public String getCreationDayOfMonth() {
        int iday = this.creationDate.get(5);
        return (iday < 10 ? "0" : "") + iday;
    }

    @Override
    public String toJson() {
        return this.toJsonImpl();
    }

    protected String toJsonImpl() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((Object)this);
    }

    public abstract String getCategory();

    public String getMessageType() {
        if (this.identifier != null && this.isMT()) {
            return this.identifier.replaceAll("\\D+", "");
        }
        return this.getIdentifier();
    }
}

