/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.mt.MTVariant;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class MtId {
    private String businessProcess = "fin";
    private String messageType;
    private String variant;

    public MtId() {
    }

    public MtId(String messageType) {
        this(messageType, (String)null);
    }

    public MtId(String messageType, String variant) {
        this.messageType = StringUtils.startsWith((CharSequence)messageType, (CharSequence)"fin.") ? StringUtils.substringAfter((String)messageType, (String)"fin.") : messageType;
        this.variant = variant;
    }

    public MtId(String messageType, MTVariant variant) {
        this(messageType, variant != null ? variant.name() : null);
    }

    public String getBusinessProcess() {
        return this.businessProcess;
    }

    public MtId setBusinessProcess(String businessProcess) {
        this.businessProcess = businessProcess;
        return this;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public MtId setMessageType(String messageType) {
        this.messageType = messageType;
        return this;
    }

    public String getVariant() {
        return this.variant;
    }

    public MtId setVariant(String variant) {
        this.variant = variant;
        return this;
    }

    public String toString() {
        return this.id();
    }

    public String id() {
        StringBuilder sb = new StringBuilder();
        if (this.businessProcess == null) {
            return null;
        }
        sb.append(this.businessProcess);
        if (this.messageType == null) {
            return null;
        }
        sb.append("." + this.messageType);
        if (this.variant != null) {
            sb.append("." + this.variant);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MtId mtId = (MtId)o;
        return Objects.equals(this.businessProcess, mtId.businessProcess) && Objects.equals(this.messageType, mtId.messageType) && Objects.equals(this.variant, mtId.variant);
    }

    public int hashCode() {
        return Objects.hash(this.businessProcess, this.messageType, this.variant);
    }

    public String category() {
        char cat;
        if (this.messageType != null && this.messageType.length() > 0 && Character.isDigit(cat = this.messageType.charAt(0))) {
            return String.valueOf(cat);
        }
        return "";
    }
}

