/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.UnparsedTextList;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public abstract class SwiftBlock
implements Serializable {
    private static final long serialVersionUID = -6993261477630953757L;
    @Deprecated
    protected Long id;
    protected UnparsedTextList unparsedTexts = null;
    protected Boolean input;
    protected Boolean output;
    protected String blockType;

    public SwiftBlock() {
    }

    public SwiftBlock(UnparsedTextList unparsedText) {
        this.unparsedTexts = unparsedText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwiftBlock that = (SwiftBlock)o;
        return Objects.equals(this.unparsedTexts, that.unparsedTexts);
    }

    public int hashCode() {
        return Objects.hash(this.unparsedTexts);
    }

    public String getBlockType() {
        return this.blockType;
    }

    public void setBlockType(String blockType) {
        this.blockType = blockType;
    }

    protected abstract void setBlockNumber(Integer var1);

    protected abstract void setBlockName(String var1);

    public abstract Integer getNumber();

    public abstract String getName();

    @Deprecated
    public Long getId() {
        DeprecationUtils.phase3(this.getClass(), "getId()", "The SwiftMessage model is no more intended for persistence, use the more effective JPA annotated model in AbstractSwiftMessage instead");
        return this.id;
    }

    @Deprecated
    public void setId(Long id) {
        DeprecationUtils.phase3(this.getClass(), "setId(Long)", "The SwiftMessage model is no more intended for persistence, use the more effective JPA annotated model in AbstractSwiftMessage instead");
        this.id = id;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean isTagBlock() {
        return this instanceof SwiftTagListBlock;
    }

    protected void unparsedTextVerify() {
        if (this.unparsedTexts == null) {
            this.unparsedTexts = new UnparsedTextList();
        }
    }

    public UnparsedTextList getUnparsedTexts() {
        this.unparsedTextVerify();
        return this.unparsedTexts;
    }

    public void setUnparsedTexts(UnparsedTextList texts) {
        this.unparsedTexts = texts;
    }

    public Integer getUnparsedTextsSize() {
        if (this.unparsedTexts == null) {
            return 0;
        }
        return this.unparsedTexts.size();
    }

    public Boolean unparsedTextIsMessage(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.isMessage(index);
    }

    public String unparsedTextGetText(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.getText(index);
    }

    public SwiftMessage unparsedTextGetAsMessage(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.getTextAsMessage(index);
    }

    public void unparsedTextAddText(String text) {
        this.unparsedTextVerify();
        this.unparsedTexts.addText(text);
    }

    public void unparsedTextAddText(SwiftMessage message) {
        this.unparsedTextVerify();
        this.unparsedTexts.addText(message);
    }

    public Boolean getInput() {
        return StringUtils.equals((CharSequence)this.getBlockType(), (CharSequence)"2I");
    }

    public void setInput(Boolean input) {
        this.input = input;
    }

    public Boolean getOutput() {
        return StringUtils.equals((CharSequence)this.getBlockType(), (CharSequence)"2O");
    }

    public void setOutput(Boolean output) {
        this.output = output;
    }
}

