/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prowidesoftware.swift.model.SwiftBlock3Builder;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field108;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;

public class SwiftBlock3
extends SwiftTagListBlock
implements Serializable {
    private static final long serialVersionUID = 4377884587811023149L;
    private static final transient Logger log = Logger.getLogger(SwiftBlock3.class.getName());

    public SwiftBlock3() {
    }

    public SwiftBlock3(List<Tag> tags) {
        this();
        this.addTags(tags);
    }

    public static SwiftBlock3 fromJson(String json) {
        Gson gson = new GsonBuilder().create();
        return (SwiftBlock3)gson.fromJson(json, SwiftBlock3.class);
    }

    @Override
    protected void setBlockNumber(Integer blockNumber) {
        Validate.notNull((Object)blockNumber, (String)"parameter 'blockNumber' cannot be null", (Object[])new Object[0]);
        Validate.isTrue((blockNumber == 3 ? 1 : 0) != 0, (String)"blockNumber must be 3", (Object[])new Object[0]);
    }

    @Override
    protected void setBlockName(String blockName) {
        Validate.notNull((Object)blockName, (String)"parameter 'blockName' cannot be null", (Object[])new Object[0]);
        Validate.isTrue((blockName.compareTo("3") == 0 ? 1 : 0) != 0, (String)"blockName must be string '3'", (Object[])new Object[0]);
    }

    @Override
    public Integer getNumber() {
        return 3;
    }

    @Override
    public String getName() {
        return "3";
    }

    public Boolean isSTP() {
        if (this.containsTag("119") && "STP".equalsIgnoreCase(this.getTagValue("119"))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void generateMUR(boolean overwriteIfExist) {
        String MUR = new SimpleDateFormat("yyMMddHHmmssSSSS").format(Calendar.getInstance().getTime());
        Tag t = this.getTagByName("108");
        if (t == null) {
            this.builder().setField108(new Field108(MUR));
        } else if (overwriteIfExist) {
            log.fine("block 3 MUR value " + t.getValue() + " overwritten with generated MUR " + MUR);
            t.setValue(MUR);
        }
    }

    public SwiftBlock3Builder builder() {
        return new SwiftBlock3Builder(this);
    }
}

