/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.ProwideException;
import com.prowidesoftware.swift.model.SwiftCharset;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class SwiftCharsetUtils {
    public static int OK = -1;
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] AZ = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] azLowerCase = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] specialCharacters_x = new char[]{'/', '-', '?', ':', '(', ')', '.', ',', '\'', '+', ' ', '\n', '\r'};
    private static final char[] specialCharacters_y = new char[]{' ', '.', ',', '-', '(', ')', '/', '=', '\'', '+', ':', '?', '!', '\"', '%', '&', '*', ';', '<', '>'};
    private static final char[] specialCharacters_z = new char[]{'.', ',', '-', '(', ')', '/', '=', '\'', '+', ':', '?', '@', '#', ' ', '{', '!', '\"', '%', '&', '*', ';', '<', '>', '_', '\n', '\r'};

    private SwiftCharsetUtils() {
        throw new AssertionError();
    }

    private static boolean isNumber(char character) {
        return character >= '0' && character <= '9';
    }

    private static boolean isLowercaseLetter(char character) {
        return character >= 'a' && character <= 'z';
    }

    private static boolean isUppercaseLetter(char character) {
        return character >= 'A' && character <= 'Z';
    }

    public static boolean is_n(char character) {
        return SwiftCharsetUtils.isNumber(character);
    }

    public static int is_n(String s) {
        return SwiftCharsetUtils.is(s, SwiftCharset.n);
    }

    public static boolean is_a(char character) {
        return SwiftCharsetUtils.isUppercaseLetter(character);
    }

    public static int is_a(String s) {
        return SwiftCharsetUtils.is(s, SwiftCharset.a);
    }

    public static boolean is_x(char character) {
        return SwiftCharsetUtils.isLowercaseLetter(character) || SwiftCharsetUtils.isUppercaseLetter(character) || SwiftCharsetUtils.isNumber(character) || SwiftCharsetUtils.is(character, specialCharacters_x);
    }

    public static int is_x(String s) {
        return SwiftCharsetUtils.is(s, SwiftCharset.x);
    }

    public static boolean is_y(char character) {
        return SwiftCharsetUtils.isUppercaseLetter(character) || SwiftCharsetUtils.isNumber(character) || SwiftCharsetUtils.is(character, specialCharacters_y);
    }

    public static int is_y(String s) {
        return SwiftCharsetUtils.is(s, SwiftCharset.y);
    }

    public static boolean is_z(char character) {
        return SwiftCharsetUtils.isLowercaseLetter(character) || SwiftCharsetUtils.isUppercaseLetter(character) || SwiftCharsetUtils.isNumber(character) || SwiftCharsetUtils.is(character, specialCharacters_z);
    }

    public static int is_z(String s) {
        return SwiftCharsetUtils.is(s, SwiftCharset.z);
    }

    public static boolean is_c(char character) {
        return SwiftCharsetUtils.isUppercaseLetter(character) || SwiftCharsetUtils.isNumber(character);
    }

    public static int is_c(String s) {
        return SwiftCharsetUtils.is(s, SwiftCharset.c);
    }

    public static boolean is_A(char character) {
        return SwiftCharsetUtils.isLowercaseLetter(character) || SwiftCharsetUtils.isUppercaseLetter(character);
    }

    public static int is_A(String s) {
        return SwiftCharsetUtils.is(s, SwiftCharset.A);
    }

    public static boolean is_B(char character) {
        return SwiftCharsetUtils.isLowercaseLetter(character) || SwiftCharsetUtils.isUppercaseLetter(character) || SwiftCharsetUtils.isNumber(character);
    }

    public static int is_B(String s) {
        return SwiftCharsetUtils.is(s, SwiftCharset.B);
    }

    public static int is(String s, SwiftCharset charset) {
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            for (int i = 0; i < s.length(); ++i) {
                if (SwiftCharsetUtils.is(s.charAt(i), charset)) continue;
                return i;
            }
        }
        return OK;
    }

    public static boolean is(char c, SwiftCharset charset) {
        switch (charset) {
            case n: {
                return SwiftCharsetUtils.is_n(c);
            }
            case a: {
                return SwiftCharsetUtils.is_a(c);
            }
            case A: {
                return SwiftCharsetUtils.is_A(c);
            }
            case x: {
                return SwiftCharsetUtils.is_x(c);
            }
            case y: {
                return SwiftCharsetUtils.is_y(c);
            }
            case z: {
                return SwiftCharsetUtils.is_z(c);
            }
            case c: {
                return SwiftCharsetUtils.is_c(c);
            }
            case B: {
                return SwiftCharsetUtils.is_B(c);
            }
        }
        throw new ProwideException("Unexpected charset value " + (Object)((Object)charset));
    }

    public static String getAsString(SwiftCharset charset) {
        String result = null;
        switch (charset) {
            case n: {
                result = SwiftCharsetUtils.getAsString(SwiftCharsetUtils.get_n());
                break;
            }
            case a: {
                result = SwiftCharsetUtils.getAsString(SwiftCharsetUtils.get_a());
                break;
            }
            case A: {
                result = SwiftCharsetUtils.getAsString(SwiftCharsetUtils.get_A());
                break;
            }
            case x: {
                result = SwiftCharsetUtils.getAsString(SwiftCharsetUtils.get_x());
                break;
            }
            case y: {
                result = SwiftCharsetUtils.getAsString(SwiftCharsetUtils.get_y());
                break;
            }
            case z: {
                result = SwiftCharsetUtils.getAsString(SwiftCharsetUtils.get_z());
                break;
            }
            case c: {
                result = SwiftCharsetUtils.getAsString(SwiftCharsetUtils.get_c());
                break;
            }
            case B: {
                result = SwiftCharsetUtils.getAsString(SwiftCharsetUtils.get_B());
                break;
            }
            default: {
                throw new ProwideException("Unexpected charset value " + (Object)((Object)charset));
            }
        }
        result = StringUtils.replace((String)result, (String)SwiftCharsetUtils.getAsString(SwiftCharsetUtils.get_n()), (String)"[0-9]");
        result = StringUtils.replace((String)result, (String)SwiftCharsetUtils.getAsString(SwiftCharsetUtils.get_a()), (String)"[A-Z]");
        result = StringUtils.replace((String)result, (String)SwiftCharsetUtils.getAsString(azLowerCase), (String)"[a-z]");
        return result;
    }

    private static boolean is(char c, char[] charset) {
        return ArrayUtils.contains((char[])charset, (char)c);
    }

    public static char[] get_n() {
        char[] result = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        return result;
    }

    public static char[] get_a() {
        char[] result = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        return result;
    }

    private static char[] _get_az() {
        char[] result = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        return result;
    }

    public static char[] get_A() {
        char[] result = SwiftCharsetUtils.get_a();
        return ArrayUtils.addAll((char[])result, (char[])SwiftCharsetUtils._get_az());
    }

    public static char[] get_x() {
        char[] result = specialCharacters_x;
        result = ArrayUtils.addAll((char[])result, (char[])SwiftCharsetUtils.get_A());
        result = ArrayUtils.addAll((char[])result, (char[])SwiftCharsetUtils.get_n());
        return result;
    }

    public static char[] get_y() {
        char[] result = specialCharacters_y;
        result = ArrayUtils.addAll((char[])result, (char[])SwiftCharsetUtils.get_a());
        result = ArrayUtils.addAll((char[])result, (char[])SwiftCharsetUtils.get_n());
        return result;
    }

    public static char[] get_z() {
        char[] result = specialCharacters_z;
        result = ArrayUtils.addAll((char[])result, (char[])SwiftCharsetUtils.get_A());
        result = ArrayUtils.addAll((char[])result, (char[])SwiftCharsetUtils.get_n());
        return result;
    }

    public static char[] get_c() {
        char[] result = SwiftCharsetUtils.get_a();
        return ArrayUtils.addAll((char[])result, (char[])SwiftCharsetUtils.get_n());
    }

    public static char[] get_B() {
        char[] result = SwiftCharsetUtils.get_A();
        return ArrayUtils.addAll((char[])result, (char[])SwiftCharsetUtils.get_n());
    }

    public static String getAsString(char[] charset) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < charset.length; ++i) {
            String ch = null;
            ch = charset[i] == '\n' ? "LF" : (charset[i] == '\r' ? "CR" : "" + charset[i]);
            result.append("[");
            result.append(ch);
            result.append("]");
        }
        return result.toString();
    }

    public static String filter(String s, SwiftCharset charset) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (!SwiftCharsetUtils.is(s.charAt(i), charset)) continue;
            result.append(s.charAt(i));
        }
        return result.toString();
    }
}

