/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.LogicalTerminalAddress;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field263
extends Field
implements Serializable,
DateContainer {
    public static final int SRU = 2020;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "263";
    public static final String F_263 = "263";
    public static final String PARSER_PATTERN = "<LT><DATE2><HHMM><HHMM>[N]";
    public static final String COMPONENTS_PATTERN = "ZEHHN";
    public static final Integer LT_ADDRESS = 1;
    public static final Integer DATE = 2;
    public static final Integer START_TIME = 3;
    public static final Integer END_TIME = 4;
    public static final Integer SESSION_NUMBER = 5;

    public Field263() {
        super(5);
    }

    public Field263(String value) {
        super(value);
    }

    public Field263(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"263")) {
            throw new IllegalArgumentException("cannot create field 263 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field263 newInstance(Field263 source) {
        Field263 cp = new Field263();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("263", value);
    }

    public static Tag emptyTag() {
        return new Tag("263", "");
    }

    @Override
    public void parse(String value) {
        this.init(5);
        if (value != null) {
            if (value.length() >= 12) {
                this.setComponent1(StringUtils.substring((String)value, (int)0, (int)12));
            }
            if (value.length() >= 18) {
                this.setComponent2(StringUtils.substring((String)value, (int)12, (int)18));
            }
            if (value.length() >= 22) {
                this.setComponent3(StringUtils.substring((String)value, (int)18, (int)22));
            }
            if (value.length() >= 26) {
                this.setComponent4(StringUtils.substring((String)value, (int)22, (int)26));
            }
            if (value.length() > 26) {
                this.setComponent5(StringUtils.substring((String)value, (int)26));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        this.append(result, 2);
        this.append(result, 3);
        this.append(result, 4);
        this.append(result, 5);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        Format f;
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 263");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 3) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            cal = this.getComponent3AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 4) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            cal = this.getComponent4AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 5) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            ((NumberFormat)f).setMaximumFractionDigits(13);
            Number n = this.getComponent5AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<LT><DATE2><HHMM><HHMM>[4!n]";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("LT Address");
        result.add("Date");
        result.add("Start Time");
        result.add("End Time");
        result.add("Session Number");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "lTAddress");
        result.put(2, "date");
        result.put(3, "startTime");
        result.put(4, "endTime");
        result.put(5, "sessionNumber");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public LogicalTerminalAddress getComponent1AsLogicalTerminalAddress() {
        return SwiftFormatUtils.getLTAddress(this.getComponent(1));
    }

    public String getLTAddress() {
        return this.getComponent(1);
    }

    public LogicalTerminalAddress getLTAddressAsLogicalTerminalAddress() {
        return SwiftFormatUtils.getLTAddress(this.getComponent(1));
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public String getDate() {
        return this.getComponent(2);
    }

    public Calendar getDateAsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Calendar getComponent3AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(3));
    }

    public String getStartTime() {
        return this.getComponent(3);
    }

    public Calendar getStartTimeAsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(3));
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Calendar getComponent4AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(4));
    }

    public String getEndTime() {
        return this.getComponent(4);
    }

    public Calendar getEndTimeAsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(4));
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public Number getComponent5AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(5));
    }

    public String getSessionNumber() {
        return this.getComponent(5);
    }

    public Number getSessionNumberAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(5));
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate2(this.getComponent(2)));
        result.add(SwiftFormatUtils.getTime3(this.getComponent(3)));
        result.add(SwiftFormatUtils.getTime3(this.getComponent(4)));
        return result;
    }

    public Field263 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field263 setComponent1(LogicalTerminalAddress component1) {
        this.setComponent(1, SwiftFormatUtils.getLTAddress(component1));
        return this;
    }

    public Field263 setLTAddress(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field263 setLTAddress(LogicalTerminalAddress component1) {
        this.setComponent1(component1);
        return this;
    }

    public Field263 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field263 setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getDate2(component2));
        return this;
    }

    public Field263 setDate(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field263 setDate(Calendar component2) {
        this.setComponent2(component2);
        return this;
    }

    public Field263 setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field263 setComponent3(Calendar component3) {
        this.setComponent(3, SwiftFormatUtils.getTime3(component3));
        return this;
    }

    public Field263 setStartTime(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field263 setStartTime(Calendar component3) {
        this.setComponent3(component3);
        return this;
    }

    public Field263 setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field263 setComponent4(Calendar component4) {
        this.setComponent(4, SwiftFormatUtils.getTime3(component4));
        return this;
    }

    public Field263 setEndTime(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field263 setEndTime(Calendar component4) {
        this.setComponent4(component4);
        return this;
    }

    public Field263 setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field263 setComponent5(Number component5) {
        if (component5 != null) {
            this.setComponent(5, Integer.toString(component5.intValue()));
        }
        return this;
    }

    public Field263 setSessionNumber(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field263 setSessionNumber(Number component5) {
        this.setComponent5(component5);
        return this;
    }

    @Override
    public String getName() {
        return "263";
    }

    public static Field263 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("263");
        if (t == null) {
            return null;
        }
        return new Field263(t);
    }

    public static Field263 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field263.get(msg.getBlock4());
    }

    public static List<Field263> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field263.getAll(msg.getBlock4());
    }

    public static List<Field263> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("263");
        if (arr != null && arr.length > 0) {
            ArrayList<Field263> result = new ArrayList<Field263>(arr.length);
            for (Tag f : arr) {
                result.add(new Field263(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field263 fromJson(String json) {
        Field263 field = new Field263();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("lTAddress") != null) {
            field.setComponent1(jsonObject.get("lTAddress").getAsString());
        }
        if (jsonObject.get("date") != null) {
            field.setComponent2(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("startTime") != null) {
            field.setComponent3(jsonObject.get("startTime").getAsString());
        }
        if (jsonObject.get("endTime") != null) {
            field.setComponent4(jsonObject.get("endTime").getAsString());
        }
        if (jsonObject.get("sessionNumber") != null) {
            field.setComponent5(jsonObject.get("sessionNumber").getAsString());
        }
        return field;
    }
}

