/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field30F
extends Field
implements Serializable,
DateContainer {
    public static final int SRU = 2020;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "30F";
    public static final String F_30F = "30F";
    public static final String PARSER_PATTERN = "S";
    public static final String COMPONENTS_PATTERN = "D";
    public static final Integer DATE = 1;

    public Field30F() {
        super(1);
    }

    public Field30F(String value) {
        super(value);
    }

    public Field30F(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"30F")) {
            throw new IllegalArgumentException("cannot create field 30F from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field30F newInstance(Field30F source) {
        Field30F cp = new Field30F();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("30F", value);
    }

    public static Tag emptyTag() {
        return new Tag("30F", "");
    }

    @Override
    public void parse(String value) {
        this.init(1);
        this.setComponent1(value);
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 1) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 30F");
        }
        if (component == 1) {
            DateFormat f = DateFormat.getDateInstance(2, this.notNull(locale));
            Calendar cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<DATE4>";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 1;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Date");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "date");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(1));
    }

    public String getDate() {
        return this.getComponent(1);
    }

    public Calendar getDateAsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(1));
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate4(this.getComponent(1)));
        return result;
    }

    public Field30F setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field30F setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getDate4(component1));
        return this;
    }

    public Field30F setDate(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field30F setDate(Calendar component1) {
        this.setComponent1(component1);
        return this;
    }

    @Override
    public String getName() {
        return "30F";
    }

    public static Field30F get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("30F");
        if (t == null) {
            return null;
        }
        return new Field30F(t);
    }

    public static Field30F get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field30F.get(msg.getBlock4());
    }

    public static List<Field30F> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field30F.getAll(msg.getBlock4());
    }

    public static List<Field30F> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("30F");
        if (arr != null && arr.length > 0) {
            ArrayList<Field30F> result = new ArrayList<Field30F>(arr.length);
            for (Tag f : arr) {
                result.add(new Field30F(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field30F fromJson(String json) {
        Field30F field = new Field30F();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("date") != null) {
            field.setComponent1(jsonObject.get("date").getAsString());
        }
        return field;
    }
}

