/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.LogicalTerminalAddress;
import com.prowidesoftware.swift.model.MIR;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field335
extends Field
implements Serializable {
    public static final int SRU = 2020;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "335";
    public static final String F_335 = "335";
    public static final String PARSER_PATTERN = "<HHMM><MIR>NS[N]";
    public static final String COMPONENTS_PATTERN = "HRMZH";
    public static final Integer TIME_MESSAGE_ENTERED = 1;
    public static final Integer MIR = 2;
    public static final Integer MT = 3;
    public static final Integer RECEIVER = 4;
    public static final Integer TIME_LAST_DELIVERY_ATTEMPT = 5;

    public Field335() {
        super(5);
    }

    public Field335(String value) {
        super(value);
    }

    public Field335(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"335")) {
            throw new IllegalArgumentException("cannot create field 335 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field335 newInstance(Field335 source) {
        Field335 cp = new Field335();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("335", value);
    }

    public static Tag emptyTag() {
        return new Tag("335", "");
    }

    @Override
    public void parse(String value) {
        this.init(5);
        if (value != null) {
            String toparse;
            if (value.length() >= 4) {
                this.setComponent1(StringUtils.substring((String)value, (int)0, (int)4));
            }
            if (value.length() >= 32) {
                this.setComponent2(StringUtils.substring((String)value, (int)4, (int)32));
            }
            if (value.length() > 32 && (toparse = StringUtils.substring((String)value, (int)32)) != null) {
                this.setComponent3(SwiftParseUtils.getNumericPrefix(toparse));
                String toparse2 = SwiftParseUtils.getAlphaSuffix(toparse);
                if (toparse2 != null) {
                    this.setComponent4(SwiftParseUtils.getAlphaPrefix(toparse2));
                    this.setComponent5(SwiftParseUtils.getNumericSuffix(toparse2));
                }
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        SimpleDateFormat f;
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 335");
        }
        if (component == 1) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            cal = this.getComponent5AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<HHMM><MIR><MT><LT>[<HHMM>]";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Time Message Entered");
        result.add("MIR");
        result.add("MT");
        result.add("Receiver");
        result.add("Time Last Delivery Attempt");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "timeMessageEntered");
        result.put(2, "mIR");
        result.put(3, "mT");
        result.put(4, "receiver");
        result.put(5, "timeLastDeliveryAttempt");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(1));
    }

    public String getTimeMessageEntered() {
        return this.getComponent(1);
    }

    public Calendar getTimeMessageEnteredAsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(1));
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public MIR getComponent2AsMIR() {
        return SwiftFormatUtils.getMIR(this.getComponent(2));
    }

    public String getMIR() {
        return this.getComponent(2);
    }

    public MIR getMIRAsMIR() {
        return SwiftFormatUtils.getMIR(this.getComponent(2));
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getMT() {
        return this.getComponent(3);
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public LogicalTerminalAddress getComponent4AsLogicalTerminalAddress() {
        return SwiftFormatUtils.getLTAddress(this.getComponent(4));
    }

    public String getReceiver() {
        return this.getComponent(4);
    }

    public LogicalTerminalAddress getReceiverAsLogicalTerminalAddress() {
        return SwiftFormatUtils.getLTAddress(this.getComponent(4));
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public Calendar getComponent5AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(5));
    }

    public String getTimeLastDeliveryAttempt() {
        return this.getComponent(5);
    }

    public Calendar getTimeLastDeliveryAttemptAsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(5));
    }

    public Field335 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field335 setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getTime3(component1));
        return this;
    }

    public Field335 setTimeMessageEntered(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field335 setTimeMessageEntered(Calendar component1) {
        this.setComponent1(component1);
        return this;
    }

    public Field335 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field335 setComponent2(MIR component2) {
        this.setComponent(2, SwiftFormatUtils.getMIR(component2));
        return this;
    }

    public Field335 setMIR(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field335 setMIR(MIR component2) {
        this.setComponent2(component2);
        return this;
    }

    public Field335 setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field335 setMT(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field335 setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field335 setComponent4(LogicalTerminalAddress component4) {
        this.setComponent(4, SwiftFormatUtils.getLTAddress(component4));
        return this;
    }

    public Field335 setReceiver(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field335 setReceiver(LogicalTerminalAddress component4) {
        this.setComponent4(component4);
        return this;
    }

    public Field335 setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field335 setComponent5(Calendar component5) {
        this.setComponent(5, SwiftFormatUtils.getTime3(component5));
        return this;
    }

    public Field335 setTimeLastDeliveryAttempt(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field335 setTimeLastDeliveryAttempt(Calendar component5) {
        this.setComponent5(component5);
        return this;
    }

    @Override
    public String getName() {
        return "335";
    }

    public static Field335 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("335");
        if (t == null) {
            return null;
        }
        return new Field335(t);
    }

    public static Field335 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field335.get(msg.getBlock4());
    }

    public static List<Field335> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field335.getAll(msg.getBlock4());
    }

    public static List<Field335> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("335");
        if (arr != null && arr.length > 0) {
            ArrayList<Field335> result = new ArrayList<Field335>(arr.length);
            for (Tag f : arr) {
                result.add(new Field335(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field335 fromJson(String json) {
        Field335 field = new Field335();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("timeMessageEntered") != null) {
            field.setComponent1(jsonObject.get("timeMessageEntered").getAsString());
        }
        if (jsonObject.get("mIR") != null) {
            field.setComponent2(jsonObject.get("mIR").getAsString());
        }
        if (jsonObject.get("mT") != null) {
            field.setComponent3(jsonObject.get("mT").getAsString());
        }
        if (jsonObject.get("receiver") != null) {
            field.setComponent4(jsonObject.get("receiver").getAsString());
        }
        if (jsonObject.get("timeLastDeliveryAttempt") != null) {
            field.setComponent5(jsonObject.get("timeLastDeliveryAttempt").getAsString());
        }
        return field;
    }
}

