/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.meta;

import com.puppycrawl.tools.checkstyle.AbstractAutomaticBean;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.MetadataGeneratorLogger;
import com.puppycrawl.tools.checkstyle.TreeWalker;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.meta.JavadocMetadataScraper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class MetadataGeneratorUtil {
    private MetadataGeneratorUtil() {
    }

    public static void generate(String path, OutputStream out, String ... moduleFolders) throws IOException, CheckstyleException {
        JavadocMetadataScraper.resetModuleDetailsStore();
        Checker checker = new Checker();
        checker.setModuleClassLoader(Checker.class.getClassLoader());
        DefaultConfiguration scraperCheckConfig = new DefaultConfiguration(JavadocMetadataScraper.class.getName());
        DefaultConfiguration defaultConfiguration = new DefaultConfiguration("configuration");
        DefaultConfiguration treeWalkerConfig = new DefaultConfiguration(TreeWalker.class.getName());
        defaultConfiguration.addProperty("charset", StandardCharsets.UTF_8.name());
        defaultConfiguration.addChild(treeWalkerConfig);
        treeWalkerConfig.addChild(scraperCheckConfig);
        checker.configure(defaultConfiguration);
        checker.addListener(new MetadataGeneratorLogger(out, AbstractAutomaticBean.OutputStreamOptions.NONE));
        List<File> moduleFiles = MetadataGeneratorUtil.getTargetFiles(path, moduleFolders);
        checker.process(moduleFiles);
    }

    private static List<File> getTargetFiles(String path, String ... moduleFolders) throws IOException {
        ArrayList<File> validFiles = new ArrayList<File>();
        for (String folder : moduleFolders) {
            try (Stream<Path> files = Files.walk(Path.of(path + "/" + folder, new String[0]), new FileVisitOption[0]);){
                validFiles.addAll(files.map(Path::toFile).filter(file -> {
                    String fileName = file.getName();
                    return fileName.endsWith("SuppressWarningsHolder.java") || fileName.endsWith("Check.java") || fileName.endsWith("Filter.java");
                }).collect(Collectors.toUnmodifiableList()));
            }
        }
        return validFiles;
    }
}

