/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.index.qual.IndexOrLow;

@FileStatefulCheck
public class UnusedImportsCheck
extends AbstractCheck {
    public static final String MSG_KEY = "import.unused";
    private static final Pattern CLASS_NAME = CommonUtil.createPattern("((:?[\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*)");
    private static final Pattern FIRST_CLASS_NAME = CommonUtil.createPattern("^" + String.valueOf(CLASS_NAME));
    private static final Pattern ARGUMENT_NAME = CommonUtil.createPattern("[(,]\\s*" + CLASS_NAME.pattern());
    private static final Pattern JAVA_LANG_PACKAGE_PATTERN = CommonUtil.createPattern("^java\\.lang\\.[a-zA-Z]+$");
    private static final Pattern REFERENCE = Pattern.compile("^([a-z_$][a-z\\d_$<>.]*)?(#(.*))?$", 2);
    private static final Pattern METHOD = Pattern.compile("^([a-z_$#][a-z\\d_$]*)(\\([^)]*\\))?$", 2);
    private static final String STAR_IMPORT_SUFFIX = ".*";
    private final Set<FullIdent> imports = new HashSet<FullIdent>();
    private boolean collect;
    private boolean processJavadoc = true;
    private Frame currentFrame;

    public void setProcessJavadoc(boolean value) {
        this.processJavadoc = value;
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.collect = false;
        this.currentFrame = Frame.compilationUnit();
        this.imports.clear();
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        this.currentFrame.finish();
        this.imports.stream().filter(imprt -> this.isUnusedImport(imprt.getText())).forEach(imprt -> this.log(imprt.getDetailAst(), MSG_KEY, imprt.getText()));
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{58, 30, 152, 16, 157, 161, 154, 155, 14, 15, 9, 8, 10, 199, 203, 6, 7};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 58: {
                if (!this.collect) break;
                this.processIdent(ast);
                break;
            }
            case 30: {
                this.processImport(ast);
                break;
            }
            case 152: {
                this.processStaticImport(ast);
                break;
            }
            case 6: 
            case 7: {
                this.currentFrame = this.currentFrame.push();
                break;
            }
            default: {
                this.collect = true;
                if (!this.processJavadoc) break;
                this.collectReferencesFromJavadoc(ast);
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        if (TokenUtil.isOfType(ast, 6, 7)) {
            this.currentFrame = this.currentFrame.pop();
        }
    }

    private boolean isUnusedImport(String imprt) {
        Matcher javaLangPackageMatcher = JAVA_LANG_PACKAGE_PATTERN.matcher(imprt);
        return !this.currentFrame.isReferencedType(CommonUtil.baseClassName(imprt)) || javaLangPackageMatcher.matches();
    }

    private void processIdent(DetailAST ast) {
        boolean isClassOrMethod;
        DetailAST parent = ast.getParent();
        int parentType = parent.getType();
        boolean bl = isClassOrMethod = parentType == 59 || parentType == 9 || parentType == 180;
        if (TokenUtil.isTypeDeclaration(parentType)) {
            this.currentFrame.addDeclaredType(ast.getText());
        } else if (!isClassOrMethod || UnusedImportsCheck.isQualifiedIdentifier(ast)) {
            this.currentFrame.addReferencedType(ast.getText());
        }
    }

    private static boolean isQualifiedIdentifier(DetailAST ast) {
        DetailAST parent = ast.getParent();
        int parentType = parent.getType();
        boolean isQualifiedIdent = parentType == 59 && !TokenUtil.isOfType(ast.getPreviousSibling(), 59) && ast.getNextSibling() != null;
        boolean isQualifiedIdentFromMethodRef = parentType == 180 && ast.getNextSibling() != null;
        return isQualifiedIdent || isQualifiedIdentFromMethodRef;
    }

    private void processImport(DetailAST ast) {
        FullIdent name = FullIdent.createFullIdentBelow(ast);
        if (!name.getText().endsWith(STAR_IMPORT_SUFFIX)) {
            this.imports.add(name);
        }
    }

    private void processStaticImport(DetailAST ast) {
        FullIdent name = FullIdent.createFullIdent(ast.getFirstChild().getNextSibling());
        if (!name.getText().endsWith(STAR_IMPORT_SUFFIX)) {
            this.imports.add(name);
        }
    }

    private void collectReferencesFromJavadoc(DetailAST ast) {
        int lineNo;
        FileContents contents = this.getFileContents();
        TextBlock textBlock = contents.getJavadocBefore(lineNo = ast.getLineNo());
        if (textBlock != null) {
            this.currentFrame.addReferencedTypes(UnusedImportsCheck.collectReferencesFromJavadoc(textBlock));
        }
    }

    private static Set<String> collectReferencesFromJavadoc(TextBlock textBlock) {
        List<JavadocTag> inlineTags = UnusedImportsCheck.getTargetTags(textBlock, JavadocUtil.JavadocTagType.INLINE);
        List<JavadocTag> blockTags = UnusedImportsCheck.getTargetTags(textBlock, JavadocUtil.JavadocTagType.BLOCK);
        List targetTags = Stream.concat(inlineTags.stream(), blockTags.stream()).collect(Collectors.toUnmodifiableList());
        HashSet<String> references = new HashSet<String>();
        targetTags.stream().filter(JavadocTag::canReferenceImports).forEach(tag -> references.addAll(UnusedImportsCheck.processJavadocTag(tag)));
        return references;
    }

    private static List<JavadocTag> getTargetTags(TextBlock cmt, JavadocUtil.JavadocTagType javadocTagType) {
        return JavadocUtil.getJavadocTags(cmt, javadocTagType).getValidTags().stream().filter(tag -> UnusedImportsCheck.isMatchingTagType(tag, javadocTagType)).map(UnusedImportsCheck::bestTryToMatchReference).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
    }

    private static Set<String> processJavadocTag(JavadocTag tag) {
        HashSet<String> references = new HashSet<String>();
        String identifier = tag.getFirstArg();
        for (Pattern pattern : new Pattern[]{FIRST_CLASS_NAME, ARGUMENT_NAME}) {
            references.addAll(UnusedImportsCheck.matchPattern(identifier, pattern));
        }
        return references;
    }

    private static Set<String> matchPattern(String identifier, Pattern pattern) {
        HashSet<String> references = new HashSet<String>();
        Matcher matcher = pattern.matcher(identifier);
        while (matcher.find()) {
            references.add(UnusedImportsCheck.topLevelType(matcher.group(1)));
        }
        return references;
    }

    private static String topLevelType(String type) {
        int dotIndex = type.indexOf(46);
        String topLevelType = dotIndex == -1 ? type : type.substring(0, dotIndex);
        return topLevelType;
    }

    private static boolean isMatchingTagType(JavadocTag tag, JavadocUtil.JavadocTagType javadocTagType) {
        boolean isInlineTag = tag.isInlineTag();
        boolean isBlockTagType = javadocTagType == JavadocUtil.JavadocTagType.BLOCK;
        return isBlockTagType != isInlineTag;
    }

    public static Optional<JavadocTag> bestTryToMatchReference(JavadocTag tag) {
        String referenceString;
        Matcher matcher;
        String content = tag.getFirstArg();
        int referenceIndex = UnusedImportsCheck.extractReferencePart(content);
        Optional<JavadocTag> validTag = Optional.empty();
        if (referenceIndex != -1 && (matcher = REFERENCE.matcher(referenceString = referenceIndex == 0 ? content : content.substring(0, referenceIndex))).matches()) {
            boolean isValid;
            int methodIndex = 3;
            String methodPart = matcher.group(3);
            boolean bl = isValid = methodPart == null || METHOD.matcher(methodPart).matches();
            if (isValid) {
                validTag = Optional.of(tag);
            }
        }
        return validTag;
    }

    private static @IndexOrLow(value={"#1"}) int extractReferencePart(String input) {
        int parenthesesCount = 0;
        int firstSpaceOutsideParens = -1;
        for (int index = 0; index < input.length(); ++index) {
            char currentCharacter = input.charAt(index);
            if (currentCharacter == '(') {
                ++parenthesesCount;
                continue;
            }
            if (currentCharacter == ')') {
                --parenthesesCount;
                continue;
            }
            if (currentCharacter != ' ' || parenthesesCount != 0) continue;
            firstSpaceOutsideParens = index;
            break;
        }
        int methodIndex = -1;
        if (parenthesesCount == 0) {
            methodIndex = firstSpaceOutsideParens == -1 ? 0 : firstSpaceOutsideParens;
        }
        return methodIndex;
    }

    private static final class Frame {
        private final Frame parent;
        private final Set<String> declaredTypes;
        private final Set<String> referencedTypes;

        private Frame(Frame parent) {
            this.parent = parent;
            this.declaredTypes = new HashSet<String>();
            this.referencedTypes = new HashSet<String>();
        }

        public void addDeclaredType(String type) {
            this.declaredTypes.add(type);
        }

        public void addReferencedType(String type) {
            this.referencedTypes.add(type);
        }

        public void addReferencedTypes(Collection<String> types) {
            this.referencedTypes.addAll(types);
        }

        public void finish() {
            this.referencedTypes.removeAll(this.declaredTypes);
        }

        public Frame push() {
            return new Frame(this);
        }

        public Frame pop() {
            this.finish();
            this.parent.addReferencedTypes(this.referencedTypes);
            return this.parent;
        }

        public boolean isReferencedType(String type) {
            return this.referencedTypes.contains(type);
        }

        public static Frame compilationUnit() {
            return new Frame(null);
        }
    }
}

