/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastStack<E>
implements Iterable<E> {
    private final List<E> mEntries = Lists.newArrayList();

    public void push(E aElement) {
        this.mEntries.add(aElement);
    }

    public boolean isEmpty() {
        return this.mEntries.isEmpty();
    }

    public int size() {
        return this.mEntries.size();
    }

    public E peek() {
        if (this.mEntries.isEmpty()) {
            throw new IllegalStateException("FastStack is empty");
        }
        return this.mEntries.get(this.mEntries.size() - 1);
    }

    public E pop() {
        if (this.mEntries.isEmpty()) {
            throw new IllegalStateException("FastStack is empty");
        }
        return this.mEntries.remove(this.mEntries.size() - 1);
    }

    public E peek(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mEntries.size()) {
            throw new IllegalArgumentException("index out of range.");
        }
        return this.mEntries.get(aIndex);
    }

    public boolean contains(E aElement) {
        return this.mEntries.contains(aElement);
    }

    public void clear() {
        this.mEntries.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return this.mEntries.iterator();
    }

    public static <T> FastStack<T> newInstance() {
        return new FastStack();
    }
}

