/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public final class OneStatementPerLineCheck
extends Check {
    public static final String MSG_KEY = "multiple.statements.line";
    private int lastStatementEnd = -1;
    private int exprDepth;
    private boolean inForHeader;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{28, 45, 35, 37};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{28, 45, 35, 37};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.exprDepth = 0;
        this.inForHeader = false;
        this.lastStatementEnd = -1;
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 28: {
                this.visitExpr(ast);
                break;
            }
            case 45: {
                this.visitSemi(ast);
                break;
            }
            case 35: {
                this.inForHeader = true;
                break;
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        switch (ast.getType()) {
            case 37: {
                this.inForHeader = false;
                break;
            }
            case 28: {
                --this.exprDepth;
                break;
            }
        }
    }

    private void visitExpr(DetailAST ast) {
        ++this.exprDepth;
        if (this.exprDepth == 1 && !this.inForHeader && this.lastStatementEnd == ast.getLineNo()) {
            this.log(ast, MSG_KEY, new Object[0]);
        }
    }

    private void visitSemi(DetailAST ast) {
        if (this.exprDepth == 0) {
            this.lastStatementEnd = ast.getLineNo();
        }
    }
}

