/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.LineSet;

public class MethodCallHandler
extends AbstractExpressionHandler {
    public MethodCallHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "method call", ast, parent);
    }

    @Override
    protected IndentLevel getIndentImpl() {
        IndentLevel indentLevel;
        if (this.getParent() instanceof MethodCallHandler) {
            MethodCallHandler container = (MethodCallHandler)this.getParent();
            indentLevel = MethodCallHandler.areOnSameLine(container.getMainAst(), this.getMainAst()) || this.isChainedMethodCallWrapped() || MethodCallHandler.areMethodsChained(container.getMainAst(), this.getMainAst()) ? container.getIndent() : new IndentLevel(container.getIndent(), this.getIndentCheck().getLineWrappingIndentation());
        } else if (this.getMainAst().getFirstChild().getType() == 136) {
            indentLevel = super.getIndentImpl();
        } else {
            LineSet lines = new LineSet();
            this.findSubtreeLines(lines, this.getMainAst().getFirstChild(), true);
            int firstCol = lines.firstLineCol();
            int lineStart = this.getLineStart(MethodCallHandler.getFirstAst(this.getMainAst()));
            indentLevel = lineStart == firstCol ? super.getIndentImpl() : new IndentLevel(lineStart);
        }
        return indentLevel;
    }

    private static boolean areMethodsChained(DetailAST ast1, DetailAST ast2) {
        DetailAST rparen = ast1.findFirstToken(77);
        return rparen.getLineNo() == ast2.getLineNo();
    }

    private boolean isChainedMethodCallWrapped() {
        boolean result = false;
        DetailAST main = this.getMainAst();
        DetailAST dot = main.getFirstChild();
        DetailAST target = dot.getFirstChild();
        DetailAST dot1 = target.getFirstChild();
        DetailAST target1 = dot1.getFirstChild();
        if (dot1.getType() == 59 && target1.getType() == 27) {
            result = true;
        }
        return result;
    }

    private static DetailAST getFirstAst(DetailAST ast) {
        DetailAST astNode = ast.getFirstChild();
        while (astNode.getType() == 59) {
            astNode = astNode.getFirstChild();
        }
        return astNode;
    }

    private DetailAST getMethodIdentAst() {
        DetailAST ast = this.getMainAst();
        if (ast.getType() != 42 && (ast = ast.getFirstChild()).getType() == 59) {
            ast = ast.getLastChild();
        }
        return ast;
    }

    @Override
    public IndentLevel getSuggestedChildIndent(AbstractExpressionHandler child) {
        DetailAST ident = this.getMethodIdentAst();
        DetailAST rparen = this.getMainAst().findFirstToken(77);
        IndentLevel suggestedLevel = new IndentLevel(this.getLineStart(ident));
        if (!MethodCallHandler.areOnSameLine(child.getMainAst().getFirstChild(), ident)) {
            suggestedLevel = new IndentLevel(suggestedLevel, this.getBasicOffset(), this.getIndentCheck().getLineWrappingIndentation());
        }
        if (this.getLineStart(rparen) == rparen.getColumnNo()) {
            suggestedLevel = IndentLevel.addAcceptable(suggestedLevel, new IndentLevel(this.getParent().getSuggestedChildIndent(this), this.getIndentCheck().getLineWrappingIndentation()));
        }
        return suggestedLevel;
    }

    @Override
    public void checkIndentation() {
        DetailAST lparen = null;
        if (this.getMainAst().getType() == 27) {
            DetailAST exprNode = this.getMainAst().getParent();
            if (exprNode.getParent().getType() == 7) {
                this.checkExpressionSubtree(this.getMainAst().getFirstChild(), this.getIndent(), false, false);
                lparen = this.getMainAst();
            }
        } else {
            lparen = this.getMainAst().getFirstChild();
        }
        if (lparen != null) {
            DetailAST rparen = this.getMainAst().findFirstToken(77);
            this.checkLeftParen(lparen);
            if (rparen.getLineNo() != lparen.getLineNo()) {
                this.checkExpressionSubtree(this.getMainAst().findFirstToken(34), new IndentLevel(this.getIndent(), this.getBasicOffset()), false, true);
                this.checkRightParen(lparen, rparen);
                this.checkWrappingIndentation(this.getMainAst(), MethodCallHandler.getCallLastNode(this.getMainAst()));
            }
        }
    }

    @Override
    protected boolean shouldIncreaseIndent() {
        return false;
    }

    private static DetailAST getCallLastNode(DetailAST firstNode) {
        return firstNode.getLastChild();
    }
}

