/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@StatelessCheck
public class AbbreviationAsWordInNameCheck
extends AbstractCheck {
    public static final String MSG_KEY = "abbreviation.as.word";
    private static final int DEFAULT_ALLOWED_ABBREVIATIONS_LENGTH = 3;
    private int allowedAbbreviationLength = 3;
    private Set<String> allowedAbbreviations = new HashSet<String>();
    private boolean ignoreFinal = true;
    private boolean ignoreStatic = true;
    private boolean ignoreStaticFinal = true;
    private boolean ignoreOverriddenMethods = true;

    public void setIgnoreFinal(boolean ignoreFinal) {
        this.ignoreFinal = ignoreFinal;
    }

    public void setIgnoreStatic(boolean ignoreStatic) {
        this.ignoreStatic = ignoreStatic;
    }

    public void setIgnoreStaticFinal(boolean ignoreStaticFinal) {
        this.ignoreStaticFinal = ignoreStaticFinal;
    }

    public void setIgnoreOverriddenMethods(boolean ignoreOverriddenMethods) {
        this.ignoreOverriddenMethods = ignoreOverriddenMethods;
    }

    public void setAllowedAbbreviationLength(int allowedAbbreviationLength) {
        this.allowedAbbreviationLength = allowedAbbreviationLength;
    }

    public void setAllowedAbbreviations(String ... allowedAbbreviations) {
        if (allowedAbbreviations != null) {
            this.allowedAbbreviations = Arrays.stream(allowedAbbreviations).collect(Collectors.toSet());
        }
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14, 15, 154, 157, 161, 21, 10, 9};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{14, 15, 154, 157, 161, 21, 10, 9, 155};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST nameAst;
        String typeName;
        String abbr;
        if (!this.isIgnoreSituation(ast) && (abbr = this.getDisallowedAbbreviation(typeName = (nameAst = ast.findFirstToken(58)).getText())) != null) {
            this.log(nameAst, MSG_KEY, typeName, this.allowedAbbreviationLength + 1);
        }
    }

    private boolean isIgnoreSituation(DetailAST ast) {
        DetailAST modifiers = ast.getFirstChild();
        boolean result = ast.getType() == 10 ? (AbbreviationAsWordInNameCheck.isInterfaceDeclaration(ast) ? this.ignoreStaticFinal : this.hasIgnoredModifiers(modifiers)) : (ast.getType() == 9 ? this.ignoreOverriddenMethods && AbbreviationAsWordInNameCheck.hasOverrideAnnotation(modifiers) : CheckUtil.isReceiverParameter(ast));
        return result;
    }

    private boolean hasIgnoredModifiers(DetailAST modifiers) {
        boolean isFinal;
        boolean isStatic = modifiers.findFirstToken(64) != null;
        boolean bl = isFinal = modifiers.findFirstToken(39) != null;
        boolean result = isStatic && isFinal ? this.ignoreStaticFinal : this.ignoreStatic && isStatic || this.ignoreFinal && isFinal;
        return result;
    }

    private static boolean isInterfaceDeclaration(DetailAST variableDefAst) {
        boolean result = false;
        DetailAST astBlock = variableDefAst.getParent();
        DetailAST astParent2 = astBlock.getParent();
        if (astParent2.getType() == 15 || astParent2.getType() == 157) {
            result = true;
        }
        return result;
    }

    private static boolean hasOverrideAnnotation(DetailAST methodModifiersAST) {
        boolean result = false;
        for (DetailAST child : AbbreviationAsWordInNameCheck.getChildren(methodModifiersAST)) {
            DetailAST annotationIdent = child.findFirstToken(58);
            if (annotationIdent == null || !"Override".equals(annotationIdent.getText())) continue;
            result = true;
            break;
        }
        return result;
    }

    private String getDisallowedAbbreviation(String str) {
        int beginIndex = 0;
        boolean abbrStarted = false;
        String result = null;
        for (int index = 0; index < str.length(); ++index) {
            char symbol = str.charAt(index);
            if (Character.isUpperCase(symbol)) {
                if (abbrStarted) continue;
                abbrStarted = true;
                beginIndex = index;
                continue;
            }
            if (!abbrStarted) continue;
            abbrStarted = false;
            int endIndex = index - 1;
            result = this.getAbbreviationIfIllegal(str, beginIndex, endIndex);
            if (result != null) break;
            beginIndex = -1;
        }
        if (abbrStarted) {
            int endIndex = str.length() - 1;
            result = this.getAbbreviationIfIllegal(str, beginIndex, endIndex);
        }
        return result;
    }

    private String getAbbreviationIfIllegal(String str, int beginIndex, int endIndex) {
        String abbr;
        String result = null;
        int abbrLength = endIndex - beginIndex;
        if (abbrLength > this.allowedAbbreviationLength && !this.allowedAbbreviations.contains(abbr = AbbreviationAsWordInNameCheck.getAbbreviation(str, beginIndex, endIndex))) {
            result = abbr;
        }
        return result;
    }

    private static String getAbbreviation(String str, int beginIndex, int endIndex) {
        String result = endIndex == str.length() - 1 ? str.substring(beginIndex) : str.substring(beginIndex, endIndex);
        return result;
    }

    private static List<DetailAST> getChildren(DetailAST node) {
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        for (DetailAST curNode = node.getFirstChild(); curNode != null; curNode = curNode.getNextSibling()) {
            result.add(curNode);
        }
        return result;
    }
}

