/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.apt;

import com.querydsl.apt.Configuration;
import com.querydsl.apt.Context;
import com.querydsl.apt.ExtendedTypeFactory;
import com.querydsl.apt.TypeElementHandler;
import com.querydsl.apt.TypeExtractor;
import com.querydsl.apt.TypeUtils;
import com.querydsl.apt.VisitorConfig;
import com.querydsl.codegen.Delegate;
import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.QueryTypeFactory;
import com.querydsl.codegen.Serializer;
import com.querydsl.codegen.SerializerConfig;
import com.querydsl.codegen.Supertype;
import com.querydsl.codegen.TypeMappings;
import com.querydsl.codegen.utils.CodeWriter;
import com.querydsl.codegen.utils.JavaWriter;
import com.querydsl.codegen.utils.model.Parameter;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.TypeCategory;
import com.querydsl.core.annotations.QueryDelegate;
import com.querydsl.core.annotations.QueryExclude;
import com.querydsl.core.annotations.QueryProjection;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;

public abstract class AbstractQuerydslProcessor
extends AbstractProcessor {
    public static final Boolean ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS = Boolean.FALSE;
    private final TypeExtractor typeExtractor = new TypeExtractor(true);
    private Configuration conf;
    private RoundEnvironment roundEnv;
    private ExtendedTypeFactory typeFactory;
    private TypeElementHandler elementHandler;
    private Context context;
    private boolean shouldLogInfo;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.setLogInfo();
        this.logInfo("Running " + this.getClass().getSimpleName());
        if (roundEnv.processingOver() || annotations.size() == 0) {
            return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
        }
        if (roundEnv.getRootElements() == null || roundEnv.getRootElements().isEmpty()) {
            this.logInfo("No sources to process");
            return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
        }
        this.conf = this.createConfiguration(roundEnv);
        this.context = new Context();
        Set<Class<? extends Annotation>> entityAnnotations = this.conf.getEntityAnnotations();
        TypeMappings typeMappings = this.conf.getTypeMappings();
        QueryTypeFactory queryTypeFactory = this.conf.getQueryTypeFactory();
        this.typeFactory = this.createTypeFactory(entityAnnotations, typeMappings, queryTypeFactory);
        this.elementHandler = this.createElementHandler(typeMappings, queryTypeFactory);
        this.roundEnv = roundEnv;
        this.processAnnotations();
        this.validateMetaTypes();
        this.serializeMetaTypes();
        return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
    }

    protected TypeElementHandler createElementHandler(TypeMappings typeMappings, QueryTypeFactory queryTypeFactory) {
        return new TypeElementHandler(this.conf, this.typeFactory, typeMappings, queryTypeFactory);
    }

    protected ExtendedTypeFactory createTypeFactory(Set<Class<? extends Annotation>> entityAnnotations, TypeMappings typeMappings, QueryTypeFactory queryTypeFactory) {
        return new ExtendedTypeFactory(this.processingEnv, entityAnnotations, typeMappings, queryTypeFactory, this.conf.getVariableNameFunction());
    }

    protected void processAnnotations() {
        this.processExclusions();
        Set<TypeElement> elements = this.collectElements();
        for (Element element : elements) {
            this.typeFactory.getEntityType(element.asType(), false);
        }
        for (Element element : elements) {
            this.typeFactory.getEntityType(element.asType(), true);
        }
        boolean embeddableAnn = this.conf.getEmbeddableAnnotation() != null;
        boolean bl = this.conf.getAlternativeEntityAnnotation() != null;
        boolean superAnn = this.conf.getSuperTypeAnnotation() != null;
        for (TypeElement typeElement : elements) {
            EntityType entityType3 = this.elementHandler.handleEntityType(typeElement);
            this.registerTypeElement(entityType3.getFullName(), typeElement);
            if (this.typeFactory.isSimpleTypeEntity(typeElement, this.conf.getEntityAnnotation())) {
                this.context.entityTypes.put(entityType3.getFullName(), entityType3);
            } else if (bl && typeElement.getAnnotation(this.conf.getAlternativeEntityAnnotation()) != null) {
                this.context.entityTypes.put(entityType3.getFullName(), entityType3);
            } else if (embeddableAnn && typeElement.getAnnotation(this.conf.getEmbeddableAnnotation()) != null) {
                this.context.embeddableTypes.put(entityType3.getFullName(), entityType3);
            } else if (superAnn && typeElement.getAnnotation(this.conf.getSuperTypeAnnotation()) != null) {
                this.context.supertypes.put(entityType3.getFullName(), entityType3);
            } else if (!entityType3.getDelegates().isEmpty()) {
                this.context.extensionTypes.put(entityType3.getFullName(), entityType3);
            } else {
                this.context.embeddableTypes.put(entityType3.getFullName(), entityType3);
            }
            this.context.allTypes.put(entityType3.getFullName(), entityType3);
        }
        for (EntityType entityType : new ArrayList<EntityType>(this.typeFactory.getEntityTypes())) {
            TypeElement element;
            String fullName = entityType.getFullName();
            if (this.context.allTypes.keySet().contains(fullName) || (element = this.processingEnv.getElementUtils().getTypeElement(fullName)) == null) continue;
            this.elementHandler.handleEntityType(element);
        }
        for (Element element : elements) {
            EntityType entityType = this.typeFactory.getEntityType(element.asType(), false);
            this.addExternalParents(entityType);
        }
        HashSet<EntityType> handled = new HashSet<EntityType>();
        for (EntityType entityType : this.context.allTypes.values()) {
            this.addSupertypeFields(entityType, handled);
        }
        this.processProjectionTypes(elements);
        this.typeFactory.extendTypes();
        this.context.clean();
    }

    private void addExternalParents(EntityType entityType) {
        ArrayDeque<Type> superTypes = new ArrayDeque<Type>();
        if (entityType.getSuperType() != null) {
            superTypes.push(entityType.getSuperType().getType());
        }
        while (!superTypes.isEmpty()) {
            Type superType = (Type)superTypes.pop();
            if (this.context.allTypes.containsKey(superType.getFullName())) continue;
            TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(superType.getFullName());
            if (typeElement == null) {
                throw new IllegalStateException("Found no type for " + superType.getFullName());
            }
            if (this.conf.isStrictMode() && !TypeUtils.hasAnnotationOfType((Element)typeElement, this.conf.getEntityAnnotations())) continue;
            EntityType superEntityType = this.elementHandler.handleEntityType(typeElement);
            if (superEntityType.getSuperType() != null) {
                superTypes.push(superEntityType.getSuperType().getType());
            }
            this.context.allTypes.put(superType.getFullName(), superEntityType);
        }
    }

    protected Set<TypeElement> collectElements() {
        HashSet<TypeElement> elements = new HashSet<TypeElement>(this.processDelegateMethods());
        for (Class<? extends Annotation> clazz : this.conf.getEntityAnnotations()) {
            for (Element element : this.getElements(clazz)) {
                if (!(element instanceof TypeElement)) continue;
                elements.add((TypeElement)element);
            }
        }
        if (this.conf.getEntitiesAnnotation() != null) {
            for (Element element : this.getElements(this.conf.getEntitiesAnnotation())) {
                AnnotationMirror mirror = TypeUtils.getAnnotationMirrorOfType(element, this.conf.getEntitiesAnnotation());
                elements.addAll(TypeUtils.getAnnotationValuesAsElements(mirror, "value"));
            }
        }
        if (this.conf.getEmbeddedAnnotation() != null) {
            elements.addAll(this.getEmbeddedTypes());
        }
        if (this.conf.isUnknownAsEmbedded()) {
            elements.addAll(this.getTypeFromProperties(elements));
        }
        if (!this.conf.isStrictMode()) {
            elements.addAll(this.getAnnotationlessSupertypes(elements));
        }
        if (this.conf.getEmbeddedAnnotation() != null) {
            Class<? extends Annotation> embedded = this.conf.getEmbeddedAnnotation();
            HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
            for (TypeElement typeElement : elements) {
                TypeMirror superTypeMirror = typeElement.getSuperclass();
                while (superTypeMirror != null) {
                    TypeElement superTypeElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(superTypeMirror);
                    if (superTypeElement != null) {
                        List<? extends Element> enclosed = superTypeElement.getEnclosedElements();
                        for (Element element : enclosed) {
                            if (element.getAnnotation(embedded) == null) continue;
                            this.handleEmbeddedType(element, hashSet);
                        }
                        superTypeMirror = superTypeElement.getSuperclass();
                        if (!(superTypeMirror instanceof NoType)) continue;
                        superTypeMirror = null;
                        continue;
                    }
                    superTypeMirror = null;
                }
            }
            for (TypeElement typeElement : hashSet) {
                if (elements.contains(typeElement)) continue;
                this.elementHandler.handleEntityType(typeElement);
            }
        }
        return elements;
    }

    private Set<TypeElement> getAnnotationlessSupertypes(Set<TypeElement> elements) {
        HashSet<TypeElement> rv = new HashSet<TypeElement>();
        for (TypeElement element : elements) {
            TypeMirror superTypeMirror = element.getSuperclass();
            while (superTypeMirror != null) {
                TypeElement superTypeElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(superTypeMirror);
                if (superTypeElement != null && !superTypeElement.toString().startsWith("java.lang.") && !TypeUtils.hasAnnotationOfType((Element)superTypeElement, this.conf.getEntityAnnotations())) {
                    rv.add(superTypeElement);
                    superTypeMirror = superTypeElement.getSuperclass();
                    if (!(superTypeMirror instanceof NoType)) continue;
                    superTypeMirror = null;
                    continue;
                }
                superTypeMirror = null;
            }
        }
        return rv;
    }

    private void registerTypeElement(String entityName, TypeElement element) {
        Set elements = this.context.typeElements.computeIfAbsent(entityName, k -> new HashSet());
        elements.add(element);
    }

    private void processProjectionTypes(Set<TypeElement> elements) {
        HashSet<Element> visited = new HashSet<Element>();
        for (Element element : this.getElements(QueryProjection.class)) {
            Element parent = element.getEnclosingElement();
            if (elements.contains(parent) || visited.contains(parent)) continue;
            EntityType model = this.elementHandler.handleProjectionType((TypeElement)parent);
            this.registerTypeElement(model.getFullName(), (TypeElement)parent);
            this.context.projectionTypes.put(model.getFullName(), model);
            visited.add(parent);
        }
    }

    private Set<TypeElement> getEmbeddedTypes() {
        HashSet<TypeElement> elements = new HashSet<TypeElement>();
        for (Element element : this.getElements(this.conf.getEmbeddedAnnotation())) {
            this.handleEmbeddedType(element, elements);
        }
        return elements;
    }

    private void handleEmbeddedType(Element element, Set<TypeElement> elements) {
        String typeName;
        TypeMirror type = element.asType();
        if (element.getKind() == ElementKind.METHOD) {
            type = ((ExecutableElement)element).getReturnType();
        }
        if ((typeName = type.toString()).startsWith(Collection.class.getName()) || typeName.startsWith(List.class.getName()) || typeName.startsWith(Set.class.getName())) {
            type = ((DeclaredType)type).getTypeArguments().get(0);
        } else if (typeName.startsWith(Map.class.getName())) {
            type = ((DeclaredType)type).getTypeArguments().get(1);
        }
        TypeElement typeElement = (TypeElement)this.typeExtractor.visit(type);
        if (typeElement != null && !TypeUtils.hasAnnotationOfType((Element)typeElement, this.conf.getEntityAnnotations()) && !typeElement.getQualifiedName().toString().startsWith("java.")) {
            elements.add(typeElement);
        }
    }

    private Set<TypeElement> getTypeFromProperties(Set<TypeElement> parents) {
        HashSet<TypeElement> elements = new HashSet<TypeElement>();
        for (Element element : parents) {
            if (!(element instanceof TypeElement)) continue;
            this.processFromProperties((TypeElement)element, elements);
        }
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            TypeElement typeElement = (TypeElement)iterator.next();
            String name = typeElement.getQualifiedName().toString();
            if (name.startsWith("java.") || name.startsWith("org.joda.time.")) {
                iterator.remove();
                continue;
            }
            boolean annotated = false;
            for (Class<? extends Annotation> annotation : this.conf.getEntityAnnotations()) {
                annotated |= typeElement.getAnnotation(annotation) != null;
            }
            if (!annotated) continue;
            iterator.remove();
        }
        return elements;
    }

    private void processFromProperties(TypeElement type, Set<TypeElement> types) {
        List<? extends Element> children = type.getEnclosedElements();
        VisitorConfig config = this.conf.getConfig(type, children);
        if (config.visitFieldProperties()) {
            for (VariableElement field : ElementFilter.fieldsIn(children)) {
                TypeElement typeElement = (TypeElement)this.typeExtractor.visit(field.asType());
                if (typeElement == null) continue;
                types.add(typeElement);
            }
        }
        if (config.visitMethodProperties()) {
            for (ExecutableElement method : ElementFilter.methodsIn(children)) {
                TypeElement typeElement;
                String name = method.getSimpleName().toString();
                if (!name.startsWith("get") && !name.startsWith("is") || !method.getParameters().isEmpty() || (typeElement = (TypeElement)this.typeExtractor.visit(method.getReturnType())) == null) continue;
                types.add(typeElement);
            }
        }
    }

    private void addSupertypeFields(EntityType model, Set<EntityType> handled) {
        if (handled.add(model)) {
            for (Supertype supertype : model.getSuperTypes()) {
                EntityType entityType = this.context.allTypes.get(supertype.getType().getFullName());
                if (entityType == null) continue;
                this.addSupertypeFields(entityType, handled);
                supertype.setEntityType(entityType);
                model.include(supertype);
            }
        }
    }

    private void processExclusions() {
        for (Element element : this.getElements(QueryExclude.class)) {
            if (element instanceof PackageElement) {
                this.conf.addExcludedPackage(((PackageElement)element).getQualifiedName().toString());
                continue;
            }
            if (element instanceof TypeElement) {
                this.conf.addExcludedClass(((TypeElement)element).getQualifiedName().toString());
                continue;
            }
            throw new IllegalArgumentException(element.toString());
        }
    }

    private Set<TypeElement> processDelegateMethods() {
        Set<? extends Element> delegateMethods = this.getElements(QueryDelegate.class);
        HashSet<TypeElement> typeElements = new HashSet<TypeElement>();
        for (Element element : delegateMethods) {
            boolean bl;
            ExecutableElement method = (ExecutableElement)element;
            Element element2 = element.getEnclosingElement();
            String name = method.getSimpleName().toString();
            Type delegateType = this.typeFactory.getType(element2.asType(), true);
            Type returnType = this.typeFactory.getType(method.getReturnType(), true);
            List<Parameter> parameters = this.elementHandler.transformParams(method.getParameters());
            parameters = parameters.subList(1, parameters.size());
            EntityType entityType = null;
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                TypeMirror type;
                if (!TypeUtils.isAnnotationMirrorOfType(annotationMirror, QueryDelegate.class) || (type = TypeUtils.getAnnotationValueAsTypeMirror(annotationMirror, "value")) == null) continue;
                entityType = this.typeFactory.getEntityType(type, true);
            }
            if (entityType == null) continue;
            this.registerTypeElement(entityType.getFullName(), (TypeElement)element2);
            entityType.addDelegate(new Delegate(entityType, delegateType, name, parameters, returnType));
            TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(entityType.getFullName());
            boolean bl2 = false;
            for (Class<? extends Annotation> ann : this.conf.getEntityAnnotations()) {
                if (typeElement.getAnnotation(ann) == null) continue;
                bl = true;
            }
            if (bl) {
                typeElements.add(this.processingEnv.getElementUtils().getTypeElement(entityType.getFullName()));
                continue;
            }
            this.context.extensionTypes.put(entityType.getFullName(), entityType);
            this.context.allTypes.put(entityType.getFullName(), entityType);
        }
        return typeElements;
    }

    private void validateMetaTypes() {
        Stream.of(this.context.supertypes.values(), this.context.entityTypes.values(), this.context.extensionTypes.values(), this.context.embeddableTypes.values(), this.context.projectionTypes.values()).flatMap(Collection::stream).forEach(entityType -> entityType.getProperties().stream().filter(property -> property.getInits() != null && property.getInits().size() > 0).forEach(property -> this.validateInits((EntityType)entityType, (Property)property)));
    }

    protected void validateInits(EntityType entityType, Property property) {
        for (String init : property.getInits()) {
            String initProperty;
            if (init.startsWith("*") || !(property.getType() instanceof EntityType)) continue;
            String string = initProperty = init.contains(".") ? init.substring(0, init.indexOf(46)) : init;
            Set propertyNames = ((EntityType)property.getType()).getPropertyNames();
            if (propertyNames.contains(initProperty)) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Illegal inits of " + entityType.getFullName() + "." + property.getName() + ": " + initProperty + " not found in " + propertyNames);
        }
    }

    private void serializeMetaTypes() {
        if (!this.context.supertypes.isEmpty()) {
            this.logInfo("Serializing Supertypes");
            this.serialize(this.conf.getSupertypeSerializer(), this.context.supertypes.values());
        }
        if (!this.context.entityTypes.isEmpty()) {
            this.logInfo("Serializing Entity types");
            this.serialize(this.conf.getEntitySerializer(), this.context.entityTypes.values());
        }
        if (!this.context.extensionTypes.isEmpty()) {
            this.logInfo("Serializing Extension types");
            this.serialize(this.conf.getEmbeddableSerializer(), this.context.extensionTypes.values());
        }
        if (!this.context.embeddableTypes.isEmpty()) {
            this.logInfo("Serializing Embeddable types");
            this.serialize(this.conf.getEmbeddableSerializer(), this.context.embeddableTypes.values());
        }
        if (!this.context.projectionTypes.isEmpty()) {
            this.logInfo("Serializing Projection types");
            this.serialize(this.conf.getDTOSerializer(), this.context.projectionTypes.values());
        }
    }

    private Set<? extends Element> getElements(Class<? extends Annotation> a) {
        return this.roundEnv.getElementsAnnotatedWith(a);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedOptions() {
        return new HashSet<String>(Arrays.asList("querydsl.createDefaultVariable", "querydsl.prefix", "querydsl.suffix", "querydsl.packageSuffix", "querydsl.mapAccessors", "querydsl.listAccessors", "querydsl.entityAccessors", "querydsl.useFields", "querydsl.useGetters", "querydsl.excludedPackages", "querydsl.excludedClasses", "querydsl.includedPackages", "querydsl.includedClasses", "querydsl.unknownAsEmbeddable", "querydsl.variableNameFunctionClass", "querydsl.logInfo", "querydsl.generatedAnnotationClass"));
    }

    private void setLogInfo() {
        boolean hasProperty = this.processingEnv.getOptions().containsKey("querydsl.logInfo");
        if (hasProperty) {
            String val = this.processingEnv.getOptions().get("querydsl.logInfo");
            this.shouldLogInfo = Boolean.parseBoolean(val);
        }
    }

    private void logInfo(String message) {
        if (this.shouldLogInfo) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, message);
        }
    }

    private void serialize(Serializer serializer, Collection<EntityType> models) {
        for (EntityType model : models) {
            try {
                String className = this.getClassName(model);
                if (this.conf.isExcludedPackage(model.getPackageName()) || this.conf.isExcludedClass(model.getFullName())) continue;
                Set<TypeElement> elements = this.context.typeElements.get(model.getFullName());
                if (elements == null) {
                    elements = new HashSet<TypeElement>();
                }
                for (Property property : model.getProperties()) {
                    Set<TypeElement> customElements;
                    if (property.getType().getCategory() != TypeCategory.CUSTOM || (customElements = this.context.typeElements.get(property.getType().getFullName())) == null) continue;
                    elements.addAll(customElements);
                }
                this.logInfo("Generating " + className + " for " + elements);
                Writer writer = this.conf.getFiler().createFile(this.processingEnv, className, elements);
                Throwable throwable = null;
                try {
                    SerializerConfig serializerConfig = this.conf.getSerializerConfig(model);
                    serializer.serialize(model, serializerConfig, (CodeWriter)new JavaWriter((Appendable)writer));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            }
        }
    }

    protected String getClassName(EntityType model) {
        Type type = this.conf.getTypeMappings().getPathType((Type)model, model, true);
        String packageName = type.getPackageName();
        return packageName.isEmpty() ? type.getSimpleName() : packageName + "." + type.getSimpleName();
    }

    protected abstract Configuration createConfiguration(RoundEnvironment var1);
}

