/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.collections;

import com.querydsl.codegen.utils.ECJEvaluatorFactory;
import com.querydsl.codegen.utils.Evaluator;
import com.querydsl.codegen.utils.EvaluatorFactory;
import com.querydsl.codegen.utils.JDKEvaluatorFactory;
import com.querydsl.codegen.utils.model.ClassType;
import com.querydsl.codegen.utils.model.SimpleType;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.TypeCategory;
import com.querydsl.codegen.utils.model.Types;
import com.querydsl.codegen.utils.support.ClassUtils;
import com.querydsl.collections.CollQueryFunctions;
import com.querydsl.collections.CollQuerySerializer;
import com.querydsl.collections.CollQueryTemplates;
import com.querydsl.core.JoinExpression;
import com.querydsl.core.JoinType;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.support.CollectionAnyVisitor;
import com.querydsl.core.support.Context;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.ParamNotSetException;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.util.PrimitiveUtils;
import java.lang.invoke.CallSite;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.jetbrains.annotations.Nullable;

public class DefaultEvaluatorFactory {
    private final EvaluatorFactory factory;
    private final CollQueryTemplates templates;
    private final CollectionAnyVisitor collectionAnyVisitor = new CollectionAnyVisitor();

    public DefaultEvaluatorFactory(CollQueryTemplates templates) {
        this(templates, Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : DefaultEvaluatorFactory.class.getClassLoader());
    }

    public DefaultEvaluatorFactory(CollQueryTemplates templates, EvaluatorFactory factory) {
        this.templates = templates;
        this.factory = factory;
    }

    protected DefaultEvaluatorFactory(CollQueryTemplates templates, URLClassLoader classLoader, JavaCompiler compiler) {
        this.templates = templates;
        this.factory = new JDKEvaluatorFactory(classLoader, compiler);
    }

    protected DefaultEvaluatorFactory(CollQueryTemplates templates, ClassLoader classLoader) {
        this.templates = templates;
        JavaCompiler systemJavaCompiler = ToolProvider.getSystemJavaCompiler();
        this.factory = classLoader instanceof URLClassLoader && systemJavaCompiler != null ? new JDKEvaluatorFactory((URLClassLoader)classLoader, systemJavaCompiler) : new ECJEvaluatorFactory(classLoader);
    }

    public <T> Evaluator<T> create(QueryMetadata metadata, List<? extends Expression<?>> sources, Expression<T> projection) {
        int i;
        CollQuerySerializer serializer = new CollQuerySerializer(this.templates);
        serializer.append("return ");
        if (projection instanceof FactoryExpression) {
            serializer.append("(");
            serializer.append(ClassUtils.getName((Class)projection.getType()));
            serializer.append(")(");
            serializer.handle(projection);
            serializer.append(")");
        } else {
            serializer.handle(projection);
        }
        serializer.append(";");
        Map constantToLabel = serializer.getConstantToLabel();
        Map<String, Object> constants = this.getConstants(metadata, constantToLabel);
        Class[] types = new Class[sources.size()];
        String[] names = new String[sources.size()];
        for (i = 0; i < sources.size(); ++i) {
            types[i] = sources.get(i).getType();
            names[i] = sources.get(i).toString();
        }
        for (i = 0; i < types.length; ++i) {
            if (!PrimitiveUtils.isWrapperType((Class)types[i])) continue;
            types[i] = PrimitiveUtils.unwrap((Class)types[i]);
        }
        return this.factory.createEvaluator(serializer.toString(), projection.getType(), names, types, constants);
    }

    public <T> Evaluator<List<T>> createEvaluator(QueryMetadata metadata, Expression<? extends T> source, Predicate filter) {
        String typeName = ClassUtils.getName((Class)source.getType());
        CollQuerySerializer ser = new CollQuerySerializer(this.templates);
        ser.append("java.util.List<" + typeName + "> rv = new java.util.ArrayList<" + typeName + ">();\n");
        ser.append("for (" + typeName + " " + source + " : " + source + "_) {\n");
        ser.append("    try {\n");
        ((CollQuerySerializer)((CollQuerySerializer)ser.append("        if (")).handle((Expression)filter)).append(") {\n");
        ser.append("            rv.add(" + source + ");\n");
        ser.append("        }\n");
        ser.append("    } catch (NullPointerException npe) { }\n");
        ser.append("}\n");
        ser.append("return rv;");
        Map constantToLabel = ser.getConstantToLabel();
        Map<String, Object> constants = this.getConstants(metadata, constantToLabel);
        ClassType sourceType = new ClassType(TypeCategory.SIMPLE, source.getType(), new Type[0]);
        ClassType sourceListType = new ClassType(TypeCategory.SIMPLE, Iterable.class, new Type[]{sourceType});
        return this.factory.createEvaluator(ser.toString(), sourceListType, new String[]{source + "_"}, new Type[]{sourceListType}, new Class[]{Iterable.class}, constants);
    }

    /*
     * WARNING - void declaration
     */
    public Evaluator<List<Object[]>> createEvaluator(QueryMetadata metadata, List<JoinExpression> joins, @Nullable Predicate filter) {
        void var11_16;
        ArrayList<CallSite> sourceNames = new ArrayList<CallSite>();
        ArrayList<SimpleType> sourceTypes = new ArrayList<SimpleType>();
        ArrayList<Class<Iterable>> sourceClasses = new ArrayList<Class<Iterable>>();
        StringBuilder vars = new StringBuilder();
        CollQuerySerializer ser = new CollQuerySerializer(this.templates);
        ser.append("java.util.List<Object[]> rv = new java.util.ArrayList<Object[]>();\n");
        ArrayList<CallSite> anyJoinMatchers = new ArrayList<CallSite>();
        block4: for (JoinExpression joinExpression : joins) {
            Expression target = joinExpression.getTarget();
            String typeName = ClassUtils.getName((Class)target.getType());
            if (vars.length() > 0) {
                vars.append(",");
            }
            switch (joinExpression.getType()) {
                case DEFAULT: {
                    ser.append("for (" + typeName + " " + target + " : " + target + "_) {\n");
                    vars.append(target);
                    sourceNames.add((CallSite)((Object)(target + "_")));
                    sourceTypes.add(new SimpleType((Type)Types.ITERABLE, new Type[]{new ClassType(TypeCategory.SIMPLE, target.getType(), new Type[0])}));
                    sourceClasses.add(Iterable.class);
                    continue block4;
                }
                case INNERJOIN: 
                case LEFTJOIN: {
                    Operation alias = (Operation)joinExpression.getTarget();
                    boolean colAnyJoin = joinExpression.getCondition() != null && joinExpression.getCondition().toString().equals("any");
                    boolean leftJoin = joinExpression.getType() == JoinType.LEFTJOIN;
                    String matcher = null;
                    if (colAnyJoin) {
                        matcher = alias.getArg(1).toString() + "_matched";
                        ser.append("boolean " + matcher + " = false;\n");
                        anyJoinMatchers.add((CallSite)((Object)matcher));
                    }
                    ser.append("for (" + typeName + " " + alias.getArg(1) + " : ");
                    if (leftJoin) {
                        ser.append(CollQueryFunctions.class.getName() + ".leftJoin(");
                    }
                    if (colAnyJoin) {
                        Context context = new Context();
                        Expression replacement = (Expression)alias.getArg(0).accept((Visitor)this.collectionAnyVisitor, (Object)context);
                        ser.handle(replacement);
                    } else {
                        ser.handle(alias.getArg(0));
                    }
                    if (alias.getArg(0).getType().equals(Map.class)) {
                        ser.append(".values()");
                    }
                    if (leftJoin) {
                        ser.append(")");
                    }
                    ser.append(") {\n");
                    if (matcher != null) {
                        ser.append("if (!" + matcher + ") {\n");
                    }
                    vars.append(alias.getArg(1));
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Illegal join expression " + joinExpression);
        }
        if (filter != null) {
            ser.append("try {\n");
            ser.append("if (");
            ((CollQuerySerializer)ser.handle((Expression)filter)).append(") {\n");
            for (String string : anyJoinMatchers) {
                ser.append("    " + string + " = true;\n");
            }
            ser.append("    rv.add(new Object[]{" + vars + "});\n");
            ser.append("}\n");
            ser.append("} catch (NullPointerException npe) { }\n");
        } else {
            ser.append("rv.add(new Object[]{" + vars + "});\n");
        }
        int amount = joins.size() + anyJoinMatchers.size();
        boolean bl = false;
        while (var11_16 < amount) {
            ser.append("}\n");
            ++var11_16;
        }
        ser.append("return rv;");
        Map map = ser.getConstantToLabel();
        Map<String, Object> constants = this.getConstants(metadata, map);
        ClassType projectionType = new ClassType(TypeCategory.LIST, List.class, new Type[]{Types.OBJECTS});
        return this.factory.createEvaluator(ser.toString(), projectionType, sourceNames.toArray(new String[0]), sourceTypes.toArray(new Type[0]), sourceClasses.toArray(new Class[0]), constants);
    }

    private Map<String, Object> getConstants(QueryMetadata metadata, Map<Object, String> constantToLabel) {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        for (Map.Entry<Object, String> entry : constantToLabel.entrySet()) {
            if (entry.getKey() instanceof ParamExpression) {
                Object value = metadata.getParams().get(entry.getKey());
                if (value == null) {
                    throw new ParamNotSetException((ParamExpression)entry.getKey());
                }
                constants.put(entry.getValue(), value);
                continue;
            }
            constants.put(entry.getValue(), entry.getKey());
        }
        return constants;
    }
}

