/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import com.querydsl.core.DateConstant;
import com.querydsl.core.DateTimeConstant;
import com.querydsl.core.NumberConstant;
import com.querydsl.core.QuerydslModule;
import com.querydsl.core.StringConstant;
import com.querydsl.core.Target;
import com.querydsl.core.TimeConstant;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MapExpression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.ArrayExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.CollectionExpressionBase;
import com.querydsl.core.types.dsl.ComparableExpression;
import com.querydsl.core.types.dsl.DateExpression;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.ListExpression;
import com.querydsl.core.types.dsl.ListPath;
import com.querydsl.core.types.dsl.MapExpressionBase;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.TimeExpression;
import java.sql.Date;
import java.sql.Time;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class MatchingFiltersFactory {
    private final QuerydslModule module;
    private final Target target;

    public MatchingFiltersFactory(QuerydslModule module, Target target) {
        this.module = module;
        this.target = target;
    }

    public <A> Collection<Predicate> array(ArrayExpression<A[], A> expr, ArrayExpression<A[], A> other, A knownElement, A missingElement) {
        HashSet<BooleanExpression> rv = new HashSet<BooleanExpression>();
        if (!this.module.equals((Object)QuerydslModule.RDFBEAN)) {
            rv.add(expr.size().gt((Number)0));
        }
        return Collections.unmodifiableSet(rv);
    }

    public <A> Collection<Predicate> collection(CollectionExpressionBase<?, A> expr, CollectionExpression<?, A> other, A knownElement, A missingElement) {
        HashSet<BooleanExpression> rv = new HashSet<BooleanExpression>();
        if (!this.module.equals((Object)QuerydslModule.RDFBEAN)) {
            rv.add(expr.contains(knownElement));
            rv.add(expr.contains(missingElement).not());
        }
        rv.add(expr.isEmpty().not());
        rv.add(expr.isNotEmpty());
        return Collections.unmodifiableSet(rv);
    }

    private <A extends Comparable> Collection<Predicate> comparable(ComparableExpression<A> expr, Expression<A> other) {
        HashSet<BooleanExpression> rv = new HashSet<BooleanExpression>();
        rv.add(expr.eq(other));
        rv.add(expr.goe(other));
        rv.add(expr.loe(other));
        rv.add(expr.ne(other).not());
        return Collections.unmodifiableSet(rv);
    }

    public Collection<Predicate> date(DateExpression<Date> expr, DateExpression<Date> other) {
        HashSet<Predicate> rv = new HashSet<Predicate>(this.comparable((ComparableExpression)expr, (Expression)other));
        rv.add((Predicate)expr.dayOfMonth().eq((Expression)other.dayOfMonth()));
        if (!(this.target.equals((Object)Target.DERBY) || this.module.equals((Object)QuerydslModule.JDO) || this.target.equals((Object)Target.ORACLE) || this.target.equals((Object)Target.FIREBIRD) || this.target.equals((Object)Target.POSTGRESQL) && this.module.equals((Object)QuerydslModule.JPA))) {
            rv.add((Predicate)expr.dayOfWeek().eq((Expression)other.dayOfWeek()));
            rv.add((Predicate)expr.dayOfYear().eq((Expression)other.dayOfYear()));
            if (!(this.target.equals((Object)Target.SQLSERVER) || this.target.equals((Object)Target.MYSQL) || this.target.equals((Object)Target.CUBRID) || this.target.equals((Object)Target.POSTGRESQL) || this.target.equals((Object)Target.HSQLDB))) {
                rv.add((Predicate)expr.week().eq((Expression)other.week()));
            }
        }
        rv.add((Predicate)expr.month().eq((Expression)other.month()));
        rv.add((Predicate)expr.year().eq((Expression)other.year()));
        rv.add((Predicate)expr.yearMonth().eq((Expression)other.yearMonth()));
        return Collections.unmodifiableSet(rv);
    }

    public Collection<Predicate> date(DateExpression<Date> expr, DateExpression<Date> other, Date knownValue) {
        HashSet<Predicate> rv = new HashSet<Predicate>();
        rv.addAll(this.date(expr, other));
        rv.addAll(this.date(expr, DateConstant.create(knownValue)));
        return Collections.unmodifiableSet(rv);
    }

    public Collection<Predicate> dateTime(DateTimeExpression<java.util.Date> expr, DateTimeExpression<java.util.Date> other) {
        HashSet<Predicate> rv = new HashSet<Predicate>(this.comparable((ComparableExpression)expr, (Expression)other));
        rv.add((Predicate)expr.milliSecond().eq((Expression)other.milliSecond()));
        rv.add((Predicate)expr.second().eq((Expression)other.second()));
        rv.add((Predicate)expr.minute().eq((Expression)other.minute()));
        rv.add((Predicate)expr.hour().eq((Expression)other.hour()));
        rv.add((Predicate)expr.dayOfMonth().eq((Expression)other.dayOfMonth()));
        if (!(this.target.equals((Object)Target.DERBY) || this.module.equals((Object)QuerydslModule.JDO) || this.target.equals((Object)Target.ORACLE) || this.target.equals((Object)Target.POSTGRESQL) && this.module.equals((Object)QuerydslModule.JPA))) {
            rv.add((Predicate)expr.dayOfWeek().eq((Expression)other.dayOfWeek()));
            rv.add((Predicate)expr.dayOfYear().eq((Expression)other.dayOfYear()));
            if (!(this.target.equals((Object)Target.SQLSERVER) || this.target.equals((Object)Target.MYSQL) || this.target.equals((Object)Target.CUBRID) || this.target.equals((Object)Target.POSTGRESQL) || this.target.equals((Object)Target.HSQLDB))) {
                rv.add((Predicate)expr.week().eq((Expression)other.week()));
            }
        }
        rv.add((Predicate)expr.month().eq((Expression)other.month()));
        rv.add((Predicate)expr.year().eq((Expression)other.year()));
        rv.add((Predicate)expr.yearMonth().eq((Expression)other.yearMonth()));
        return Collections.unmodifiableSet(rv);
    }

    public Collection<Predicate> dateTime(DateTimeExpression<java.util.Date> expr, DateTimeExpression<java.util.Date> other, java.util.Date knownValue) {
        HashSet<Predicate> rv = new HashSet<Predicate>();
        rv.addAll(this.dateTime(expr, other));
        rv.addAll(this.dateTime(expr, DateTimeConstant.create(knownValue)));
        return Collections.unmodifiableSet(rv);
    }

    public <A, Q extends SimpleExpression<A>> Collection<Predicate> list(ListPath<A, Q> expr, ListExpression<A, Q> other, A knownElement, A missingElement) {
        return this.collection((CollectionExpressionBase<?, A>)expr, (CollectionExpression<?, A>)other, knownElement, missingElement);
    }

    public <K, V> Collection<Predicate> map(MapExpressionBase<K, V, ?> expr, MapExpression<K, V> other, K knownKey, V knownValue, K missingKey, V missingValue) {
        HashSet<BooleanExpression> rv = new HashSet<BooleanExpression>();
        rv.add(expr.containsKey(knownKey));
        rv.add(expr.containsKey(missingKey).not());
        rv.add(expr.containsValue(knownValue));
        rv.add(expr.containsValue(missingValue).not());
        rv.add(expr.get(knownKey).eq(knownValue));
        rv.add(expr.isEmpty().not());
        rv.add(expr.isNotEmpty());
        return Collections.unmodifiableSet(rv);
    }

    public <A extends Number> Collection<Predicate> numeric(NumberExpression<A> expr, NumberExpression<A> other, A knownValue) {
        HashSet<Predicate> rv = new HashSet<Predicate>();
        rv.addAll(this.numeric(expr, other));
        rv.addAll(this.numeric(expr, NumberConstant.create(knownValue)));
        return Collections.unmodifiableSet(rv);
    }

    public <A extends Number> Collection<Predicate> numeric(NumberExpression<A> expr, NumberExpression<A> other) {
        HashSet<BooleanExpression> rv = new HashSet<BooleanExpression>();
        rv.add(expr.eq(other));
        rv.add(expr.goe(other));
        rv.add(expr.gt((Expression)other.subtract((Number)1)));
        rv.add(expr.gt((Expression)other.subtract((Number)2)));
        rv.add(expr.loe(other));
        rv.add(expr.lt((Expression)other.add((Number)1)));
        rv.add(expr.lt((Expression)other.add((Number)2)));
        rv.add(expr.ne(other).not());
        return Collections.unmodifiableSet(rv);
    }

    public Collection<Predicate> string(StringExpression expr, StringExpression other) {
        HashSet<Object> rv = new HashSet<Object>();
        if (this.module != QuerydslModule.LUCENE) {
            rv.addAll(this.comparable((ComparableExpression)expr, (Expression)other));
            rv.add(expr.charAt(0).eq((Expression)other.charAt(0)));
            rv.add(expr.charAt(1).eq((Expression)other.charAt(1)));
        }
        rv.add(expr.contains((Expression)other));
        rv.add(expr.contains((Expression)other.substring(0, 1)));
        rv.add(expr.contains((Expression)other.substring(0, 2)));
        rv.add(expr.contains((Expression)other.substring(1, 2)));
        rv.add(expr.contains((Expression)other.substring(1)));
        rv.add(expr.contains((Expression)other.substring(2)));
        rv.add(expr.containsIgnoreCase((Expression)other));
        rv.add(expr.containsIgnoreCase((Expression)other.lower()));
        rv.add(expr.containsIgnoreCase((Expression)other.upper()));
        rv.add(expr.containsIgnoreCase((Expression)other.substring(0, 1)));
        rv.add(expr.containsIgnoreCase((Expression)other.substring(0, 2).lower()));
        rv.add(expr.containsIgnoreCase((Expression)other.substring(1, 2).upper()));
        rv.add(expr.containsIgnoreCase((Expression)other.substring(1).lower()));
        rv.add(expr.containsIgnoreCase((Expression)other.substring(2).upper()));
        rv.add(expr.endsWith((Expression)other));
        rv.add(expr.endsWith((Expression)other.substring(1)));
        rv.add(expr.endsWith((Expression)other.substring(2)));
        rv.add(expr.endsWithIgnoreCase((Expression)other));
        rv.add(expr.endsWithIgnoreCase((Expression)other.substring(1)));
        rv.add(expr.endsWithIgnoreCase((Expression)other.substring(2)));
        rv.add(expr.eq((Expression)other));
        rv.add(expr.equalsIgnoreCase((Expression)other));
        if (this.module != QuerydslModule.LUCENE) {
            rv.add(expr.indexOf((Expression)other).eq((Object)0));
            rv.add(expr.locate((Expression)other).eq((Object)1));
        }
        if (this.target != Target.DERBY && this.module != QuerydslModule.LUCENE) {
            rv.add(expr.indexOf((Expression)other.substring(1)).eq((Object)1));
            rv.add(expr.indexOf((Expression)other.substring(2)).eq((Object)2));
        }
        if (this.module != QuerydslModule.LUCENE) {
            rv.add(expr.isEmpty().not());
            rv.add(expr.isNotEmpty());
        }
        if (this.module != QuerydslModule.LUCENE) {
            rv.add(expr.length().eq((Expression)other.length()));
            rv.add(expr.like((Expression)other));
            if (this.module != QuerydslModule.JDO || other instanceof Constant) {
                rv.add(expr.like((Expression)other.substring(0, 1).append("%")));
                rv.add(expr.like((Expression)other.substring(0, 1).append("%").append((Expression)other.substring(2))));
                rv.add(expr.like((Expression)other.substring(1).prepend("%")));
                rv.add(expr.like((Expression)other.substring(1, 2).append("%").prepend("%")));
            }
        }
        rv.add(expr.lower().eq((Expression)other.lower()));
        if (this.module != QuerydslModule.LUCENE) {
            if (!(this.module.equals((Object)QuerydslModule.SQL) && (this.target.equals((Object)Target.HSQLDB) || this.target.equals((Object)Target.FIREBIRD) || this.target.equals((Object)Target.H2) || this.target.equals((Object)Target.DB2) || this.target.equals((Object)Target.DERBY) || this.target.equals((Object)Target.SQLITE) || this.target.equals((Object)Target.SQLSERVER)))) {
                rv.add(expr.matches((Expression)other));
                if (this.module != QuerydslModule.JDO || other instanceof Constant) {
                    rv.add(expr.matches((Expression)other.substring(0, 1).append(".*")));
                    rv.add(expr.matches((Expression)other.substring(0, 1).append(".").append((Expression)other.substring(2))));
                    rv.add(expr.matches((Expression)other.substring(1).prepend(".*")));
                    rv.add(expr.matches((Expression)other.substring(1, 2).prepend(".*").append(".*")));
                }
            }
            rv.add(expr.ne((Expression)other));
        }
        rv.add(expr.startsWith((Expression)other));
        rv.add(expr.startsWith((Expression)other.substring(0, 1)));
        rv.add(expr.startsWith((Expression)other.substring(0, 2)));
        rv.add(expr.startsWithIgnoreCase((Expression)other));
        rv.add(expr.startsWithIgnoreCase((Expression)other.substring(0, 1)));
        rv.add(expr.startsWithIgnoreCase((Expression)other.substring(0, 2)));
        if (this.module != QuerydslModule.LUCENE) {
            rv.add(expr.substring(0, 1).eq((Expression)other.substring(0, 1)));
            rv.add(expr.substring(1, 2).eq((Expression)other.substring(1, 2)));
            rv.add(expr.substring(1).eq((Expression)other.substring(1)));
            rv.add(expr.trim().eq((Expression)other.trim()));
        }
        rv.add(expr.upper().eq((Expression)other.upper()));
        return Collections.unmodifiableSet(rv);
    }

    public Collection<Predicate> string(StringExpression expr, StringExpression other, String knownValue) {
        HashSet<Predicate> rv = new HashSet<Predicate>();
        rv.addAll(this.string(expr, other));
        rv.addAll(this.string(expr, StringConstant.create(knownValue)));
        return Collections.unmodifiableSet(rv);
    }

    public Collection<Predicate> time(TimeExpression<Time> expr, TimeExpression<Time> other) {
        HashSet<Predicate> rv = new HashSet<Predicate>(this.comparable((ComparableExpression)expr, (Expression)other));
        rv.add((Predicate)expr.milliSecond().eq((Expression)other.milliSecond()));
        rv.add((Predicate)expr.second().eq((Expression)other.second()));
        rv.add((Predicate)expr.minute().eq((Expression)other.minute()));
        rv.add((Predicate)expr.hour().eq((Expression)other.hour()));
        return Collections.unmodifiableSet(rv);
    }

    public Collection<Predicate> time(TimeExpression<Time> expr, TimeExpression<Time> other, Time knownValue) {
        HashSet<Predicate> rv = new HashSet<Predicate>();
        rv.addAll(this.time(expr, other));
        rv.addAll(this.time(expr, TimeConstant.create(knownValue)));
        return Collections.unmodifiableSet(rv);
    }
}

