/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.testutil;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.runners.Parameterized;
import org.junit.runners.model.RunnerScheduler;

public class Parallelized
extends Parameterized {
    public Parallelized(Class<?> klass) throws Throwable {
        super(klass);
        this.setScheduler(new ThreadPoolScheduler());
    }

    private static class ThreadPoolScheduler
    implements RunnerScheduler {
        private ExecutorService executor;

        ThreadPoolScheduler() {
            int numThreads = Runtime.getRuntime().availableProcessors();
            this.executor = Executors.newFixedThreadPool(numThreads);
        }

        public void finished() {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(10L, TimeUnit.MINUTES);
            }
            catch (InterruptedException exc) {
                throw new RuntimeException(exc);
            }
        }

        public void schedule(Runnable childStatement) {
            this.executor.submit(childStatement);
        }
    }
}

