/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.types.Concatenation;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.FactoryExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.PathBuilderFactory;
import com.querydsl.core.types.dsl.StringPath;
import java.util.LinkedHashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QBeanFieldAccessTest {
    private PathBuilder<Entity> entity;
    private StringPath name;
    private StringPath name2;
    private NumberPath<Integer> age;
    private BooleanPath married;

    @Before
    public void setUp() {
        this.entity = new PathBuilderFactory().create(Entity.class);
        this.name = this.entity.getString("name");
        this.name2 = this.entity.getString("name2");
        this.age = this.entity.getNumber("age", Integer.class);
        this.married = this.entity.getBoolean("married");
    }

    @Test
    public void with_class_and_exprs_using_fields() {
        QBean beanProjection = new QBean(Entity.class, true, new Expression[]{this.name, this.age, this.married});
        Entity bean = (Entity)beanProjection.newInstance(new Object[]{"Fritz", 30, true});
        Assert.assertEquals((Object)"Fritz", (Object)bean.name);
        Assert.assertEquals((long)30L, (long)bean.age);
        Assert.assertEquals((Object)true, (Object)bean.married);
    }

    @Test
    public void with_path_and_exprs_using_fields() {
        QBean beanProjection = Projections.fields(this.entity, (Expression[])new Expression[]{this.name, this.age, this.married});
        Entity bean = (Entity)beanProjection.newInstance(new Object[]{"Fritz", 30, true});
        Assert.assertEquals((Object)"Fritz", (Object)bean.name);
        Assert.assertEquals((long)30L, (long)bean.age);
        Assert.assertEquals((Object)true, (Object)bean.married);
    }

    @Test
    public void with_class_and_map_using_fields() {
        LinkedHashMap<String, Object> bindings = new LinkedHashMap<String, Object>();
        bindings.put("name", this.name);
        bindings.put("age", this.age);
        bindings.put("married", this.married);
        QBean beanProjection = new QBean(Entity.class, true, bindings);
        Entity bean = (Entity)beanProjection.newInstance(new Object[]{"Fritz", 30, true});
        Assert.assertEquals((Object)"Fritz", (Object)bean.name);
        Assert.assertEquals((long)30L, (long)bean.age);
        Assert.assertEquals((Object)true, (Object)bean.married);
    }

    @Test
    public void with_class_and_alias_using_fields() {
        StringPath name2 = Expressions.stringPath((String)"name2");
        QBean beanProjection = new QBean(Entity.class, true, new Expression[]{this.name.as((Path)name2), this.age, this.married});
        Entity bean = (Entity)beanProjection.newInstance(new Object[]{"Fritz", 30, true});
        Assert.assertNull((Object)bean.name);
        Assert.assertEquals((Object)"Fritz", (Object)bean.name2);
        Assert.assertEquals((long)30L, (long)bean.age);
        Assert.assertEquals((Object)true, (Object)bean.married);
    }

    @Test
    public void with_nested_factoryExpression() {
        LinkedHashMap<String, Object> bindings = new LinkedHashMap<String, Object>();
        bindings.put("age", this.age);
        bindings.put("name", (Object)new Concatenation(new Expression[]{this.name, this.name2}));
        QBean beanProjection = new QBean(Entity.class, true, bindings);
        FactoryExpression wrappedProjection = FactoryExpressionUtils.wrap((FactoryExpression)beanProjection);
        Entity bean = (Entity)wrappedProjection.newInstance(new Object[]{30, "Fri", "tz"});
        Assert.assertEquals((Object)"Fritz", (Object)bean.name);
    }

    public static class Entity {
        String name;
        String name2;
        int age;
        boolean married;
    }
}

