/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.types.Concatenation;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.FactoryExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.PathBuilderFactory;
import com.querydsl.core.types.dsl.StringPath;
import java.util.LinkedHashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QBeanTest {
    private PathBuilder<Entity> entity;
    private StringPath name;
    private StringPath name2;
    private NumberPath<Integer> age;
    private BooleanPath married;

    @Before
    public void setUp() {
        this.entity = new PathBuilderFactory().create(Entity.class);
        this.name = this.entity.getString("name");
        this.name2 = this.entity.getString("name2");
        this.age = this.entity.getNumber("age", Integer.class);
        this.married = this.entity.getBoolean("married");
    }

    @Test
    public void with_class_and_exprs() {
        QBean beanProjection = new QBean(Entity.class, new Expression[]{this.name, this.age, this.married});
        Entity bean = (Entity)beanProjection.newInstance(new Object[]{"Fritz", 30, true});
        Assert.assertEquals((Object)"Fritz", (Object)bean.getName());
        Assert.assertEquals((long)30L, (long)bean.getAge());
        Assert.assertEquals((Object)true, (Object)bean.isMarried());
    }

    @Test
    public void with_path_and_exprs() {
        QBean beanProjection = Projections.bean(this.entity, (Expression[])new Expression[]{this.name, this.age, this.married});
        Entity bean = (Entity)beanProjection.newInstance(new Object[]{"Fritz", 30, true});
        Assert.assertEquals((Object)"Fritz", (Object)bean.getName());
        Assert.assertEquals((long)30L, (long)bean.getAge());
        Assert.assertEquals((Object)true, (Object)bean.isMarried());
    }

    @Test
    public void with_unknown_properties() {
        QBean beanProjection = Projections.bean(this.entity, (Expression[])new Expression[]{this.name, this.age, Expressions.booleanPath((String)"unknown")});
        Entity bean = (Entity)beanProjection.newInstance(new Object[]{"Fritz", 30, true});
        Assert.assertEquals((Object)"Fritz", (Object)bean.getName());
        Assert.assertEquals((long)30L, (long)bean.getAge());
    }

    @Test
    public void with_class_and_map() {
        LinkedHashMap<String, Object> bindings = new LinkedHashMap<String, Object>();
        bindings.put("name", this.name);
        bindings.put("age", this.age);
        bindings.put("married", this.married);
        QBean beanProjection = new QBean(Entity.class, bindings);
        Entity bean = (Entity)beanProjection.newInstance(new Object[]{"Fritz", 30, true});
        Assert.assertEquals((Object)"Fritz", (Object)bean.getName());
        Assert.assertEquals((long)30L, (long)bean.getAge());
        Assert.assertEquals((Object)true, (Object)bean.isMarried());
    }

    @Test
    public void with_class_and_alias() {
        StringPath name2 = Expressions.stringPath((String)"name2");
        QBean beanProjection = new QBean(Entity.class, new Expression[]{this.name.as((Path)name2), this.age, this.married});
        Entity bean = (Entity)beanProjection.newInstance(new Object[]{"Fritz", 30, true});
        Assert.assertNull((Object)bean.getName());
        Assert.assertEquals((Object)"Fritz", (Object)bean.getName2());
        Assert.assertEquals((long)30L, (long)bean.getAge());
        Assert.assertEquals((Object)true, (Object)bean.isMarried());
    }

    @Test
    public void with_nested_factoryExpression() {
        LinkedHashMap<String, Object> bindings = new LinkedHashMap<String, Object>();
        bindings.put("age", this.age);
        bindings.put("name", (Object)new Concatenation(new Expression[]{this.name, this.name2}));
        QBean beanProjection = new QBean(Entity.class, bindings);
        FactoryExpression wrappedProjection = FactoryExpressionUtils.wrap((FactoryExpression)beanProjection);
        Entity bean = (Entity)wrappedProjection.newInstance(new Object[]{30, "Fri", "tz"});
        Assert.assertEquals((Object)"Fritz", (Object)bean.getName());
    }

    @Test
    public void with_nested_factoryExpression2() {
        QBean beanProjection = new QBean(Entity.class, new Expression[]{this.age, ExpressionUtils.as((Expression)new Concatenation(new Expression[]{this.name, this.name2}), (String)"name")});
        FactoryExpression wrappedProjection = FactoryExpressionUtils.wrap((FactoryExpression)beanProjection);
        Entity bean = (Entity)wrappedProjection.newInstance(new Object[]{30, "Fri", "tz"});
        Assert.assertEquals((Object)"Fritz", (Object)bean.getName());
    }

    @Test
    public void supertype_population() {
        QBean beanProjection = new QBean(SubEntity.class, true, new Expression[]{this.name, this.age, this.married});
        SubEntity bean = (SubEntity)beanProjection.newInstance(new Object[]{"Fritz", 30, true});
        Assert.assertEquals((Object)"Fritz", (Object)bean.getName());
        Assert.assertEquals((long)30L, (long)bean.getAge());
        Assert.assertEquals((Object)true, (Object)bean.isMarried());
    }

    @Test
    public void skipNulls() {
        QBean bean = Projections.bean(Object.class, (Expression[])new Expression[0]);
        Assert.assertEquals((Object)bean, (Object)bean);
        Assert.assertEquals((Object)bean.skipNulls(), (Object)bean.skipNulls());
        Assert.assertFalse((boolean)bean.skipNulls().equals(bean));
        Assert.assertFalse((boolean)bean.equals((Object)bean.skipNulls()));
    }

    @Test
    public void alias() {
        QBean beanProjection = new QBean(Entity.class, new Expression[]{this.name.as("name2")});
        Assert.assertEquals((Object)this.name.as("name2"), beanProjection.getArgs().get(0));
    }

    public static class Entity {
        private String name;
        private String name2;
        private int age;
        private boolean married;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public boolean isMarried() {
            return this.married;
        }

        public void setMarried(boolean married) {
            this.married = married;
        }

        public String getName2() {
            return this.name2;
        }

        public void setName2(String name2) {
            this.name2 = name2;
        }
    }

    public static class SubEntity
    extends Entity {
    }
}

