/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types.dsl;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.Expressions;
import org.junit.Assert;
import org.junit.Test;

public class BooleanExpressionTest {
    private final BooleanExpression a = new BooleanPath("a");
    private final BooleanExpression b = new BooleanPath("b");
    private final BooleanExpression c = new BooleanPath("c");

    @Test
    public void anyOf() {
        Assert.assertEquals((Object)this.a.or((Predicate)this.b).or((Predicate)this.c), (Object)Expressions.anyOf((BooleanExpression[])new BooleanExpression[]{this.a, this.b, this.c}));
    }

    @Test
    public void allOf() {
        Assert.assertEquals((Object)this.a.and((Predicate)this.b).and((Predicate)this.c), (Object)Expressions.allOf((BooleanExpression[])new BooleanExpression[]{this.a, this.b, this.c}));
    }

    @Test
    public void allOf_with_nulls() {
        Assert.assertEquals((Object)"a && b", (Object)Expressions.allOf((BooleanExpression[])new BooleanExpression[]{this.a, this.b, null}).toString());
        Assert.assertEquals((Object)"a", (Object)Expressions.allOf((BooleanExpression[])new BooleanExpression[]{this.a, null}).toString());
        Assert.assertEquals((Object)"a", (Object)Expressions.allOf((BooleanExpression[])new BooleanExpression[]{null, this.a}).toString());
    }

    @Test
    public void anyOf_with_nulls() {
        Assert.assertEquals((Object)"a || b", (Object)Expressions.anyOf((BooleanExpression[])new BooleanExpression[]{this.a, this.b, null}).toString());
        Assert.assertEquals((Object)"a", (Object)Expressions.anyOf((BooleanExpression[])new BooleanExpression[]{this.a, null}).toString());
        Assert.assertEquals((Object)"a", (Object)Expressions.anyOf((BooleanExpression[])new BooleanExpression[]{null, this.a}).toString());
    }

    @Test
    public void andAnyOf() {
        Assert.assertEquals((Object)this.a.and((Predicate)this.b.or((Predicate)this.c)), (Object)this.a.andAnyOf(new Predicate[]{this.b, this.c}));
    }

    @Test
    public void orAllOf() {
        Assert.assertEquals((Object)this.a.or((Predicate)this.b.and((Predicate)this.c)), (Object)this.a.orAllOf(new Predicate[]{this.b, this.c}));
    }

    @Test
    public void not() {
        Assert.assertEquals((Object)this.a, (Object)this.a.not().not());
    }

    @Test
    public void isTrue() {
        Assert.assertEquals((Object)this.a.eq(Boolean.valueOf(true)), (Object)this.a.isTrue());
    }

    @Test
    public void isFalse() {
        Assert.assertEquals((Object)this.a.eq(Boolean.valueOf(false)), (Object)this.a.isFalse());
    }
}

