/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.util;

import com.querydsl.core.types.ProjectionExample;
import com.querydsl.core.util.ArrayUtils;
import com.querydsl.core.util.ConstructorUtils;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class ConstructorUtilsTest {
    @Test
    public void getDefaultConstructor() {
        Class[] args = new Class[]{};
        Constructor<ProjectionExample> emptyDefaultConstructor = this.getConstructor(ProjectionExample.class, args);
        Constructor<ProjectionExample> nullDefaultConstructor = this.getConstructor(ProjectionExample.class, null);
        Assert.assertNotNull(emptyDefaultConstructor);
        Assert.assertNotNull(nullDefaultConstructor);
        Assert.assertTrue((ArrayUtils.isEmpty((Object[])emptyDefaultConstructor.getParameterTypes()) && ArrayUtils.isEmpty((Object[])nullDefaultConstructor.getParameterTypes()) ? 1 : 0) != 0);
    }

    @Test
    public void getSimpleConstructor() {
        Object[] args = new Class[]{Long.class};
        Constructor<ProjectionExample> constructor = this.getConstructor((Class)ProjectionExample.class, (Class<?>[])args);
        Assert.assertNotNull(constructor);
        Assert.assertArrayEquals((Object[])args, (Object[])constructor.getParameterTypes());
    }

    @Test
    public void getDefaultConstructorParameters() {
        Class[] args = new Class[]{Long.class, String.class};
        Object[] expected = new Class[]{Long.TYPE, String.class};
        Object[] constructorParameters = ConstructorUtils.getConstructorParameters(ProjectionExample.class, (Class[])args);
        Assert.assertArrayEquals((String)"Constructorparameters not equal", (Object[])expected, (Object[])constructorParameters);
    }

    private <C> Constructor<C> getConstructor(Class<C> type, Class<?>[] givenTypes) {
        Constructor rv = null;
        try {
            rv = ConstructorUtils.getConstructor(type, (Class[])givenTypes);
        }
        catch (NoSuchMethodException ex) {
            Assert.fail((String)("No constructor found for " + type.toString() + " with parameters: " + Arrays.toString(givenTypes)));
        }
        return rv;
    }
}

