/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.lucene4;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.QueryException;
import java.io.IOException;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.jetbrains.annotations.Nullable;

public final class ResultIterator<T>
implements CloseableIterator<T> {
    private final ScoreDoc[] scoreDocs;
    private int cursor;
    private final IndexSearcher searcher;
    @Nullable
    private final Set<String> fieldsToLoad;
    private final Function<Document, T> transformer;

    public ResultIterator(ScoreDoc[] scoreDocs, int offset, IndexSearcher searcher, @Nullable Set<String> fieldsToLoad, Function<Document, T> transformer) {
        this.scoreDocs = (ScoreDoc[])scoreDocs.clone();
        this.cursor = offset;
        this.searcher = searcher;
        this.fieldsToLoad = fieldsToLoad;
        this.transformer = transformer;
    }

    public boolean hasNext() {
        return this.cursor != this.scoreDocs.length;
    }

    public T next() {
        try {
            Document document = this.fieldsToLoad != null ? this.searcher.doc(this.scoreDocs[this.cursor++].doc, this.fieldsToLoad) : this.searcher.doc(this.scoreDocs[this.cursor++].doc);
            return this.transformer.apply(document);
        }
        catch (IOException e) {
            throw new QueryException((Throwable)e);
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }
}

