/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.MissedHeartbeatException;
import com.rabbitmq.client.PossibleAuthenticationFailureException;
import com.rabbitmq.client.ProtocolVersionMismatchException;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQChannel;
import com.rabbitmq.client.impl.AMQCommand;
import com.rabbitmq.client.impl.AMQImpl;
import com.rabbitmq.client.impl.ChannelManager;
import com.rabbitmq.client.impl.ChannelN;
import com.rabbitmq.client.impl.DefaultExceptionHandler;
import com.rabbitmq.client.impl.ExceptionHandler;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.FrameHandler;
import com.rabbitmq.client.impl.HeartbeatSender;
import com.rabbitmq.client.impl.LongString;
import com.rabbitmq.client.impl.LongStringHelper;
import com.rabbitmq.client.impl.Method;
import com.rabbitmq.client.impl.ShutdownNotifierComponent;
import com.rabbitmq.client.impl.Version;
import com.rabbitmq.utility.BlockingCell;
import com.rabbitmq.utility.Utility;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.security.sasl.SaslClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQConnection
extends ShutdownNotifierComponent
implements Connection {
    public static final int HANDSHAKE_TIMEOUT = 10000;
    public static final int CONNECTION_CLOSING_TIMEOUT = 10000;
    private static final Version clientVersion = new Version(0, 9);
    private final ConnectionFactory _factory;
    private final AMQChannel _channel0 = new AMQChannel(this, 0){

        public boolean processAsync(Command c) throws IOException {
            return this._connection.processControlCommand(c);
        }
    };
    public ChannelManager _channelManager = new ChannelManager(0);
    private final FrameHandler _frameHandler;
    private volatile boolean _running = false;
    private int _frameMax;
    private final ExceptionHandler _exceptionHandler;
    private BlockingCell<Object> _appContinuation = new BlockingCell();
    private boolean _brokerInitiatedShutdown = false;
    private final HeartbeatSender _heartbeatSender;
    private int _missedHeartbeats;
    private int _heartbeat;
    private final String _virtualHost;
    private final int _requestedChannelMax;
    private final int _requestedFrameMax;
    private final int _requestedHeartbeat;
    private final Map<String, Object> _clientProperties;
    public Map<String, Object> _serverProperties;

    public static Map<String, Object> defaultClientProperties() {
        return Frame.buildTable(new Object[]{"product", LongStringHelper.asLongString("RabbitMQ"), "version", LongStringHelper.asLongString("2.3.0"), "platform", LongStringHelper.asLongString("Java"), "copyright", LongStringHelper.asLongString("Copyright (C) 2007-2011 VMware, Inc."), "information", LongStringHelper.asLongString("Licensed under the MPL. See http://www.rabbitmq.com/")});
    }

    public final void disconnectChannel(ChannelN channel) {
        this._channelManager.disconnectChannel(channel);
    }

    public void ensureIsOpen() throws AlreadyClosedException {
        if (!this.isOpen()) {
            throw new AlreadyClosedException("Attempt to use closed connection", this);
        }
    }

    @Override
    public String getHost() {
        return this._frameHandler.getHost();
    }

    @Override
    public int getPort() {
        return this._frameHandler.getPort();
    }

    public FrameHandler getFrameHandler() {
        return this._frameHandler;
    }

    @Override
    public Map<String, Object> getServerProperties() {
        return this._serverProperties;
    }

    public AMQConnection(ConnectionFactory factory, FrameHandler frameHandler) {
        this(factory, frameHandler, new DefaultExceptionHandler());
    }

    public AMQConnection(ConnectionFactory factory, FrameHandler frameHandler, ExceptionHandler exceptionHandler) {
        this.checkPreconditions();
        this._virtualHost = factory.getVirtualHost();
        this._requestedChannelMax = factory.getRequestedChannelMax();
        this._requestedFrameMax = factory.getRequestedFrameMax();
        this._requestedHeartbeat = factory.getRequestedHeartbeat();
        this._clientProperties = new HashMap<String, Object>(factory.getClientProperties());
        this._factory = factory;
        this._heartbeatSender = new HeartbeatSender(frameHandler);
        this._frameHandler = frameHandler;
        this._running = true;
        this._frameMax = 0;
        this._missedHeartbeats = 0;
        this._heartbeat = 0;
        this._exceptionHandler = exceptionHandler;
        this._brokerInitiatedShutdown = false;
    }

    public void start() throws IOException {
        AMQChannel.SimpleBlockingRpcContinuation connStartBlocker = new AMQChannel.SimpleBlockingRpcContinuation();
        this._channel0.enqueueRpc(connStartBlocker);
        this._frameHandler.setTimeout(10000);
        this._frameHandler.sendHeader();
        MainLoop ml = new MainLoop();
        ml.setName("AMQP Connection " + this.getHost() + ":" + this.getPort());
        ml.start();
        AMQP.Connection.Start connStart = null;
        try {
            connStart = (AMQP.Connection.Start)((Object)((AMQCommand)connStartBlocker.getReply()).getMethod());
            this._serverProperties = connStart.getServerProperties();
            Version serverVersion = new Version(connStart.getVersionMajor(), connStart.getVersionMinor());
            if (!Version.checkVersion(clientVersion, serverVersion)) {
                this._frameHandler.close();
                throw new ProtocolVersionMismatchException(clientVersion, serverVersion);
            }
        }
        catch (ShutdownSignalException sse) {
            throw AMQChannel.wrap(sse);
        }
        String[] mechanisms = connStart.getMechanisms().toString().split(" ");
        SaslClient sc = this._factory.getSaslConfig().getSaslClient(mechanisms);
        if (sc == null) {
            throw new IOException("No compatible authentication mechanism found - server offered [" + connStart.getMechanisms() + "]");
        }
        LongString challenge = null;
        LongString response = LongStringHelper.asLongString(sc.hasInitialResponse() ? sc.evaluateChallenge(new byte[0]) : null);
        AMQP.Connection.Tune connTune = null;
        do {
            Method method = challenge == null ? new AMQImpl.Connection.StartOk(this._clientProperties, sc.getMechanismName(), response, "en_US") : new AMQImpl.Connection.SecureOk(response);
            try {
                Method serverResponse = this._channel0.rpc(method).getMethod();
                if (serverResponse instanceof AMQP.Connection.Tune) {
                    connTune = (AMQP.Connection.Tune)((Object)serverResponse);
                    continue;
                }
                challenge = ((AMQP.Connection.Secure)((Object)serverResponse)).getChallenge();
                response = LongStringHelper.asLongString(sc.evaluateChallenge(challenge.getBytes()));
            }
            catch (ShutdownSignalException e) {
                throw new PossibleAuthenticationFailureException(e);
            }
        } while (connTune == null);
        sc.dispose();
        if (!sc.isComplete()) {
            throw new RuntimeException(sc.getMechanismName() + " did not complete, server thought it did");
        }
        int channelMax = AMQConnection.negotiatedMaxValue(this._factory.getRequestedChannelMax(), connTune.getChannelMax());
        this._channelManager = new ChannelManager(channelMax);
        int frameMax = AMQConnection.negotiatedMaxValue(this._factory.getRequestedFrameMax(), connTune.getFrameMax());
        this.setFrameMax(frameMax);
        int heartbeat = AMQConnection.negotiatedMaxValue(this._factory.getRequestedHeartbeat(), connTune.getHeartbeat());
        this.setHeartbeat(heartbeat);
        this._channel0.transmit(new AMQImpl.Connection.TuneOk(channelMax, frameMax, heartbeat));
        Method res = this._channel0.exnWrappingRpc(new AMQImpl.Connection.Open(this._virtualHost, "", false)).getMethod();
    }

    public void checkPreconditions() {
        AMQCommand.checkEmptyContentBodyFrameSize();
    }

    @Override
    public int getChannelMax() {
        return this._channelManager.getChannelMax();
    }

    @Override
    public int getFrameMax() {
        return this._frameMax;
    }

    public void setFrameMax(int value) {
        this._frameMax = value;
    }

    @Override
    public int getHeartbeat() {
        return this._heartbeat;
    }

    public void setHeartbeat(int heartbeat) {
        try {
            this._heartbeatSender.setHeartbeat(heartbeat);
            this._heartbeat = heartbeat;
            this._frameHandler.setTimeout(heartbeat * 1000 / 4);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public Map<String, Object> getClientProperties() {
        return new HashMap<String, Object>(this._clientProperties);
    }

    public ExceptionHandler getExceptionHandler() {
        return this._exceptionHandler;
    }

    @Override
    public Channel createChannel(int channelNumber) throws IOException {
        this.ensureIsOpen();
        return this._channelManager.createChannel(this, channelNumber);
    }

    @Override
    public Channel createChannel() throws IOException {
        this.ensureIsOpen();
        return this._channelManager.createChannel(this);
    }

    public Frame readFrame() throws IOException {
        return this._frameHandler.readFrame();
    }

    public void writeFrame(Frame f) throws IOException {
        this._frameHandler.writeFrame(f);
        this._heartbeatSender.signalActivity();
    }

    private static int negotiatedMaxValue(int clientValue, int serverValue) {
        return clientValue == 0 || serverValue == 0 ? Math.max(clientValue, serverValue) : Math.min(clientValue, serverValue);
    }

    public void handleSocketTimeout() throws MissedHeartbeatException {
        if (this._heartbeat == 0) {
            return;
        }
        ++this._missedHeartbeats;
        if (this._missedHeartbeats > 8) {
            throw new MissedHeartbeatException("Heartbeat missing with heartbeat == " + this._heartbeat + " seconds");
        }
    }

    public boolean processControlCommand(Command c) throws IOException {
        Method method = c.getMethod();
        if (method instanceof AMQP.Connection.Close) {
            if (this.isOpen()) {
                this.handleConnectionClose(c);
            } else {
                try {
                    this._channel0.quiescingTransmit(new AMQImpl.Connection.CloseOk());
                }
                catch (IOException ioe) {
                    Utility.emptyStatement();
                }
            }
            return true;
        }
        if (this.isOpen()) {
            return false;
        }
        if (method instanceof AMQP.Connection.CloseOk) {
            this._running = false;
            return this._channel0._activeRpc == null;
        }
        return true;
    }

    public void handleConnectionClose(Command closeCommand) {
        ShutdownSignalException sse = this.shutdown(closeCommand, false, null, false);
        try {
            this._channel0.quiescingTransmit(new AMQImpl.Connection.CloseOk());
        }
        catch (IOException ioe) {
            Utility.emptyStatement();
        }
        this._heartbeatSender.shutdown();
        this._brokerInitiatedShutdown = true;
        SocketCloseWait scw = new SocketCloseWait(sse);
        scw.setName("AMQP Connection Closing Monitor " + this.getHost() + ":" + this.getPort());
        scw.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShutdownSignalException shutdown(Object reason, boolean initiatedByApplication, Throwable cause, boolean notifyRpc) {
        ShutdownSignalException sse = new ShutdownSignalException(true, initiatedByApplication, reason, this);
        sse.initCause(cause);
        AMQConnection aMQConnection = this;
        synchronized (aMQConnection) {
            if (initiatedByApplication) {
                this.ensureIsOpen();
            }
            if (this.isOpen()) {
                this._shutdownCause = sse;
            }
        }
        this._heartbeatSender.shutdown();
        this._channel0.processShutdownSignal(sse, !initiatedByApplication, notifyRpc);
        this._channelManager.handleSignal(sse);
        return sse;
    }

    @Override
    public void close() throws IOException {
        this.close(-1);
    }

    @Override
    public void close(int timeout) throws IOException {
        this.close(200, "OK", timeout);
    }

    @Override
    public void close(int closeCode, String closeMessage) throws IOException {
        this.close(closeCode, closeMessage, -1);
    }

    @Override
    public void close(int closeCode, String closeMessage, int timeout) throws IOException {
        this.close(closeCode, closeMessage, true, null, timeout, false);
    }

    @Override
    public void abort() {
        this.abort(-1);
    }

    @Override
    public void abort(int closeCode, String closeMessage) {
        this.abort(closeCode, closeMessage, -1);
    }

    @Override
    public void abort(int timeout) {
        this.abort(200, "OK", timeout);
    }

    @Override
    public void abort(int closeCode, String closeMessage, int timeout) {
        try {
            this.close(closeCode, closeMessage, true, null, timeout, true);
        }
        catch (IOException e) {
            Utility.emptyStatement();
        }
    }

    public void close(int closeCode, String closeMessage, boolean initiatedByApplication, Throwable cause) throws IOException {
        this.close(closeCode, closeMessage, initiatedByApplication, cause, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int closeCode, String closeMessage, boolean initiatedByApplication, Throwable cause, int timeout, boolean abort) throws IOException {
        boolean sync = !(Thread.currentThread() instanceof MainLoop);
        try {
            AMQImpl.Connection.Close reason = new AMQImpl.Connection.Close(closeCode, closeMessage, 0, 0);
            this.shutdown(reason, initiatedByApplication, cause, true);
            if (sync) {
                AMQChannel.SimpleBlockingRpcContinuation k = new AMQChannel.SimpleBlockingRpcContinuation();
                this._channel0.quiescingRpc(reason, k);
                k.getReply(timeout);
            } else {
                this._channel0.quiescingTransmit(reason);
            }
        }
        catch (TimeoutException tte) {
            if (!abort) {
                throw new ShutdownSignalException(true, true, tte, this);
            }
        }
        catch (ShutdownSignalException sse) {
            if (!abort) {
                throw sse;
            }
        }
        catch (IOException ioe) {
            if (!abort) {
                throw ioe;
            }
        }
        finally {
            if (sync) {
                this._frameHandler.close();
            }
        }
    }

    public String toString() {
        return "amqp://" + this._factory.getUsername() + "@" + this.getHost() + ":" + this.getPort() + this._virtualHost;
    }

    private class SocketCloseWait
    extends Thread {
        private ShutdownSignalException cause;

        public SocketCloseWait(ShutdownSignalException sse) {
            this.cause = sse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                AMQConnection.this._appContinuation.uninterruptibleGet(10000);
            }
            catch (TimeoutException ise) {
                AMQConnection.this._frameHandler.close();
            }
            finally {
                AMQConnection.this._running = false;
                AMQConnection.this._channel0.notifyOutstandingRpc(this.cause);
            }
        }
    }

    private class MainLoop
    extends Thread {
        private MainLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (AMQConnection.this._running) {
                    Frame frame = AMQConnection.this.readFrame();
                    if (frame != null) {
                        AMQConnection.this._missedHeartbeats = 0;
                        if (frame.type == 8) continue;
                        if (frame.channel == 0) {
                            AMQConnection.this._channel0.handleFrame(frame);
                            continue;
                        }
                        if (!AMQConnection.this.isOpen()) continue;
                        AMQConnection.this._channelManager.getChannel(frame.channel).handleFrame(frame);
                        continue;
                    }
                    AMQConnection.this.handleSocketTimeout();
                }
            }
            catch (EOFException ex) {
                if (!AMQConnection.this._brokerInitiatedShutdown) {
                    AMQConnection.this.shutdown(ex, false, ex, true);
                }
            }
            catch (Throwable ex) {
                AMQConnection.this._exceptionHandler.handleUnexpectedConnectionDriverException(AMQConnection.this, ex);
                AMQConnection.this.shutdown(ex, false, ex, true);
            }
            finally {
                AMQConnection.this._frameHandler.close();
                AMQConnection.this._appContinuation.set(null);
                AMQConnection.this.notifyListeners();
            }
        }
    }
}

