/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.LongString;
import com.rabbitmq.client.UnexpectedMethodError;
import com.rabbitmq.client.UnknownClassOrMethodId;
import com.rabbitmq.client.impl.AMQContentHeader;
import com.rabbitmq.client.impl.Method;
import com.rabbitmq.client.impl.MethodArgumentReader;
import com.rabbitmq.client.impl.MethodArgumentWriter;
import com.rabbitmq.client.impl.ValueReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AMQImpl
implements AMQP {
    public static Method readMethodFrom(DataInputStream in) throws IOException {
        short classId = in.readShort();
        short methodId = in.readShort();
        switch (classId) {
            case 10: {
                switch (methodId) {
                    case 10: {
                        return new Connection.Start(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 11: {
                        return new Connection.StartOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 20: {
                        return new Connection.Secure(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 21: {
                        return new Connection.SecureOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 30: {
                        return new Connection.Tune(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 31: {
                        return new Connection.TuneOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 40: {
                        return new Connection.Open(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 41: {
                        return new Connection.OpenOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 50: {
                        return new Connection.Close(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 51: {
                        return new Connection.CloseOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 60: {
                        return new Connection.Blocked(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 61: {
                        return new Connection.Unblocked(new MethodArgumentReader(new ValueReader(in)));
                    }
                }
                break;
            }
            case 20: {
                switch (methodId) {
                    case 10: {
                        return new Channel.Open(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 11: {
                        return new Channel.OpenOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 20: {
                        return new Channel.Flow(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 21: {
                        return new Channel.FlowOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 40: {
                        return new Channel.Close(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 41: {
                        return new Channel.CloseOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                }
                break;
            }
            case 30: {
                switch (methodId) {
                    case 10: {
                        return new Access.Request(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 11: {
                        return new Access.RequestOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                }
                break;
            }
            case 40: {
                switch (methodId) {
                    case 10: {
                        return new Exchange.Declare(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 11: {
                        return new Exchange.DeclareOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 20: {
                        return new Exchange.Delete(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 21: {
                        return new Exchange.DeleteOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 30: {
                        return new Exchange.Bind(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 31: {
                        return new Exchange.BindOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 40: {
                        return new Exchange.Unbind(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 51: {
                        return new Exchange.UnbindOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                }
                break;
            }
            case 50: {
                switch (methodId) {
                    case 10: {
                        return new Queue.Declare(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 11: {
                        return new Queue.DeclareOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 20: {
                        return new Queue.Bind(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 21: {
                        return new Queue.BindOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 30: {
                        return new Queue.Purge(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 31: {
                        return new Queue.PurgeOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 40: {
                        return new Queue.Delete(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 41: {
                        return new Queue.DeleteOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 50: {
                        return new Queue.Unbind(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 51: {
                        return new Queue.UnbindOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                }
                break;
            }
            case 60: {
                switch (methodId) {
                    case 10: {
                        return new Basic.Qos(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 11: {
                        return new Basic.QosOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 20: {
                        return new Basic.Consume(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 21: {
                        return new Basic.ConsumeOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 30: {
                        return new Basic.Cancel(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 31: {
                        return new Basic.CancelOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 40: {
                        return new Basic.Publish(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 50: {
                        return new Basic.Return(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 60: {
                        return new Basic.Deliver(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 70: {
                        return new Basic.Get(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 71: {
                        return new Basic.GetOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 72: {
                        return new Basic.GetEmpty(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 80: {
                        return new Basic.Ack(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 90: {
                        return new Basic.Reject(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 100: {
                        return new Basic.RecoverAsync(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 110: {
                        return new Basic.Recover(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 111: {
                        return new Basic.RecoverOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 120: {
                        return new Basic.Nack(new MethodArgumentReader(new ValueReader(in)));
                    }
                }
                break;
            }
            case 90: {
                switch (methodId) {
                    case 10: {
                        return new Tx.Select(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 11: {
                        return new Tx.SelectOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 20: {
                        return new Tx.Commit(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 21: {
                        return new Tx.CommitOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 30: {
                        return new Tx.Rollback(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 31: {
                        return new Tx.RollbackOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                }
                break;
            }
            case 85: {
                switch (methodId) {
                    case 10: {
                        return new Confirm.Select(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 11: {
                        return new Confirm.SelectOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                }
            }
        }
        throw new UnknownClassOrMethodId(classId, methodId);
    }

    public static AMQContentHeader readContentHeaderFrom(DataInputStream in) throws IOException {
        short classId = in.readShort();
        switch (classId) {
            case 60: {
                return new AMQP.BasicProperties(in);
            }
        }
        throw new UnknownClassOrMethodId(classId);
    }

    public static class DefaultMethodVisitor
    implements MethodVisitor {
        public Object visit(Connection.Start x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.StartOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.Secure x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.SecureOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.Tune x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.TuneOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.Open x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.OpenOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.Close x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.CloseOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.Blocked x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.Unblocked x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Channel.Open x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Channel.OpenOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Channel.Flow x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Channel.FlowOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Channel.Close x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Channel.CloseOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Access.Request x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Access.RequestOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Exchange.Declare x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Exchange.DeclareOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Exchange.Delete x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Exchange.DeleteOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Exchange.Bind x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Exchange.BindOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Exchange.Unbind x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Exchange.UnbindOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.Declare x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.DeclareOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.Bind x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.BindOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.Purge x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.PurgeOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.Delete x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.DeleteOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.Unbind x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.UnbindOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Qos x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.QosOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Consume x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.ConsumeOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Cancel x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.CancelOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Publish x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Return x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Deliver x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Get x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.GetOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.GetEmpty x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Ack x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Reject x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.RecoverAsync x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Recover x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.RecoverOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Nack x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Tx.Select x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Tx.SelectOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Tx.Commit x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Tx.CommitOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Tx.Rollback x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Tx.RollbackOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Confirm.Select x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Confirm.SelectOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }
    }

    public static interface MethodVisitor {
        public Object visit(Connection.Start var1) throws IOException;

        public Object visit(Connection.StartOk var1) throws IOException;

        public Object visit(Connection.Secure var1) throws IOException;

        public Object visit(Connection.SecureOk var1) throws IOException;

        public Object visit(Connection.Tune var1) throws IOException;

        public Object visit(Connection.TuneOk var1) throws IOException;

        public Object visit(Connection.Open var1) throws IOException;

        public Object visit(Connection.OpenOk var1) throws IOException;

        public Object visit(Connection.Close var1) throws IOException;

        public Object visit(Connection.CloseOk var1) throws IOException;

        public Object visit(Connection.Blocked var1) throws IOException;

        public Object visit(Connection.Unblocked var1) throws IOException;

        public Object visit(Channel.Open var1) throws IOException;

        public Object visit(Channel.OpenOk var1) throws IOException;

        public Object visit(Channel.Flow var1) throws IOException;

        public Object visit(Channel.FlowOk var1) throws IOException;

        public Object visit(Channel.Close var1) throws IOException;

        public Object visit(Channel.CloseOk var1) throws IOException;

        public Object visit(Access.Request var1) throws IOException;

        public Object visit(Access.RequestOk var1) throws IOException;

        public Object visit(Exchange.Declare var1) throws IOException;

        public Object visit(Exchange.DeclareOk var1) throws IOException;

        public Object visit(Exchange.Delete var1) throws IOException;

        public Object visit(Exchange.DeleteOk var1) throws IOException;

        public Object visit(Exchange.Bind var1) throws IOException;

        public Object visit(Exchange.BindOk var1) throws IOException;

        public Object visit(Exchange.Unbind var1) throws IOException;

        public Object visit(Exchange.UnbindOk var1) throws IOException;

        public Object visit(Queue.Declare var1) throws IOException;

        public Object visit(Queue.DeclareOk var1) throws IOException;

        public Object visit(Queue.Bind var1) throws IOException;

        public Object visit(Queue.BindOk var1) throws IOException;

        public Object visit(Queue.Purge var1) throws IOException;

        public Object visit(Queue.PurgeOk var1) throws IOException;

        public Object visit(Queue.Delete var1) throws IOException;

        public Object visit(Queue.DeleteOk var1) throws IOException;

        public Object visit(Queue.Unbind var1) throws IOException;

        public Object visit(Queue.UnbindOk var1) throws IOException;

        public Object visit(Basic.Qos var1) throws IOException;

        public Object visit(Basic.QosOk var1) throws IOException;

        public Object visit(Basic.Consume var1) throws IOException;

        public Object visit(Basic.ConsumeOk var1) throws IOException;

        public Object visit(Basic.Cancel var1) throws IOException;

        public Object visit(Basic.CancelOk var1) throws IOException;

        public Object visit(Basic.Publish var1) throws IOException;

        public Object visit(Basic.Return var1) throws IOException;

        public Object visit(Basic.Deliver var1) throws IOException;

        public Object visit(Basic.Get var1) throws IOException;

        public Object visit(Basic.GetOk var1) throws IOException;

        public Object visit(Basic.GetEmpty var1) throws IOException;

        public Object visit(Basic.Ack var1) throws IOException;

        public Object visit(Basic.Reject var1) throws IOException;

        public Object visit(Basic.RecoverAsync var1) throws IOException;

        public Object visit(Basic.Recover var1) throws IOException;

        public Object visit(Basic.RecoverOk var1) throws IOException;

        public Object visit(Basic.Nack var1) throws IOException;

        public Object visit(Tx.Select var1) throws IOException;

        public Object visit(Tx.SelectOk var1) throws IOException;

        public Object visit(Tx.Commit var1) throws IOException;

        public Object visit(Tx.CommitOk var1) throws IOException;

        public Object visit(Tx.Rollback var1) throws IOException;

        public Object visit(Tx.RollbackOk var1) throws IOException;

        public Object visit(Confirm.Select var1) throws IOException;

        public Object visit(Confirm.SelectOk var1) throws IOException;
    }

    public static class Confirm {
        public static final int INDEX = 85;

        public static class SelectOk
        extends Method
        implements AMQP.Confirm.SelectOk {
            public static final int INDEX = 11;

            public SelectOk() {
            }

            public SelectOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() {
                return 85;
            }

            public int protocolMethodId() {
                return 11;
            }

            public String protocolMethodName() {
                return "confirm.select-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Select
        extends Method
        implements AMQP.Confirm.Select {
            public static final int INDEX = 10;
            private final boolean nowait;

            public boolean getNowait() {
                return this.nowait;
            }

            public Select(boolean nowait) {
                this.nowait = nowait;
            }

            public Select(MethodArgumentReader rdr) throws IOException {
                this(rdr.readBit());
            }

            public int protocolClassId() {
                return 85;
            }

            public int protocolMethodId() {
                return 10;
            }

            public String protocolMethodName() {
                return "confirm.select";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(nowait=").append(this.nowait).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeBit(this.nowait);
            }
        }
    }

    public static class Tx {
        public static final int INDEX = 90;

        public static class RollbackOk
        extends Method
        implements AMQP.Tx.RollbackOk {
            public static final int INDEX = 31;

            public RollbackOk() {
            }

            public RollbackOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() {
                return 90;
            }

            public int protocolMethodId() {
                return 31;
            }

            public String protocolMethodName() {
                return "tx.rollback-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Rollback
        extends Method
        implements AMQP.Tx.Rollback {
            public static final int INDEX = 30;

            public Rollback() {
            }

            public Rollback(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() {
                return 90;
            }

            public int protocolMethodId() {
                return 30;
            }

            public String protocolMethodName() {
                return "tx.rollback";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class CommitOk
        extends Method
        implements AMQP.Tx.CommitOk {
            public static final int INDEX = 21;

            public CommitOk() {
            }

            public CommitOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() {
                return 90;
            }

            public int protocolMethodId() {
                return 21;
            }

            public String protocolMethodName() {
                return "tx.commit-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Commit
        extends Method
        implements AMQP.Tx.Commit {
            public static final int INDEX = 20;

            public Commit() {
            }

            public Commit(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() {
                return 90;
            }

            public int protocolMethodId() {
                return 20;
            }

            public String protocolMethodName() {
                return "tx.commit";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class SelectOk
        extends Method
        implements AMQP.Tx.SelectOk {
            public static final int INDEX = 11;

            public SelectOk() {
            }

            public SelectOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() {
                return 90;
            }

            public int protocolMethodId() {
                return 11;
            }

            public String protocolMethodName() {
                return "tx.select-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Select
        extends Method
        implements AMQP.Tx.Select {
            public static final int INDEX = 10;

            public Select() {
            }

            public Select(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() {
                return 90;
            }

            public int protocolMethodId() {
                return 10;
            }

            public String protocolMethodName() {
                return "tx.select";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }
    }

    public static class Basic {
        public static final int INDEX = 60;

        public static class Nack
        extends Method
        implements AMQP.Basic.Nack {
            public static final int INDEX = 120;
            private final long deliveryTag;
            private final boolean multiple;
            private final boolean requeue;

            public long getDeliveryTag() {
                return this.deliveryTag;
            }

            public boolean getMultiple() {
                return this.multiple;
            }

            public boolean getRequeue() {
                return this.requeue;
            }

            public Nack(long deliveryTag, boolean multiple, boolean requeue) {
                this.deliveryTag = deliveryTag;
                this.multiple = multiple;
                this.requeue = requeue;
            }

            public Nack(MethodArgumentReader rdr) throws IOException {
                this(rdr.readLonglong(), rdr.readBit(), rdr.readBit());
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 120;
            }

            public String protocolMethodName() {
                return "basic.nack";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(delivery-tag=").append(this.deliveryTag).append(", multiple=").append(this.multiple).append(", requeue=").append(this.requeue).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLonglong(this.deliveryTag);
                writer.writeBit(this.multiple);
                writer.writeBit(this.requeue);
            }
        }

        public static class RecoverOk
        extends Method
        implements AMQP.Basic.RecoverOk {
            public static final int INDEX = 111;

            public RecoverOk() {
            }

            public RecoverOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 111;
            }

            public String protocolMethodName() {
                return "basic.recover-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Recover
        extends Method
        implements AMQP.Basic.Recover {
            public static final int INDEX = 110;
            private final boolean requeue;

            public boolean getRequeue() {
                return this.requeue;
            }

            public Recover(boolean requeue) {
                this.requeue = requeue;
            }

            public Recover(MethodArgumentReader rdr) throws IOException {
                this(rdr.readBit());
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 110;
            }

            public String protocolMethodName() {
                return "basic.recover";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(requeue=").append(this.requeue).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeBit(this.requeue);
            }
        }

        public static class RecoverAsync
        extends Method
        implements AMQP.Basic.RecoverAsync {
            public static final int INDEX = 100;
            private final boolean requeue;

            public boolean getRequeue() {
                return this.requeue;
            }

            public RecoverAsync(boolean requeue) {
                this.requeue = requeue;
            }

            public RecoverAsync(MethodArgumentReader rdr) throws IOException {
                this(rdr.readBit());
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 100;
            }

            public String protocolMethodName() {
                return "basic.recover-async";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(requeue=").append(this.requeue).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeBit(this.requeue);
            }
        }

        public static class Reject
        extends Method
        implements AMQP.Basic.Reject {
            public static final int INDEX = 90;
            private final long deliveryTag;
            private final boolean requeue;

            public long getDeliveryTag() {
                return this.deliveryTag;
            }

            public boolean getRequeue() {
                return this.requeue;
            }

            public Reject(long deliveryTag, boolean requeue) {
                this.deliveryTag = deliveryTag;
                this.requeue = requeue;
            }

            public Reject(MethodArgumentReader rdr) throws IOException {
                this(rdr.readLonglong(), rdr.readBit());
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 90;
            }

            public String protocolMethodName() {
                return "basic.reject";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(delivery-tag=").append(this.deliveryTag).append(", requeue=").append(this.requeue).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLonglong(this.deliveryTag);
                writer.writeBit(this.requeue);
            }
        }

        public static class Ack
        extends Method
        implements AMQP.Basic.Ack {
            public static final int INDEX = 80;
            private final long deliveryTag;
            private final boolean multiple;

            public long getDeliveryTag() {
                return this.deliveryTag;
            }

            public boolean getMultiple() {
                return this.multiple;
            }

            public Ack(long deliveryTag, boolean multiple) {
                this.deliveryTag = deliveryTag;
                this.multiple = multiple;
            }

            public Ack(MethodArgumentReader rdr) throws IOException {
                this(rdr.readLonglong(), rdr.readBit());
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 80;
            }

            public String protocolMethodName() {
                return "basic.ack";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(delivery-tag=").append(this.deliveryTag).append(", multiple=").append(this.multiple).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLonglong(this.deliveryTag);
                writer.writeBit(this.multiple);
            }
        }

        public static class GetEmpty
        extends Method
        implements AMQP.Basic.GetEmpty {
            public static final int INDEX = 72;
            private final String clusterId;

            public String getClusterId() {
                return this.clusterId;
            }

            public GetEmpty(String clusterId) {
                if (clusterId == null) {
                    throw new IllegalStateException("Invalid configuration: 'clusterId' must be non-null.");
                }
                this.clusterId = clusterId;
            }

            public GetEmpty(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShortstr());
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 72;
            }

            public String protocolMethodName() {
                return "basic.get-empty";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(cluster-id=").append(this.clusterId).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.clusterId);
            }
        }

        public static class GetOk
        extends Method
        implements AMQP.Basic.GetOk {
            public static final int INDEX = 71;
            private final long deliveryTag;
            private final boolean redelivered;
            private final String exchange;
            private final String routingKey;
            private final int messageCount;

            public long getDeliveryTag() {
                return this.deliveryTag;
            }

            public boolean getRedelivered() {
                return this.redelivered;
            }

            public String getExchange() {
                return this.exchange;
            }

            public String getRoutingKey() {
                return this.routingKey;
            }

            public int getMessageCount() {
                return this.messageCount;
            }

            public GetOk(long deliveryTag, boolean redelivered, String exchange, String routingKey, int messageCount) {
                if (routingKey == null) {
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                }
                if (exchange == null) {
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                }
                this.deliveryTag = deliveryTag;
                this.redelivered = redelivered;
                this.exchange = exchange;
                this.routingKey = routingKey;
                this.messageCount = messageCount;
            }

            public GetOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readLonglong(), rdr.readBit(), rdr.readShortstr(), rdr.readShortstr(), rdr.readLong());
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 71;
            }

            public String protocolMethodName() {
                return "basic.get-ok";
            }

            public boolean hasContent() {
                return true;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(delivery-tag=").append(this.deliveryTag).append(", redelivered=").append(this.redelivered).append(", exchange=").append(this.exchange).append(", routing-key=").append(this.routingKey).append(", message-count=").append(this.messageCount).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLonglong(this.deliveryTag);
                writer.writeBit(this.redelivered);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
                writer.writeLong(this.messageCount);
            }
        }

        public static class Get
        extends Method
        implements AMQP.Basic.Get {
            public static final int INDEX = 70;
            private final int ticket;
            private final String queue;
            private final boolean noAck;

            public int getTicket() {
                return this.ticket;
            }

            public String getQueue() {
                return this.queue;
            }

            public boolean getNoAck() {
                return this.noAck;
            }

            public Get(int ticket, String queue, boolean noAck) {
                if (queue == null) {
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                }
                this.ticket = ticket;
                this.queue = queue;
                this.noAck = noAck;
            }

            public Get(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readBit());
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 70;
            }

            public String protocolMethodName() {
                return "basic.get";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=").append(this.ticket).append(", queue=").append(this.queue).append(", no-ack=").append(this.noAck).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeBit(this.noAck);
            }
        }

        public static class Deliver
        extends Method
        implements AMQP.Basic.Deliver {
            public static final int INDEX = 60;
            private final String consumerTag;
            private final long deliveryTag;
            private final boolean redelivered;
            private final String exchange;
            private final String routingKey;

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public long getDeliveryTag() {
                return this.deliveryTag;
            }

            public boolean getRedelivered() {
                return this.redelivered;
            }

            public String getExchange() {
                return this.exchange;
            }

            public String getRoutingKey() {
                return this.routingKey;
            }

            public Deliver(String consumerTag, long deliveryTag, boolean redelivered, String exchange, String routingKey) {
                if (exchange == null) {
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                }
                if (routingKey == null) {
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                }
                if (consumerTag == null) {
                    throw new IllegalStateException("Invalid configuration: 'consumerTag' must be non-null.");
                }
                this.consumerTag = consumerTag;
                this.deliveryTag = deliveryTag;
                this.redelivered = redelivered;
                this.exchange = exchange;
                this.routingKey = routingKey;
            }

            public Deliver(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShortstr(), rdr.readLonglong(), rdr.readBit(), rdr.readShortstr(), rdr.readShortstr());
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 60;
            }

            public String protocolMethodName() {
                return "basic.deliver";
            }

            public boolean hasContent() {
                return true;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(consumer-tag=").append(this.consumerTag).append(", delivery-tag=").append(this.deliveryTag).append(", redelivered=").append(this.redelivered).append(", exchange=").append(this.exchange).append(", routing-key=").append(this.routingKey).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.consumerTag);
                writer.writeLonglong(this.deliveryTag);
                writer.writeBit(this.redelivered);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
            }
        }

        public static class Return
        extends Method
        implements AMQP.Basic.Return {
            public static final int INDEX = 50;
            private final int replyCode;
            private final String replyText;
            private final String exchange;
            private final String routingKey;

            public int getReplyCode() {
                return this.replyCode;
            }

            public String getReplyText() {
                return this.replyText;
            }

            public String getExchange() {
                return this.exchange;
            }

            public String getRoutingKey() {
                return this.routingKey;
            }

            public Return(int replyCode, String replyText, String exchange, String routingKey) {
                if (replyText == null) {
                    throw new IllegalStateException("Invalid configuration: 'replyText' must be non-null.");
                }
                if (routingKey == null) {
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                }
                if (exchange == null) {
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                }
                this.replyCode = replyCode;
                this.replyText = replyText;
                this.exchange = exchange;
                this.routingKey = routingKey;
            }

            public Return(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readShortstr(), rdr.readShortstr());
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 50;
            }

            public String protocolMethodName() {
                return "basic.return";
            }

            public boolean hasContent() {
                return true;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(reply-code=").append(this.replyCode).append(", reply-text=").append(this.replyText).append(", exchange=").append(this.exchange).append(", routing-key=").append(this.routingKey).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.replyCode);
                writer.writeShortstr(this.replyText);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
            }
        }

        public static class Publish
        extends Method
        implements AMQP.Basic.Publish {
            public static final int INDEX = 40;
            private final int ticket;
            private final String exchange;
            private final String routingKey;
            private final boolean mandatory;
            private final boolean immediate;

            public int getTicket() {
                return this.ticket;
            }

            public String getExchange() {
                return this.exchange;
            }

            public String getRoutingKey() {
                return this.routingKey;
            }

            public boolean getMandatory() {
                return this.mandatory;
            }

            public boolean getImmediate() {
                return this.immediate;
            }

            public Publish(int ticket, String exchange, String routingKey, boolean mandatory, boolean immediate) {
                if (routingKey == null) {
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                }
                if (exchange == null) {
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                }
                this.ticket = ticket;
                this.exchange = exchange;
                this.routingKey = routingKey;
                this.mandatory = mandatory;
                this.immediate = immediate;
            }

            public Publish(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readShortstr(), rdr.readBit(), rdr.readBit());
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 40;
            }

            public String protocolMethodName() {
                return "basic.publish";
            }

            public boolean hasContent() {
                return true;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=").append(this.ticket).append(", exchange=").append(this.exchange).append(", routing-key=").append(this.routingKey).append(", mandatory=").append(this.mandatory).append(", immediate=").append(this.immediate).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
                writer.writeBit(this.mandatory);
                writer.writeBit(this.immediate);
            }
        }

        public static class CancelOk
        extends Method
        implements AMQP.Basic.CancelOk {
            public static final int INDEX = 31;
            private final String consumerTag;

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public CancelOk(String consumerTag) {
                if (consumerTag == null) {
                    throw new IllegalStateException("Invalid configuration: 'consumerTag' must be non-null.");
                }
                this.consumerTag = consumerTag;
            }

            public CancelOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShortstr());
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 31;
            }

            public String protocolMethodName() {
                return "basic.cancel-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(consumer-tag=").append(this.consumerTag).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.consumerTag);
            }
        }

        public static class Cancel
        extends Method
        implements AMQP.Basic.Cancel {
            public static final int INDEX = 30;
            private final String consumerTag;
            private final boolean nowait;

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public boolean getNowait() {
                return this.nowait;
            }

            public Cancel(String consumerTag, boolean nowait) {
                if (consumerTag == null) {
                    throw new IllegalStateException("Invalid configuration: 'consumerTag' must be non-null.");
                }
                this.consumerTag = consumerTag;
                this.nowait = nowait;
            }

            public Cancel(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShortstr(), rdr.readBit());
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 30;
            }

            public String protocolMethodName() {
                return "basic.cancel";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(consumer-tag=").append(this.consumerTag).append(", nowait=").append(this.nowait).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.consumerTag);
                writer.writeBit(this.nowait);
            }
        }

        public static class ConsumeOk
        extends Method
        implements AMQP.Basic.ConsumeOk {
            public static final int INDEX = 21;
            private final String consumerTag;

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public ConsumeOk(String consumerTag) {
                if (consumerTag == null) {
                    throw new IllegalStateException("Invalid configuration: 'consumerTag' must be non-null.");
                }
                this.consumerTag = consumerTag;
            }

            public ConsumeOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShortstr());
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 21;
            }

            public String protocolMethodName() {
                return "basic.consume-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(consumer-tag=").append(this.consumerTag).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.consumerTag);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Consume
        extends Method
        implements AMQP.Basic.Consume {
            public static final int INDEX = 20;
            private final int ticket;
            private final String queue;
            private final String consumerTag;
            private final boolean noLocal;
            private final boolean noAck;
            private final boolean exclusive;
            private final boolean nowait;
            private final Map<String, Object> arguments;

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public String getQueue() {
                return this.queue;
            }

            @Override
            public String getConsumerTag() {
                return this.consumerTag;
            }

            @Override
            public boolean getNoLocal() {
                return this.noLocal;
            }

            @Override
            public boolean getNoAck() {
                return this.noAck;
            }

            @Override
            public boolean getExclusive() {
                return this.exclusive;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            public Consume(int ticket, String queue, String consumerTag, boolean noLocal, boolean noAck, boolean exclusive, boolean nowait, Map<String, Object> arguments) {
                if (queue == null) {
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                }
                if (consumerTag == null) {
                    throw new IllegalStateException("Invalid configuration: 'consumerTag' must be non-null.");
                }
                this.ticket = ticket;
                this.queue = queue;
                this.consumerTag = consumerTag;
                this.noLocal = noLocal;
                this.noAck = noAck;
                this.exclusive = exclusive;
                this.nowait = nowait;
                this.arguments = arguments == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(arguments));
            }

            public Consume(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readShortstr(), rdr.readBit(), rdr.readBit(), rdr.readBit(), rdr.readBit(), rdr.readTable());
            }

            @Override
            public int protocolClassId() {
                return 60;
            }

            @Override
            public int protocolMethodId() {
                return 20;
            }

            @Override
            public String protocolMethodName() {
                return "basic.consume";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=").append(this.ticket).append(", queue=").append(this.queue).append(", consumer-tag=").append(this.consumerTag).append(", no-local=").append(this.noLocal).append(", no-ack=").append(this.noAck).append(", exclusive=").append(this.exclusive).append(", nowait=").append(this.nowait).append(", arguments=").append(this.arguments).append(")");
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeShortstr(this.consumerTag);
                writer.writeBit(this.noLocal);
                writer.writeBit(this.noAck);
                writer.writeBit(this.exclusive);
                writer.writeBit(this.nowait);
                writer.writeTable(this.arguments);
            }
        }

        public static class QosOk
        extends Method
        implements AMQP.Basic.QosOk {
            public static final int INDEX = 11;

            public QosOk() {
            }

            public QosOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 11;
            }

            public String protocolMethodName() {
                return "basic.qos-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Qos
        extends Method
        implements AMQP.Basic.Qos {
            public static final int INDEX = 10;
            private final int prefetchSize;
            private final int prefetchCount;
            private final boolean global;

            public int getPrefetchSize() {
                return this.prefetchSize;
            }

            public int getPrefetchCount() {
                return this.prefetchCount;
            }

            public boolean getGlobal() {
                return this.global;
            }

            public Qos(int prefetchSize, int prefetchCount, boolean global) {
                this.prefetchSize = prefetchSize;
                this.prefetchCount = prefetchCount;
                this.global = global;
            }

            public Qos(MethodArgumentReader rdr) throws IOException {
                this(rdr.readLong(), rdr.readShort(), rdr.readBit());
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 10;
            }

            public String protocolMethodName() {
                return "basic.qos";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(prefetch-size=").append(this.prefetchSize).append(", prefetch-count=").append(this.prefetchCount).append(", global=").append(this.global).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLong(this.prefetchSize);
                writer.writeShort(this.prefetchCount);
                writer.writeBit(this.global);
            }
        }
    }

    public static class Queue {
        public static final int INDEX = 50;

        public static class UnbindOk
        extends Method
        implements AMQP.Queue.UnbindOk {
            public static final int INDEX = 51;

            public UnbindOk() {
            }

            public UnbindOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() {
                return 50;
            }

            public int protocolMethodId() {
                return 51;
            }

            public String protocolMethodName() {
                return "queue.unbind-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Unbind
        extends Method
        implements AMQP.Queue.Unbind {
            public static final int INDEX = 50;
            private final int ticket;
            private final String queue;
            private final String exchange;
            private final String routingKey;
            private final Map<String, Object> arguments;

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public String getQueue() {
                return this.queue;
            }

            @Override
            public String getExchange() {
                return this.exchange;
            }

            @Override
            public String getRoutingKey() {
                return this.routingKey;
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            public Unbind(int ticket, String queue, String exchange, String routingKey, Map<String, Object> arguments) {
                if (queue == null) {
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                }
                if (routingKey == null) {
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                }
                if (exchange == null) {
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                }
                this.ticket = ticket;
                this.queue = queue;
                this.exchange = exchange;
                this.routingKey = routingKey;
                this.arguments = arguments == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(arguments));
            }

            public Unbind(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readShortstr(), rdr.readShortstr(), rdr.readTable());
            }

            @Override
            public int protocolClassId() {
                return 50;
            }

            @Override
            public int protocolMethodId() {
                return 50;
            }

            @Override
            public String protocolMethodName() {
                return "queue.unbind";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=").append(this.ticket).append(", queue=").append(this.queue).append(", exchange=").append(this.exchange).append(", routing-key=").append(this.routingKey).append(", arguments=").append(this.arguments).append(")");
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
                writer.writeTable(this.arguments);
            }
        }

        public static class DeleteOk
        extends Method
        implements AMQP.Queue.DeleteOk {
            public static final int INDEX = 41;
            private final int messageCount;

            public int getMessageCount() {
                return this.messageCount;
            }

            public DeleteOk(int messageCount) {
                this.messageCount = messageCount;
            }

            public DeleteOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readLong());
            }

            public int protocolClassId() {
                return 50;
            }

            public int protocolMethodId() {
                return 41;
            }

            public String protocolMethodName() {
                return "queue.delete-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(message-count=").append(this.messageCount).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLong(this.messageCount);
            }
        }

        public static class Delete
        extends Method
        implements AMQP.Queue.Delete {
            public static final int INDEX = 40;
            private final int ticket;
            private final String queue;
            private final boolean ifUnused;
            private final boolean ifEmpty;
            private final boolean nowait;

            public int getTicket() {
                return this.ticket;
            }

            public String getQueue() {
                return this.queue;
            }

            public boolean getIfUnused() {
                return this.ifUnused;
            }

            public boolean getIfEmpty() {
                return this.ifEmpty;
            }

            public boolean getNowait() {
                return this.nowait;
            }

            public Delete(int ticket, String queue, boolean ifUnused, boolean ifEmpty, boolean nowait) {
                if (queue == null) {
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                }
                this.ticket = ticket;
                this.queue = queue;
                this.ifUnused = ifUnused;
                this.ifEmpty = ifEmpty;
                this.nowait = nowait;
            }

            public Delete(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readBit(), rdr.readBit(), rdr.readBit());
            }

            public int protocolClassId() {
                return 50;
            }

            public int protocolMethodId() {
                return 40;
            }

            public String protocolMethodName() {
                return "queue.delete";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=").append(this.ticket).append(", queue=").append(this.queue).append(", if-unused=").append(this.ifUnused).append(", if-empty=").append(this.ifEmpty).append(", nowait=").append(this.nowait).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeBit(this.ifUnused);
                writer.writeBit(this.ifEmpty);
                writer.writeBit(this.nowait);
            }
        }

        public static class PurgeOk
        extends Method
        implements AMQP.Queue.PurgeOk {
            public static final int INDEX = 31;
            private final int messageCount;

            public int getMessageCount() {
                return this.messageCount;
            }

            public PurgeOk(int messageCount) {
                this.messageCount = messageCount;
            }

            public PurgeOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readLong());
            }

            public int protocolClassId() {
                return 50;
            }

            public int protocolMethodId() {
                return 31;
            }

            public String protocolMethodName() {
                return "queue.purge-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(message-count=").append(this.messageCount).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLong(this.messageCount);
            }
        }

        public static class Purge
        extends Method
        implements AMQP.Queue.Purge {
            public static final int INDEX = 30;
            private final int ticket;
            private final String queue;
            private final boolean nowait;

            public int getTicket() {
                return this.ticket;
            }

            public String getQueue() {
                return this.queue;
            }

            public boolean getNowait() {
                return this.nowait;
            }

            public Purge(int ticket, String queue, boolean nowait) {
                if (queue == null) {
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                }
                this.ticket = ticket;
                this.queue = queue;
                this.nowait = nowait;
            }

            public Purge(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readBit());
            }

            public int protocolClassId() {
                return 50;
            }

            public int protocolMethodId() {
                return 30;
            }

            public String protocolMethodName() {
                return "queue.purge";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=").append(this.ticket).append(", queue=").append(this.queue).append(", nowait=").append(this.nowait).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeBit(this.nowait);
            }
        }

        public static class BindOk
        extends Method
        implements AMQP.Queue.BindOk {
            public static final int INDEX = 21;

            public BindOk() {
            }

            public BindOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() {
                return 50;
            }

            public int protocolMethodId() {
                return 21;
            }

            public String protocolMethodName() {
                return "queue.bind-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind
        extends Method
        implements AMQP.Queue.Bind {
            public static final int INDEX = 20;
            private final int ticket;
            private final String queue;
            private final String exchange;
            private final String routingKey;
            private final boolean nowait;
            private final Map<String, Object> arguments;

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public String getQueue() {
                return this.queue;
            }

            @Override
            public String getExchange() {
                return this.exchange;
            }

            @Override
            public String getRoutingKey() {
                return this.routingKey;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            public Bind(int ticket, String queue, String exchange, String routingKey, boolean nowait, Map<String, Object> arguments) {
                if (queue == null) {
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                }
                if (routingKey == null) {
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                }
                if (exchange == null) {
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                }
                this.ticket = ticket;
                this.queue = queue;
                this.exchange = exchange;
                this.routingKey = routingKey;
                this.nowait = nowait;
                this.arguments = arguments == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(arguments));
            }

            public Bind(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readShortstr(), rdr.readShortstr(), rdr.readBit(), rdr.readTable());
            }

            @Override
            public int protocolClassId() {
                return 50;
            }

            @Override
            public int protocolMethodId() {
                return 20;
            }

            @Override
            public String protocolMethodName() {
                return "queue.bind";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=").append(this.ticket).append(", queue=").append(this.queue).append(", exchange=").append(this.exchange).append(", routing-key=").append(this.routingKey).append(", nowait=").append(this.nowait).append(", arguments=").append(this.arguments).append(")");
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
                writer.writeBit(this.nowait);
                writer.writeTable(this.arguments);
            }
        }

        public static class DeclareOk
        extends Method
        implements AMQP.Queue.DeclareOk {
            public static final int INDEX = 11;
            private final String queue;
            private final int messageCount;
            private final int consumerCount;

            public String getQueue() {
                return this.queue;
            }

            public int getMessageCount() {
                return this.messageCount;
            }

            public int getConsumerCount() {
                return this.consumerCount;
            }

            public DeclareOk(String queue, int messageCount, int consumerCount) {
                if (queue == null) {
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                }
                this.queue = queue;
                this.messageCount = messageCount;
                this.consumerCount = consumerCount;
            }

            public DeclareOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShortstr(), rdr.readLong(), rdr.readLong());
            }

            public int protocolClassId() {
                return 50;
            }

            public int protocolMethodId() {
                return 11;
            }

            public String protocolMethodName() {
                return "queue.declare-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(queue=").append(this.queue).append(", message-count=").append(this.messageCount).append(", consumer-count=").append(this.consumerCount).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.queue);
                writer.writeLong(this.messageCount);
                writer.writeLong(this.consumerCount);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Declare
        extends Method
        implements AMQP.Queue.Declare {
            public static final int INDEX = 10;
            private final int ticket;
            private final String queue;
            private final boolean passive;
            private final boolean durable;
            private final boolean exclusive;
            private final boolean autoDelete;
            private final boolean nowait;
            private final Map<String, Object> arguments;

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public String getQueue() {
                return this.queue;
            }

            @Override
            public boolean getPassive() {
                return this.passive;
            }

            @Override
            public boolean getDurable() {
                return this.durable;
            }

            @Override
            public boolean getExclusive() {
                return this.exclusive;
            }

            @Override
            public boolean getAutoDelete() {
                return this.autoDelete;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            public Declare(int ticket, String queue, boolean passive, boolean durable, boolean exclusive, boolean autoDelete, boolean nowait, Map<String, Object> arguments) {
                if (queue == null) {
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                }
                this.ticket = ticket;
                this.queue = queue;
                this.passive = passive;
                this.durable = durable;
                this.exclusive = exclusive;
                this.autoDelete = autoDelete;
                this.nowait = nowait;
                this.arguments = arguments == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(arguments));
            }

            public Declare(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readBit(), rdr.readBit(), rdr.readBit(), rdr.readBit(), rdr.readBit(), rdr.readTable());
            }

            @Override
            public int protocolClassId() {
                return 50;
            }

            @Override
            public int protocolMethodId() {
                return 10;
            }

            @Override
            public String protocolMethodName() {
                return "queue.declare";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=").append(this.ticket).append(", queue=").append(this.queue).append(", passive=").append(this.passive).append(", durable=").append(this.durable).append(", exclusive=").append(this.exclusive).append(", auto-delete=").append(this.autoDelete).append(", nowait=").append(this.nowait).append(", arguments=").append(this.arguments).append(")");
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeBit(this.passive);
                writer.writeBit(this.durable);
                writer.writeBit(this.exclusive);
                writer.writeBit(this.autoDelete);
                writer.writeBit(this.nowait);
                writer.writeTable(this.arguments);
            }
        }
    }

    public static class Exchange {
        public static final int INDEX = 40;

        public static class UnbindOk
        extends Method
        implements AMQP.Exchange.UnbindOk {
            public static final int INDEX = 51;

            public UnbindOk() {
            }

            public UnbindOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() {
                return 40;
            }

            public int protocolMethodId() {
                return 51;
            }

            public String protocolMethodName() {
                return "exchange.unbind-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Unbind
        extends Method
        implements AMQP.Exchange.Unbind {
            public static final int INDEX = 40;
            private final int ticket;
            private final String destination;
            private final String source;
            private final String routingKey;
            private final boolean nowait;
            private final Map<String, Object> arguments;

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public String getDestination() {
                return this.destination;
            }

            @Override
            public String getSource() {
                return this.source;
            }

            @Override
            public String getRoutingKey() {
                return this.routingKey;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            public Unbind(int ticket, String destination, String source, String routingKey, boolean nowait, Map<String, Object> arguments) {
                if (source == null) {
                    throw new IllegalStateException("Invalid configuration: 'source' must be non-null.");
                }
                if (destination == null) {
                    throw new IllegalStateException("Invalid configuration: 'destination' must be non-null.");
                }
                if (routingKey == null) {
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                }
                this.ticket = ticket;
                this.destination = destination;
                this.source = source;
                this.routingKey = routingKey;
                this.nowait = nowait;
                this.arguments = arguments == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(arguments));
            }

            public Unbind(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readShortstr(), rdr.readShortstr(), rdr.readBit(), rdr.readTable());
            }

            @Override
            public int protocolClassId() {
                return 40;
            }

            @Override
            public int protocolMethodId() {
                return 40;
            }

            @Override
            public String protocolMethodName() {
                return "exchange.unbind";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=").append(this.ticket).append(", destination=").append(this.destination).append(", source=").append(this.source).append(", routing-key=").append(this.routingKey).append(", nowait=").append(this.nowait).append(", arguments=").append(this.arguments).append(")");
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.destination);
                writer.writeShortstr(this.source);
                writer.writeShortstr(this.routingKey);
                writer.writeBit(this.nowait);
                writer.writeTable(this.arguments);
            }
        }

        public static class BindOk
        extends Method
        implements AMQP.Exchange.BindOk {
            public static final int INDEX = 31;

            public BindOk() {
            }

            public BindOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() {
                return 40;
            }

            public int protocolMethodId() {
                return 31;
            }

            public String protocolMethodName() {
                return "exchange.bind-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind
        extends Method
        implements AMQP.Exchange.Bind {
            public static final int INDEX = 30;
            private final int ticket;
            private final String destination;
            private final String source;
            private final String routingKey;
            private final boolean nowait;
            private final Map<String, Object> arguments;

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public String getDestination() {
                return this.destination;
            }

            @Override
            public String getSource() {
                return this.source;
            }

            @Override
            public String getRoutingKey() {
                return this.routingKey;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            public Bind(int ticket, String destination, String source, String routingKey, boolean nowait, Map<String, Object> arguments) {
                if (source == null) {
                    throw new IllegalStateException("Invalid configuration: 'source' must be non-null.");
                }
                if (destination == null) {
                    throw new IllegalStateException("Invalid configuration: 'destination' must be non-null.");
                }
                if (routingKey == null) {
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                }
                this.ticket = ticket;
                this.destination = destination;
                this.source = source;
                this.routingKey = routingKey;
                this.nowait = nowait;
                this.arguments = arguments == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(arguments));
            }

            public Bind(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readShortstr(), rdr.readShortstr(), rdr.readBit(), rdr.readTable());
            }

            @Override
            public int protocolClassId() {
                return 40;
            }

            @Override
            public int protocolMethodId() {
                return 30;
            }

            @Override
            public String protocolMethodName() {
                return "exchange.bind";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=").append(this.ticket).append(", destination=").append(this.destination).append(", source=").append(this.source).append(", routing-key=").append(this.routingKey).append(", nowait=").append(this.nowait).append(", arguments=").append(this.arguments).append(")");
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.destination);
                writer.writeShortstr(this.source);
                writer.writeShortstr(this.routingKey);
                writer.writeBit(this.nowait);
                writer.writeTable(this.arguments);
            }
        }

        public static class DeleteOk
        extends Method
        implements AMQP.Exchange.DeleteOk {
            public static final int INDEX = 21;

            public DeleteOk() {
            }

            public DeleteOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() {
                return 40;
            }

            public int protocolMethodId() {
                return 21;
            }

            public String protocolMethodName() {
                return "exchange.delete-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Delete
        extends Method
        implements AMQP.Exchange.Delete {
            public static final int INDEX = 20;
            private final int ticket;
            private final String exchange;
            private final boolean ifUnused;
            private final boolean nowait;

            public int getTicket() {
                return this.ticket;
            }

            public String getExchange() {
                return this.exchange;
            }

            public boolean getIfUnused() {
                return this.ifUnused;
            }

            public boolean getNowait() {
                return this.nowait;
            }

            public Delete(int ticket, String exchange, boolean ifUnused, boolean nowait) {
                if (exchange == null) {
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                }
                this.ticket = ticket;
                this.exchange = exchange;
                this.ifUnused = ifUnused;
                this.nowait = nowait;
            }

            public Delete(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readBit(), rdr.readBit());
            }

            public int protocolClassId() {
                return 40;
            }

            public int protocolMethodId() {
                return 20;
            }

            public String protocolMethodName() {
                return "exchange.delete";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=").append(this.ticket).append(", exchange=").append(this.exchange).append(", if-unused=").append(this.ifUnused).append(", nowait=").append(this.nowait).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.exchange);
                writer.writeBit(this.ifUnused);
                writer.writeBit(this.nowait);
            }
        }

        public static class DeclareOk
        extends Method
        implements AMQP.Exchange.DeclareOk {
            public static final int INDEX = 11;

            public DeclareOk() {
            }

            public DeclareOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() {
                return 40;
            }

            public int protocolMethodId() {
                return 11;
            }

            public String protocolMethodName() {
                return "exchange.declare-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Declare
        extends Method
        implements AMQP.Exchange.Declare {
            public static final int INDEX = 10;
            private final int ticket;
            private final String exchange;
            private final String type;
            private final boolean passive;
            private final boolean durable;
            private final boolean autoDelete;
            private final boolean internal;
            private final boolean nowait;
            private final Map<String, Object> arguments;

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public String getExchange() {
                return this.exchange;
            }

            @Override
            public String getType() {
                return this.type;
            }

            @Override
            public boolean getPassive() {
                return this.passive;
            }

            @Override
            public boolean getDurable() {
                return this.durable;
            }

            @Override
            public boolean getAutoDelete() {
                return this.autoDelete;
            }

            @Override
            public boolean getInternal() {
                return this.internal;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            public Declare(int ticket, String exchange, String type, boolean passive, boolean durable, boolean autoDelete, boolean internal, boolean nowait, Map<String, Object> arguments) {
                if (type == null) {
                    throw new IllegalStateException("Invalid configuration: 'type' must be non-null.");
                }
                if (exchange == null) {
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                }
                this.ticket = ticket;
                this.exchange = exchange;
                this.type = type;
                this.passive = passive;
                this.durable = durable;
                this.autoDelete = autoDelete;
                this.internal = internal;
                this.nowait = nowait;
                this.arguments = arguments == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(arguments));
            }

            public Declare(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readShortstr(), rdr.readBit(), rdr.readBit(), rdr.readBit(), rdr.readBit(), rdr.readBit(), rdr.readTable());
            }

            @Override
            public int protocolClassId() {
                return 40;
            }

            @Override
            public int protocolMethodId() {
                return 10;
            }

            @Override
            public String protocolMethodName() {
                return "exchange.declare";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=").append(this.ticket).append(", exchange=").append(this.exchange).append(", type=").append(this.type).append(", passive=").append(this.passive).append(", durable=").append(this.durable).append(", auto-delete=").append(this.autoDelete).append(", internal=").append(this.internal).append(", nowait=").append(this.nowait).append(", arguments=").append(this.arguments).append(")");
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.type);
                writer.writeBit(this.passive);
                writer.writeBit(this.durable);
                writer.writeBit(this.autoDelete);
                writer.writeBit(this.internal);
                writer.writeBit(this.nowait);
                writer.writeTable(this.arguments);
            }
        }
    }

    public static class Access {
        public static final int INDEX = 30;

        public static class RequestOk
        extends Method
        implements AMQP.Access.RequestOk {
            public static final int INDEX = 11;
            private final int ticket;

            public int getTicket() {
                return this.ticket;
            }

            public RequestOk(int ticket) {
                this.ticket = ticket;
            }

            public RequestOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort());
            }

            public int protocolClassId() {
                return 30;
            }

            public int protocolMethodId() {
                return 11;
            }

            public String protocolMethodName() {
                return "access.request-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=").append(this.ticket).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
            }
        }

        public static class Request
        extends Method
        implements AMQP.Access.Request {
            public static final int INDEX = 10;
            private final String realm;
            private final boolean exclusive;
            private final boolean passive;
            private final boolean active;
            private final boolean write;
            private final boolean read;

            public String getRealm() {
                return this.realm;
            }

            public boolean getExclusive() {
                return this.exclusive;
            }

            public boolean getPassive() {
                return this.passive;
            }

            public boolean getActive() {
                return this.active;
            }

            public boolean getWrite() {
                return this.write;
            }

            public boolean getRead() {
                return this.read;
            }

            public Request(String realm, boolean exclusive, boolean passive, boolean active, boolean write, boolean read) {
                if (realm == null) {
                    throw new IllegalStateException("Invalid configuration: 'realm' must be non-null.");
                }
                this.realm = realm;
                this.exclusive = exclusive;
                this.passive = passive;
                this.active = active;
                this.write = write;
                this.read = read;
            }

            public Request(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShortstr(), rdr.readBit(), rdr.readBit(), rdr.readBit(), rdr.readBit(), rdr.readBit());
            }

            public int protocolClassId() {
                return 30;
            }

            public int protocolMethodId() {
                return 10;
            }

            public String protocolMethodName() {
                return "access.request";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(realm=").append(this.realm).append(", exclusive=").append(this.exclusive).append(", passive=").append(this.passive).append(", active=").append(this.active).append(", write=").append(this.write).append(", read=").append(this.read).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.realm);
                writer.writeBit(this.exclusive);
                writer.writeBit(this.passive);
                writer.writeBit(this.active);
                writer.writeBit(this.write);
                writer.writeBit(this.read);
            }
        }
    }

    public static class Channel {
        public static final int INDEX = 20;

        public static class CloseOk
        extends Method
        implements AMQP.Channel.CloseOk {
            public static final int INDEX = 41;

            public CloseOk() {
            }

            public CloseOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() {
                return 20;
            }

            public int protocolMethodId() {
                return 41;
            }

            public String protocolMethodName() {
                return "channel.close-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Close
        extends Method
        implements AMQP.Channel.Close {
            public static final int INDEX = 40;
            private final int replyCode;
            private final String replyText;
            private final int classId;
            private final int methodId;

            public int getReplyCode() {
                return this.replyCode;
            }

            public String getReplyText() {
                return this.replyText;
            }

            public int getClassId() {
                return this.classId;
            }

            public int getMethodId() {
                return this.methodId;
            }

            public Close(int replyCode, String replyText, int classId, int methodId) {
                if (replyText == null) {
                    throw new IllegalStateException("Invalid configuration: 'replyText' must be non-null.");
                }
                this.replyCode = replyCode;
                this.replyText = replyText;
                this.classId = classId;
                this.methodId = methodId;
            }

            public Close(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readShort(), rdr.readShort());
            }

            public int protocolClassId() {
                return 20;
            }

            public int protocolMethodId() {
                return 40;
            }

            public String protocolMethodName() {
                return "channel.close";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(reply-code=").append(this.replyCode).append(", reply-text=").append(this.replyText).append(", class-id=").append(this.classId).append(", method-id=").append(this.methodId).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.replyCode);
                writer.writeShortstr(this.replyText);
                writer.writeShort(this.classId);
                writer.writeShort(this.methodId);
            }
        }

        public static class FlowOk
        extends Method
        implements AMQP.Channel.FlowOk {
            public static final int INDEX = 21;
            private final boolean active;

            public boolean getActive() {
                return this.active;
            }

            public FlowOk(boolean active) {
                this.active = active;
            }

            public FlowOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readBit());
            }

            public int protocolClassId() {
                return 20;
            }

            public int protocolMethodId() {
                return 21;
            }

            public String protocolMethodName() {
                return "channel.flow-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(active=").append(this.active).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeBit(this.active);
            }
        }

        public static class Flow
        extends Method
        implements AMQP.Channel.Flow {
            public static final int INDEX = 20;
            private final boolean active;

            public boolean getActive() {
                return this.active;
            }

            public Flow(boolean active) {
                this.active = active;
            }

            public Flow(MethodArgumentReader rdr) throws IOException {
                this(rdr.readBit());
            }

            public int protocolClassId() {
                return 20;
            }

            public int protocolMethodId() {
                return 20;
            }

            public String protocolMethodName() {
                return "channel.flow";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(active=").append(this.active).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeBit(this.active);
            }
        }

        public static class OpenOk
        extends Method
        implements AMQP.Channel.OpenOk {
            public static final int INDEX = 11;
            private final LongString channelId;

            public LongString getChannelId() {
                return this.channelId;
            }

            public OpenOk(LongString channelId) {
                if (channelId == null) {
                    throw new IllegalStateException("Invalid configuration: 'channelId' must be non-null.");
                }
                this.channelId = channelId;
            }

            public OpenOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readLongstr());
            }

            public int protocolClassId() {
                return 20;
            }

            public int protocolMethodId() {
                return 11;
            }

            public String protocolMethodName() {
                return "channel.open-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(channel-id=").append(this.channelId).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLongstr(this.channelId);
            }
        }

        public static class Open
        extends Method
        implements AMQP.Channel.Open {
            public static final int INDEX = 10;
            private final String outOfBand;

            public String getOutOfBand() {
                return this.outOfBand;
            }

            public Open(String outOfBand) {
                if (outOfBand == null) {
                    throw new IllegalStateException("Invalid configuration: 'outOfBand' must be non-null.");
                }
                this.outOfBand = outOfBand;
            }

            public Open(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShortstr());
            }

            public int protocolClassId() {
                return 20;
            }

            public int protocolMethodId() {
                return 10;
            }

            public String protocolMethodName() {
                return "channel.open";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(out-of-band=").append(this.outOfBand).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.outOfBand);
            }
        }
    }

    public static class Connection {
        public static final int INDEX = 10;

        public static class Unblocked
        extends Method
        implements AMQP.Connection.Unblocked {
            public static final int INDEX = 61;

            public Unblocked() {
            }

            public Unblocked(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 61;
            }

            public String protocolMethodName() {
                return "connection.unblocked";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Blocked
        extends Method
        implements AMQP.Connection.Blocked {
            public static final int INDEX = 60;
            private final String reason;

            public String getReason() {
                return this.reason;
            }

            public Blocked(String reason) {
                if (reason == null) {
                    throw new IllegalStateException("Invalid configuration: 'reason' must be non-null.");
                }
                this.reason = reason;
            }

            public Blocked(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShortstr());
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 60;
            }

            public String protocolMethodName() {
                return "connection.blocked";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(reason=").append(this.reason).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.reason);
            }
        }

        public static class CloseOk
        extends Method
        implements AMQP.Connection.CloseOk {
            public static final int INDEX = 51;

            public CloseOk() {
            }

            public CloseOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 51;
            }

            public String protocolMethodName() {
                return "connection.close-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Close
        extends Method
        implements AMQP.Connection.Close {
            public static final int INDEX = 50;
            private final int replyCode;
            private final String replyText;
            private final int classId;
            private final int methodId;

            public int getReplyCode() {
                return this.replyCode;
            }

            public String getReplyText() {
                return this.replyText;
            }

            public int getClassId() {
                return this.classId;
            }

            public int getMethodId() {
                return this.methodId;
            }

            public Close(int replyCode, String replyText, int classId, int methodId) {
                if (replyText == null) {
                    throw new IllegalStateException("Invalid configuration: 'replyText' must be non-null.");
                }
                this.replyCode = replyCode;
                this.replyText = replyText;
                this.classId = classId;
                this.methodId = methodId;
            }

            public Close(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readShort(), rdr.readShort());
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 50;
            }

            public String protocolMethodName() {
                return "connection.close";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(reply-code=").append(this.replyCode).append(", reply-text=").append(this.replyText).append(", class-id=").append(this.classId).append(", method-id=").append(this.methodId).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.replyCode);
                writer.writeShortstr(this.replyText);
                writer.writeShort(this.classId);
                writer.writeShort(this.methodId);
            }
        }

        public static class OpenOk
        extends Method
        implements AMQP.Connection.OpenOk {
            public static final int INDEX = 41;
            private final String knownHosts;

            public String getKnownHosts() {
                return this.knownHosts;
            }

            public OpenOk(String knownHosts) {
                if (knownHosts == null) {
                    throw new IllegalStateException("Invalid configuration: 'knownHosts' must be non-null.");
                }
                this.knownHosts = knownHosts;
            }

            public OpenOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShortstr());
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 41;
            }

            public String protocolMethodName() {
                return "connection.open-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(known-hosts=").append(this.knownHosts).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.knownHosts);
            }
        }

        public static class Open
        extends Method
        implements AMQP.Connection.Open {
            public static final int INDEX = 40;
            private final String virtualHost;
            private final String capabilities;
            private final boolean insist;

            public String getVirtualHost() {
                return this.virtualHost;
            }

            public String getCapabilities() {
                return this.capabilities;
            }

            public boolean getInsist() {
                return this.insist;
            }

            public Open(String virtualHost, String capabilities, boolean insist) {
                if (virtualHost == null) {
                    throw new IllegalStateException("Invalid configuration: 'virtualHost' must be non-null.");
                }
                if (capabilities == null) {
                    throw new IllegalStateException("Invalid configuration: 'capabilities' must be non-null.");
                }
                this.virtualHost = virtualHost;
                this.capabilities = capabilities;
                this.insist = insist;
            }

            public Open(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShortstr(), rdr.readShortstr(), rdr.readBit());
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 40;
            }

            public String protocolMethodName() {
                return "connection.open";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(virtual-host=").append(this.virtualHost).append(", capabilities=").append(this.capabilities).append(", insist=").append(this.insist).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.virtualHost);
                writer.writeShortstr(this.capabilities);
                writer.writeBit(this.insist);
            }
        }

        public static class TuneOk
        extends Method
        implements AMQP.Connection.TuneOk {
            public static final int INDEX = 31;
            private final int channelMax;
            private final int frameMax;
            private final int heartbeat;

            public int getChannelMax() {
                return this.channelMax;
            }

            public int getFrameMax() {
                return this.frameMax;
            }

            public int getHeartbeat() {
                return this.heartbeat;
            }

            public TuneOk(int channelMax, int frameMax, int heartbeat) {
                this.channelMax = channelMax;
                this.frameMax = frameMax;
                this.heartbeat = heartbeat;
            }

            public TuneOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readLong(), rdr.readShort());
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 31;
            }

            public String protocolMethodName() {
                return "connection.tune-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(channel-max=").append(this.channelMax).append(", frame-max=").append(this.frameMax).append(", heartbeat=").append(this.heartbeat).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.channelMax);
                writer.writeLong(this.frameMax);
                writer.writeShort(this.heartbeat);
            }
        }

        public static class Tune
        extends Method
        implements AMQP.Connection.Tune {
            public static final int INDEX = 30;
            private final int channelMax;
            private final int frameMax;
            private final int heartbeat;

            public int getChannelMax() {
                return this.channelMax;
            }

            public int getFrameMax() {
                return this.frameMax;
            }

            public int getHeartbeat() {
                return this.heartbeat;
            }

            public Tune(int channelMax, int frameMax, int heartbeat) {
                this.channelMax = channelMax;
                this.frameMax = frameMax;
                this.heartbeat = heartbeat;
            }

            public Tune(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readLong(), rdr.readShort());
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 30;
            }

            public String protocolMethodName() {
                return "connection.tune";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(channel-max=").append(this.channelMax).append(", frame-max=").append(this.frameMax).append(", heartbeat=").append(this.heartbeat).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.channelMax);
                writer.writeLong(this.frameMax);
                writer.writeShort(this.heartbeat);
            }
        }

        public static class SecureOk
        extends Method
        implements AMQP.Connection.SecureOk {
            public static final int INDEX = 21;
            private final LongString response;

            public LongString getResponse() {
                return this.response;
            }

            public SecureOk(LongString response) {
                if (response == null) {
                    throw new IllegalStateException("Invalid configuration: 'response' must be non-null.");
                }
                this.response = response;
            }

            public SecureOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readLongstr());
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 21;
            }

            public String protocolMethodName() {
                return "connection.secure-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(response=").append(this.response).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLongstr(this.response);
            }
        }

        public static class Secure
        extends Method
        implements AMQP.Connection.Secure {
            public static final int INDEX = 20;
            private final LongString challenge;

            public LongString getChallenge() {
                return this.challenge;
            }

            public Secure(LongString challenge) {
                if (challenge == null) {
                    throw new IllegalStateException("Invalid configuration: 'challenge' must be non-null.");
                }
                this.challenge = challenge;
            }

            public Secure(MethodArgumentReader rdr) throws IOException {
                this(rdr.readLongstr());
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 20;
            }

            public String protocolMethodName() {
                return "connection.secure";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(challenge=").append(this.challenge).append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLongstr(this.challenge);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class StartOk
        extends Method
        implements AMQP.Connection.StartOk {
            public static final int INDEX = 11;
            private final Map<String, Object> clientProperties;
            private final String mechanism;
            private final LongString response;
            private final String locale;

            @Override
            public Map<String, Object> getClientProperties() {
                return this.clientProperties;
            }

            @Override
            public String getMechanism() {
                return this.mechanism;
            }

            @Override
            public LongString getResponse() {
                return this.response;
            }

            @Override
            public String getLocale() {
                return this.locale;
            }

            public StartOk(Map<String, Object> clientProperties, String mechanism, LongString response, String locale) {
                if (locale == null) {
                    throw new IllegalStateException("Invalid configuration: 'locale' must be non-null.");
                }
                if (response == null) {
                    throw new IllegalStateException("Invalid configuration: 'response' must be non-null.");
                }
                if (mechanism == null) {
                    throw new IllegalStateException("Invalid configuration: 'mechanism' must be non-null.");
                }
                this.clientProperties = clientProperties == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(clientProperties));
                this.mechanism = mechanism;
                this.response = response;
                this.locale = locale;
            }

            public StartOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readTable(), rdr.readShortstr(), rdr.readLongstr(), rdr.readShortstr());
            }

            @Override
            public int protocolClassId() {
                return 10;
            }

            @Override
            public int protocolMethodId() {
                return 11;
            }

            @Override
            public String protocolMethodName() {
                return "connection.start-ok";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(client-properties=").append(this.clientProperties).append(", mechanism=").append(this.mechanism).append(", response=").append(this.response).append(", locale=").append(this.locale).append(")");
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeTable(this.clientProperties);
                writer.writeShortstr(this.mechanism);
                writer.writeLongstr(this.response);
                writer.writeShortstr(this.locale);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Start
        extends Method
        implements AMQP.Connection.Start {
            public static final int INDEX = 10;
            private final int versionMajor;
            private final int versionMinor;
            private final Map<String, Object> serverProperties;
            private final LongString mechanisms;
            private final LongString locales;

            @Override
            public int getVersionMajor() {
                return this.versionMajor;
            }

            @Override
            public int getVersionMinor() {
                return this.versionMinor;
            }

            @Override
            public Map<String, Object> getServerProperties() {
                return this.serverProperties;
            }

            @Override
            public LongString getMechanisms() {
                return this.mechanisms;
            }

            @Override
            public LongString getLocales() {
                return this.locales;
            }

            public Start(int versionMajor, int versionMinor, Map<String, Object> serverProperties, LongString mechanisms, LongString locales) {
                if (mechanisms == null) {
                    throw new IllegalStateException("Invalid configuration: 'mechanisms' must be non-null.");
                }
                if (locales == null) {
                    throw new IllegalStateException("Invalid configuration: 'locales' must be non-null.");
                }
                this.versionMajor = versionMajor;
                this.versionMinor = versionMinor;
                this.serverProperties = serverProperties == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(serverProperties));
                this.mechanisms = mechanisms;
                this.locales = locales;
            }

            public Start(MethodArgumentReader rdr) throws IOException {
                this(rdr.readOctet(), rdr.readOctet(), rdr.readTable(), rdr.readLongstr(), rdr.readLongstr());
            }

            @Override
            public int protocolClassId() {
                return 10;
            }

            @Override
            public int protocolMethodId() {
                return 10;
            }

            @Override
            public String protocolMethodName() {
                return "connection.start";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(version-major=").append(this.versionMajor).append(", version-minor=").append(this.versionMinor).append(", server-properties=").append(this.serverProperties).append(", mechanisms=").append(this.mechanisms).append(", locales=").append(this.locales).append(")");
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeOctet(this.versionMajor);
                writer.writeOctet(this.versionMinor);
                writer.writeTable(this.serverProperties);
                writer.writeLongstr(this.mechanisms);
                writer.writeLongstr(this.locales);
            }
        }
    }
}

