/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.Method;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQCommand;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.ShutdownNotifierComponent;
import com.rabbitmq.utility.BlockingValueOrException;
import java.io.IOException;
import java.util.concurrent.TimeoutException;

public abstract class AMQChannel
extends ShutdownNotifierComponent {
    protected final Object _channelMutex = new Object();
    private final AMQConnection _connection;
    private final int _channelNumber;
    private AMQCommand _command = new AMQCommand();
    private RpcContinuation _activeRpc = null;
    public boolean _blockContent = false;

    public AMQChannel(AMQConnection connection, int channelNumber) {
        this._connection = connection;
        this._channelNumber = channelNumber;
    }

    public int getChannelNumber() {
        return this._channelNumber;
    }

    public void handleFrame(Frame frame) throws IOException {
        AMQCommand command = this._command;
        if (command.handleFrame(frame)) {
            this._command = new AMQCommand();
            this.handleCompleteInboundCommand(command);
        }
    }

    public static IOException wrap(ShutdownSignalException ex) {
        return AMQChannel.wrap(ex, null);
    }

    public static IOException wrap(ShutdownSignalException ex, String message) {
        IOException ioe = new IOException(message);
        ioe.initCause(ex);
        return ioe;
    }

    public AMQCommand exnWrappingRpc(Method m) throws IOException {
        try {
            return this.privateRpc(m);
        }
        catch (AlreadyClosedException ace) {
            throw ace;
        }
        catch (ShutdownSignalException ex) {
            throw AMQChannel.wrap(ex);
        }
    }

    public void handleCompleteInboundCommand(AMQCommand command) throws IOException {
        if (!this.processAsync(command)) {
            this.nextOutstandingRpc().handleCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueRpc(RpcContinuation k) {
        Object object = this._channelMutex;
        synchronized (object) {
            boolean waitClearedInterruptStatus = false;
            while (this._activeRpc != null) {
                try {
                    this._channelMutex.wait();
                }
                catch (InterruptedException e) {
                    waitClearedInterruptStatus = true;
                }
            }
            if (waitClearedInterruptStatus) {
                Thread.currentThread().interrupt();
            }
            this._activeRpc = k;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutstandingRpc() {
        Object object = this._channelMutex;
        synchronized (object) {
            return this._activeRpc != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RpcContinuation nextOutstandingRpc() {
        Object object = this._channelMutex;
        synchronized (object) {
            RpcContinuation result = this._activeRpc;
            this._activeRpc = null;
            this._channelMutex.notifyAll();
            return result;
        }
    }

    public void ensureIsOpen() throws AlreadyClosedException {
        if (!this.isOpen()) {
            throw new AlreadyClosedException(this.getCloseReason());
        }
    }

    public AMQCommand rpc(Method m) throws IOException, ShutdownSignalException {
        return this.privateRpc(m);
    }

    private AMQCommand privateRpc(Method m) throws IOException, ShutdownSignalException {
        SimpleBlockingRpcContinuation k = new SimpleBlockingRpcContinuation();
        this.rpc(m, k);
        return (AMQCommand)k.getReply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rpc(Method m, RpcContinuation k) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.ensureIsOpen();
            this.quiescingRpc(m, k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiescingRpc(Method m, RpcContinuation k) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.enqueueRpc(k);
            this.quiescingTransmit(m);
        }
    }

    public abstract boolean processAsync(Command var1) throws IOException;

    public String toString() {
        return "AMQChannel(" + this._connection + "," + this._channelNumber + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processShutdownSignal(ShutdownSignalException signal, boolean ignoreClosed, boolean notifyRpc) {
        try {
            Object object = this._channelMutex;
            synchronized (object) {
                if (!this.setShutdownCauseIfOpen(signal) && !ignoreClosed) {
                    throw new AlreadyClosedException(this.getCloseReason());
                }
                this._channelMutex.notifyAll();
            }
        }
        finally {
            if (notifyRpc) {
                this.notifyOutstandingRpc(signal);
            }
        }
    }

    public void notifyOutstandingRpc(ShutdownSignalException signal) {
        RpcContinuation k = this.nextOutstandingRpc();
        if (k != null) {
            k.handleShutdownSignal(signal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmit(Method m) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.transmit(new AMQCommand(m));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmit(AMQCommand c) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.ensureIsOpen();
            this.quiescingTransmit(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiescingTransmit(Method m) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.quiescingTransmit(new AMQCommand(m));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiescingTransmit(AMQCommand c) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            if (c.getMethod().hasContent()) {
                while (this._blockContent) {
                    try {
                        this._channelMutex.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.ensureIsOpen();
                }
            }
            c.transmit(this);
        }
    }

    public AMQConnection getConnection() {
        return this._connection;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleBlockingRpcContinuation
    extends BlockingRpcContinuation<AMQCommand> {
        @Override
        public AMQCommand transformReply(AMQCommand command) {
            return command;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BlockingRpcContinuation<T>
    implements RpcContinuation {
        public final BlockingValueOrException<T, ShutdownSignalException> _blocker = new BlockingValueOrException();

        @Override
        public void handleCommand(AMQCommand command) {
            this._blocker.setValue(this.transformReply(command));
        }

        @Override
        public void handleShutdownSignal(ShutdownSignalException signal) {
            this._blocker.setException(signal);
        }

        public T getReply() throws ShutdownSignalException {
            return this._blocker.uninterruptibleGetValue();
        }

        public T getReply(int timeout) throws ShutdownSignalException, TimeoutException {
            return this._blocker.uninterruptibleGetValue(timeout);
        }

        public abstract T transformReply(AMQCommand var1);
    }

    public static interface RpcContinuation {
        public void handleCommand(AMQCommand var1);

        public void handleShutdownSignal(ShutdownSignalException var1);
    }
}

