/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.AuthenticationFailureException;
import com.rabbitmq.client.BlockedListener;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ExceptionHandler;
import com.rabbitmq.client.LongString;
import com.rabbitmq.client.Method;
import com.rabbitmq.client.MissedHeartbeatException;
import com.rabbitmq.client.PossibleAuthenticationFailureException;
import com.rabbitmq.client.ProtocolVersionMismatchException;
import com.rabbitmq.client.SaslConfig;
import com.rabbitmq.client.SaslMechanism;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQChannel;
import com.rabbitmq.client.impl.AMQCommand;
import com.rabbitmq.client.impl.ChannelManager;
import com.rabbitmq.client.impl.ChannelN;
import com.rabbitmq.client.impl.ConnectionParams;
import com.rabbitmq.client.impl.ConsumerWorkService;
import com.rabbitmq.client.impl.Environment;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.FrameHandler;
import com.rabbitmq.client.impl.HeartbeatSender;
import com.rabbitmq.client.impl.LongStringHelper;
import com.rabbitmq.client.impl.NetworkConnection;
import com.rabbitmq.client.impl.ShutdownNotifierComponent;
import com.rabbitmq.client.impl.Version;
import com.rabbitmq.utility.BlockingCell;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQConnection
extends ShutdownNotifierComponent
implements Connection,
NetworkConnection {
    public static final int HANDSHAKE_TIMEOUT = 10000;
    private final ExecutorService executor;
    private Thread mainLoopThread;
    private ThreadFactory threadFactory = Executors.defaultThreadFactory();
    private static final Version clientVersion = new Version(0, 9);
    private final AMQChannel _channel0 = new AMQChannel(this, 0){

        public boolean processAsync(Command c) throws IOException {
            return this.getConnection().processControlCommand(c);
        }
    };
    protected ConsumerWorkService _workService = null;
    private final FrameHandler _frameHandler;
    private volatile boolean _running = false;
    private ExceptionHandler _exceptionHandler;
    private final BlockingCell<Object> _appContinuation = new BlockingCell();
    private volatile boolean _brokerInitiatedShutdown;
    private volatile boolean _inConnectionNegotiation;
    private HeartbeatSender _heartbeatSender;
    private final String _virtualHost;
    private final Map<String, Object> _clientProperties;
    private final SaslConfig saslConfig;
    private final int requestedHeartbeat;
    private final int requestedChannelMax;
    private final int requestedFrameMax;
    private final String username;
    private final String password;
    private final Collection<BlockedListener> blockedListeners = new CopyOnWriteArrayList<BlockedListener>();
    private volatile int _frameMax = 0;
    private volatile int _missedHeartbeats = 0;
    private volatile int _heartbeat = 0;
    private volatile ChannelManager _channelManager;
    private volatile Map<String, Object> _serverProperties;

    public static final Map<String, Object> defaultClientProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("product", LongStringHelper.asLongString("RabbitMQ"));
        props.put("version", LongStringHelper.asLongString("3.3.5"));
        props.put("platform", LongStringHelper.asLongString("Java"));
        props.put("copyright", LongStringHelper.asLongString("Copyright (C) 2007-2014 GoPivotal, Inc."));
        props.put("information", LongStringHelper.asLongString("Licensed under the MPL. See http://www.rabbitmq.com/"));
        HashMap<String, Boolean> capabilities = new HashMap<String, Boolean>();
        capabilities.put("publisher_confirms", true);
        capabilities.put("exchange_exchange_bindings", true);
        capabilities.put("basic.nack", true);
        capabilities.put("consumer_cancel_notify", true);
        capabilities.put("connection.blocked", true);
        capabilities.put("authentication_failure_close", true);
        props.put("capabilities", capabilities);
        return props;
    }

    public final void disconnectChannel(ChannelN channel) {
        ChannelManager cm = this._channelManager;
        if (cm != null) {
            cm.releaseChannelNumber(channel);
        }
    }

    private final void ensureIsOpen() throws AlreadyClosedException {
        if (!this.isOpen()) {
            throw new AlreadyClosedException(this.getCloseReason());
        }
    }

    @Override
    public InetAddress getAddress() {
        return this._frameHandler.getAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this._frameHandler.getLocalAddress();
    }

    @Override
    public int getPort() {
        return this._frameHandler.getPort();
    }

    @Override
    public int getLocalPort() {
        return this._frameHandler.getLocalPort();
    }

    public FrameHandler getFrameHandler() {
        return this._frameHandler;
    }

    @Override
    public Map<String, Object> getServerProperties() {
        return this._serverProperties;
    }

    public AMQConnection(ConnectionParams params, FrameHandler frameHandler) {
        AMQConnection.checkPreconditions();
        this.username = params.getUsername();
        this.password = params.getPassword();
        this._frameHandler = frameHandler;
        this._virtualHost = params.getVirtualHost();
        this._exceptionHandler = params.getExceptionHandler();
        this._clientProperties = new HashMap<String, Object>(params.getClientProperties());
        this.requestedFrameMax = params.getRequestedFrameMax();
        this.requestedChannelMax = params.getRequestedChannelMax();
        this.requestedHeartbeat = params.getRequestedHeartbeat();
        this.saslConfig = params.getSaslConfig();
        this.executor = params.getExecutor();
        this.threadFactory = params.getThreadFactory();
        this._channelManager = null;
        this._brokerInitiatedShutdown = false;
        this._inConnectionNegotiation = true;
    }

    private void initializeConsumerWorkService() {
        this._workService = new ConsumerWorkService(this.executor, this.threadFactory);
    }

    private void initializeHeartbeatSender() {
        this._heartbeatSender = new HeartbeatSender(this._frameHandler, this.threadFactory);
    }

    public void start() throws IOException {
        this.initializeConsumerWorkService();
        this.initializeHeartbeatSender();
        this._running = true;
        AMQChannel.SimpleBlockingRpcContinuation connStartBlocker = new AMQChannel.SimpleBlockingRpcContinuation();
        this._channel0.enqueueRpc(connStartBlocker);
        try {
            this._frameHandler.setTimeout(10000);
            this._frameHandler.sendHeader();
        }
        catch (IOException ioe) {
            this._frameHandler.close();
            throw ioe;
        }
        MainLoop loop = new MainLoop();
        String name = "AMQP Connection " + this.getHostAddress() + ":" + this.getPort();
        this.mainLoopThread = Environment.newThread(this.threadFactory, loop, name);
        this.mainLoopThread.start();
        AMQP.Connection.Start connStart = null;
        AMQP.Connection.Tune connTune = null;
        try {
            connStart = (AMQP.Connection.Start)((Object)((AMQCommand)connStartBlocker.getReply()).getMethod());
            this._serverProperties = Collections.unmodifiableMap(connStart.getServerProperties());
            Version serverVersion = new Version(connStart.getVersionMajor(), connStart.getVersionMinor());
            if (!Version.checkVersion(clientVersion, serverVersion)) {
                throw new ProtocolVersionMismatchException(clientVersion, serverVersion);
            }
            String[] mechanisms = connStart.getMechanisms().toString().split(" ");
            SaslMechanism sm = this.saslConfig.getSaslMechanism(mechanisms);
            if (sm == null) {
                throw new IOException("No compatible authentication mechanism found - server offered [" + connStart.getMechanisms() + "]");
            }
            LongString challenge = null;
            LongString response = sm.handleChallenge(null, this.username, this.password);
            do {
                AMQP.Connection.SecureOk method = challenge == null ? new AMQP.Connection.StartOk.Builder().clientProperties(this._clientProperties).mechanism(sm.getName()).response(response).build() : new AMQP.Connection.SecureOk.Builder().response(response).build();
                try {
                    com.rabbitmq.client.impl.Method serverResponse = this._channel0.rpc(method).getMethod();
                    if (serverResponse instanceof AMQP.Connection.Tune) {
                        connTune = (AMQP.Connection.Tune)((Object)serverResponse);
                        continue;
                    }
                    challenge = ((AMQP.Connection.Secure)((Object)serverResponse)).getChallenge();
                    response = sm.handleChallenge(challenge, this.username, this.password);
                }
                catch (ShutdownSignalException e) {
                    AMQP.Connection.Close shutdownClose;
                    Method shutdownMethod = e.getReason();
                    if (shutdownMethod instanceof AMQP.Connection.Close && (shutdownClose = (AMQP.Connection.Close)shutdownMethod).getReplyCode() == 403) {
                        throw new AuthenticationFailureException(shutdownClose.getReplyText());
                    }
                    throw new PossibleAuthenticationFailureException(e);
                }
            } while (connTune == null);
        }
        catch (ShutdownSignalException sse) {
            this._frameHandler.close();
            throw AMQChannel.wrap(sse);
        }
        catch (IOException ioe) {
            this._frameHandler.close();
            throw ioe;
        }
        try {
            int frameMax;
            int channelMax = this.negotiateChannelMax(this.requestedChannelMax, connTune.getChannelMax());
            this._channelManager = this.instantiateChannelManager(channelMax, this.threadFactory);
            this._frameMax = frameMax = AMQConnection.negotiatedMaxValue(this.requestedFrameMax, connTune.getFrameMax());
            int heartbeat = AMQConnection.negotiatedMaxValue(this.requestedHeartbeat, connTune.getHeartbeat());
            this.setHeartbeat(heartbeat);
            this._channel0.transmit(new AMQP.Connection.TuneOk.Builder().channelMax(channelMax).frameMax(frameMax).heartbeat(heartbeat).build());
            this._channel0.exnWrappingRpc(new AMQP.Connection.Open.Builder().virtualHost(this._virtualHost).build());
        }
        catch (IOException ioe) {
            this._heartbeatSender.shutdown();
            this._frameHandler.close();
            throw ioe;
        }
        catch (ShutdownSignalException sse) {
            this._heartbeatSender.shutdown();
            this._frameHandler.close();
            throw AMQChannel.wrap(sse);
        }
        this._inConnectionNegotiation = false;
    }

    protected ChannelManager instantiateChannelManager(int channelMax, ThreadFactory threadFactory) {
        return new ChannelManager(this._workService, channelMax, threadFactory);
    }

    protected int negotiateChannelMax(int requestedChannelMax, int serverMax) {
        return AMQConnection.negotiatedMaxValue(requestedChannelMax, serverMax);
    }

    private static final void checkPreconditions() {
        AMQCommand.checkPreconditions();
    }

    @Override
    public int getChannelMax() {
        ChannelManager cm = this._channelManager;
        if (cm == null) {
            return 0;
        }
        return cm.getChannelMax();
    }

    @Override
    public int getFrameMax() {
        return this._frameMax;
    }

    @Override
    public int getHeartbeat() {
        return this._heartbeat;
    }

    public void setHeartbeat(int heartbeat) {
        try {
            this._heartbeatSender.setHeartbeat(heartbeat);
            this._heartbeat = heartbeat;
            this._frameHandler.setTimeout(heartbeat * 1000 / 4);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    @Override
    public Map<String, Object> getClientProperties() {
        return new HashMap<String, Object>(this._clientProperties);
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        return this._exceptionHandler;
    }

    public boolean willShutDownConsumerExecutor() {
        return this._workService.usesPrivateExecutor();
    }

    @Override
    public Channel createChannel(int channelNumber) throws IOException {
        this.ensureIsOpen();
        ChannelManager cm = this._channelManager;
        if (cm == null) {
            return null;
        }
        return cm.createChannel(this, channelNumber);
    }

    @Override
    public Channel createChannel() throws IOException {
        this.ensureIsOpen();
        ChannelManager cm = this._channelManager;
        if (cm == null) {
            return null;
        }
        return cm.createChannel(this);
    }

    public void writeFrame(Frame f) throws IOException {
        this._frameHandler.writeFrame(f);
        this._heartbeatSender.signalActivity();
    }

    public void flush() throws IOException {
        this._frameHandler.flush();
    }

    private static final int negotiatedMaxValue(int clientValue, int serverValue) {
        return clientValue == 0 || serverValue == 0 ? Math.max(clientValue, serverValue) : Math.min(clientValue, serverValue);
    }

    private void handleSocketTimeout() throws SocketTimeoutException {
        if (this._inConnectionNegotiation) {
            throw new SocketTimeoutException("Timeout during Connection negotiation");
        }
        if (this._heartbeat == 0) {
            return;
        }
        if (++this._missedHeartbeats > 8) {
            throw new MissedHeartbeatException("Heartbeat missing with heartbeat = " + this._heartbeat + " seconds");
        }
    }

    public boolean processControlCommand(Command c) throws IOException {
        Method method = c.getMethod();
        if (this.isOpen()) {
            if (method instanceof AMQP.Connection.Close) {
                this.handleConnectionClose(c);
                return true;
            }
            if (method instanceof AMQP.Connection.Blocked) {
                AMQP.Connection.Blocked blocked = (AMQP.Connection.Blocked)method;
                try {
                    for (BlockedListener l : this.blockedListeners) {
                        l.handleBlocked(blocked.getReason());
                    }
                }
                catch (Throwable ex) {
                    this.getExceptionHandler().handleBlockedListenerException(this, ex);
                }
                return true;
            }
            if (method instanceof AMQP.Connection.Unblocked) {
                try {
                    for (BlockedListener l : this.blockedListeners) {
                        l.handleUnblocked();
                    }
                }
                catch (Throwable ex) {
                    this.getExceptionHandler().handleBlockedListenerException(this, ex);
                }
                return true;
            }
            return false;
        }
        if (method instanceof AMQP.Connection.Close) {
            try {
                this._channel0.quiescingTransmit(new AMQP.Connection.CloseOk.Builder().build());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        if (method instanceof AMQP.Connection.CloseOk) {
            this._running = false;
            return !this._channel0.isOutstandingRpc();
        }
        return true;
    }

    public void handleConnectionClose(Command closeCommand) {
        ShutdownSignalException sse = this.shutdown(closeCommand.getMethod(), false, null, this._inConnectionNegotiation);
        try {
            this._channel0.quiescingTransmit(new AMQP.Connection.CloseOk.Builder().build());
        }
        catch (IOException _) {
            // empty catch block
        }
        this._brokerInitiatedShutdown = true;
        SocketCloseWait scw = new SocketCloseWait(sse);
        String name = "AMQP Connection Closing Monitor " + this.getHostAddress() + ":" + this.getPort();
        Thread waiter = Environment.newThread(this.threadFactory, scw, name);
        waiter.start();
    }

    public ShutdownSignalException shutdown(Method reason, boolean initiatedByApplication, Throwable cause, boolean notifyRpc) {
        ShutdownSignalException sse = this.startShutdown(reason, initiatedByApplication, cause, notifyRpc);
        this.finishShutdown(sse);
        return sse;
    }

    private ShutdownSignalException startShutdown(Method reason, boolean initiatedByApplication, Throwable cause, boolean notifyRpc) {
        ShutdownSignalException sse = new ShutdownSignalException(true, initiatedByApplication, reason, this);
        sse.initCause(cause);
        if (!this.setShutdownCauseIfOpen(sse) && initiatedByApplication) {
            throw new AlreadyClosedException(this.getCloseReason(), cause);
        }
        this._heartbeatSender.shutdown();
        this._channel0.processShutdownSignal(sse, !initiatedByApplication, notifyRpc);
        return sse;
    }

    private void finishShutdown(ShutdownSignalException sse) {
        ChannelManager cm = this._channelManager;
        if (cm != null) {
            cm.handleSignal(sse);
        }
    }

    @Override
    public void close() throws IOException {
        this.close(-1);
    }

    @Override
    public void close(int timeout) throws IOException {
        this.close(200, "OK", timeout);
    }

    @Override
    public void close(int closeCode, String closeMessage) throws IOException {
        this.close(closeCode, closeMessage, -1);
    }

    @Override
    public void close(int closeCode, String closeMessage, int timeout) throws IOException {
        this.close(closeCode, closeMessage, true, null, timeout, false);
    }

    @Override
    public void abort() {
        this.abort(-1);
    }

    @Override
    public void abort(int closeCode, String closeMessage) {
        this.abort(closeCode, closeMessage, -1);
    }

    @Override
    public void abort(int timeout) {
        this.abort(200, "OK", timeout);
    }

    @Override
    public void abort(int closeCode, String closeMessage, int timeout) {
        try {
            this.close(closeCode, closeMessage, true, null, timeout, true);
        }
        catch (IOException _) {
            // empty catch block
        }
    }

    public void close(int closeCode, String closeMessage, boolean initiatedByApplication, Throwable cause) throws IOException {
        this.close(closeCode, closeMessage, initiatedByApplication, cause, -1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int closeCode, String closeMessage, boolean initiatedByApplication, Throwable cause, int timeout, boolean abort) throws IOException {
        boolean sync = Thread.currentThread() != this.mainLoopThread;
        try {
            AMQP.Connection.Close reason = new AMQP.Connection.Close.Builder().replyCode(closeCode).replyText(closeMessage).build();
            final ShutdownSignalException sse = this.startShutdown(reason, initiatedByApplication, cause, true);
            if (sync) {
                AMQChannel.BlockingRpcContinuation<AMQCommand> k = new AMQChannel.BlockingRpcContinuation<AMQCommand>(){

                    @Override
                    public AMQCommand transformReply(AMQCommand command) {
                        AMQConnection.this.finishShutdown(sse);
                        return command;
                    }
                };
                this._channel0.quiescingRpc(reason, k);
                k.getReply(timeout);
            } else {
                this._channel0.quiescingTransmit(reason);
            }
        }
        catch (TimeoutException tte) {
            if (!abort) {
                ShutdownSignalException sse = new ShutdownSignalException(true, true, null, this);
                sse.initCause(cause);
                throw sse;
            }
        }
        catch (ShutdownSignalException sse) {
            if (!abort) {
                throw sse;
            }
        }
        catch (IOException ioe) {
            if (!abort) {
                throw ioe;
            }
        }
        finally {
            if (sync) {
                this._frameHandler.close();
            }
        }
    }

    public String toString() {
        return "amqp://" + this.username + "@" + this.getHostAddress() + ":" + this.getPort() + this._virtualHost;
    }

    private String getHostAddress() {
        return this.getAddress() == null ? null : this.getAddress().getHostAddress();
    }

    @Override
    public void addBlockedListener(BlockedListener listener) {
        this.blockedListeners.add(listener);
    }

    @Override
    public boolean removeBlockedListener(BlockedListener listener) {
        return this.blockedListeners.remove(listener);
    }

    @Override
    public void clearBlockedListeners() {
        this.blockedListeners.clear();
    }

    private class SocketCloseWait
    implements Runnable {
        private final ShutdownSignalException cause;

        public SocketCloseWait(ShutdownSignalException sse) {
            this.cause = sse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                AMQConnection.this._appContinuation.uninterruptibleGet();
            }
            finally {
                AMQConnection.this._running = false;
                AMQConnection.this._channel0.notifyOutstandingRpc(this.cause);
            }
        }
    }

    private class MainLoop
    implements Runnable {
        private MainLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (AMQConnection.this._running) {
                    Frame frame = AMQConnection.this._frameHandler.readFrame();
                    if (frame != null) {
                        ChannelManager cm;
                        AMQConnection.this._missedHeartbeats = 0;
                        if (frame.type == 8) continue;
                        if (frame.channel == 0) {
                            AMQConnection.this._channel0.handleFrame(frame);
                            continue;
                        }
                        if (!AMQConnection.this.isOpen() || (cm = AMQConnection.this._channelManager) == null) continue;
                        cm.getChannel(frame.channel).handleFrame(frame);
                        continue;
                    }
                    AMQConnection.this.handleSocketTimeout();
                }
            }
            catch (EOFException ex) {
                if (!AMQConnection.this._brokerInitiatedShutdown) {
                    AMQConnection.this.shutdown(null, false, ex, true);
                }
            }
            catch (Throwable ex) {
                AMQConnection.this._exceptionHandler.handleUnexpectedConnectionDriverException(AMQConnection.this, ex);
                AMQConnection.this.shutdown(null, false, ex, true);
            }
            finally {
                AMQConnection.this._frameHandler.close();
                AMQConnection.this._appContinuation.set(null);
                AMQConnection.this.notifyListeners();
            }
        }
    }
}

