/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.charset.StandardCharsets;
import java.util.function.ToIntFunction;

final class HashUtils {
    static final ToIntFunction<String> MURMUR3 = new Murmur3();

    private HashUtils() {
    }

    static class Murmur3
    implements ToIntFunction<String> {
        private static final int DEFAULT_SEED = 104729;
        private static final int C1_32 = -862048943;
        private static final int C2_32 = 461845907;
        private static final int R1_32 = 15;
        private static final int R2_32 = 13;
        private static final int M_32 = 5;
        private static final int N_32 = -430675100;
        private final int seed;

        private static int getLittleEndianInt(byte[] data, int index) {
            return data[index] & 0xFF | (data[index + 1] & 0xFF) << 8 | (data[index + 2] & 0xFF) << 16 | (data[index + 3] & 0xFF) << 24;
        }

        private static int mix32(int k, int hash) {
            k *= -862048943;
            k = Integer.rotateLeft(k, 15);
            return Integer.rotateLeft(hash ^= (k *= 461845907), 13) * 5 + -430675100;
        }

        private static int fmix32(int hash) {
            hash ^= hash >>> 16;
            hash *= -2048144789;
            hash ^= hash >>> 13;
            hash *= -1028477387;
            hash ^= hash >>> 16;
            return hash;
        }

        Murmur3() {
            this(104729);
        }

        Murmur3(int seed) {
            this.seed = seed;
        }

        @Override
        @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH", "SF_SWITCH_NO_DEFAULT"})
        public int applyAsInt(String value) {
            byte[] data = value.getBytes(StandardCharsets.UTF_8);
            boolean offset = false;
            int length = data.length;
            int hash = this.seed;
            int nblocks = length >> 2;
            for (int i = 0; i < nblocks; ++i) {
                int index = 0 + (i << 2);
                int k = Murmur3.getLittleEndianInt(data, index);
                hash = Murmur3.mix32(k, hash);
            }
            int index = 0 + (nblocks << 2);
            int k1 = 0;
            switch (0 + length - index) {
                case 3: {
                    k1 ^= (data[index + 2] & 0xFF) << 16;
                }
                case 2: {
                    k1 ^= (data[index + 1] & 0xFF) << 8;
                }
                case 1: {
                    k1 ^= data[index] & 0xFF;
                    k1 *= -862048943;
                    k1 = Integer.rotateLeft(k1, 15);
                    hash ^= (k1 *= 461845907);
                }
            }
            return Murmur3.fmix32(hash ^= length);
        }
    }
}

