/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath;

import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.xs.ShortList;

class DataMatcher {
    DataMatcher() {
    }

    public static boolean compareActualValues(Object value1, Object value2, int comparator, XSSimpleTypeDecl type) {
        TypeValidator typeValidator = type.getTypeValidator();
        short ordered = type.getOrdered();
        if (ordered == 0) {
            if (comparator == 0) {
                return type.isEqual(value1, value2);
            }
            if (comparator == 1) {
                return !type.isEqual(value1, value2);
            }
            return false;
        }
        switch (comparator) {
            case 0: {
                return typeValidator.compare(value1, value2) == 0;
            }
            case 1: {
                return typeValidator.compare(value1, value2) != 0;
            }
            case 3: {
                return typeValidator.compare(value1, value2) > 0;
            }
            case 5: {
                return typeValidator.compare(value1, value2) >= 0;
            }
            case 2: {
                return typeValidator.compare(value1, value2) < 0;
            }
            case 4: {
                return typeValidator.compare(value1, value2) <= 0;
            }
        }
        return false;
    }

    public static boolean isComparable(short type1, short type2, ShortList typeList1, ShortList typeList2) {
        short primitiveType2;
        short primitiveType1 = DataMatcher.convertToPrimitiveKind(type1);
        if (primitiveType1 != (primitiveType2 = DataMatcher.convertToPrimitiveKind(type2))) {
            return primitiveType1 == 1 && primitiveType2 == 2 || primitiveType1 == 2 && primitiveType2 == 1;
        }
        if (primitiveType1 == 44 || primitiveType1 == 43) {
            int typeList2Length;
            int typeList1Length = typeList1 != null ? typeList1.getLength() : 0;
            int n = typeList2Length = typeList2 != null ? typeList2.getLength() : 0;
            if (typeList1Length != typeList2Length) {
                return false;
            }
            for (int i = 0; i < typeList1Length; ++i) {
                short primitiveItem2;
                short primitiveItem1 = DataMatcher.convertToPrimitiveKind(typeList1.item(i));
                if (primitiveItem1 == (primitiveItem2 = DataMatcher.convertToPrimitiveKind(typeList2.item(i))) || primitiveItem1 == 1 && primitiveItem2 == 2 || primitiveItem1 == 2 && primitiveItem2 == 1) continue;
                return false;
            }
        }
        return true;
    }

    private static short convertToPrimitiveKind(short valueType) {
        if (valueType <= 20) {
            return valueType;
        }
        if (valueType <= 29) {
            return 2;
        }
        if (valueType <= 42) {
            return 4;
        }
        return valueType;
    }
}

