/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath;

import java.io.StringReader;
import org.apache.xerces.impl.xpath.XPath20Parser;
import org.apache.xerces.impl.xpath.XPathException;
import org.apache.xerces.impl.xpath.XPathSyntaxTreeNode;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;

public class XPath20 {
    protected final String fExpression;
    protected final NamespaceContext fNsContext;
    private XPathSyntaxTreeNode fRootNode;

    public XPath20(String xpath, SymbolTable symbolTable, NamespaceContext nsContext) throws XPathException {
        this.fExpression = xpath;
        this.fNsContext = nsContext;
        StringReader reader = new StringReader(this.fExpression + "\n");
        XPath20Parser parser = new XPath20Parser(reader, nsContext);
        this.fRootNode = parser.parseExpression();
    }

    public boolean evaluateTest(QName element, XMLAttributes attributes) {
        try {
            return this.fRootNode.evaluate(element, attributes, this.fNsContext);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getXPathStrValue() {
        return this.fExpression;
    }
}

