/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.redhat_support_lib.infrastructure;

import com.redhat.gss.redhat_support_lib.errors.RequestException;
import com.redhat.gss.redhat_support_lib.helpers.FilterHelper;
import com.redhat.gss.redhat_support_lib.helpers.QueryBuilder;
import com.redhat.gss.redhat_support_lib.infrastructure.BaseQuery;
import com.redhat.gss.redhat_support_lib.parsers.ArticleType;
import com.redhat.gss.redhat_support_lib.parsers.ArticlesType;
import com.redhat.gss.redhat_support_lib.web.ConnectionManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public class Articles
extends BaseQuery {
    private ConnectionManager connectionManager = null;
    static String url = "/rs/articles/";

    public Articles(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public ArticleType get(String artID) throws RequestException, MalformedURLException {
        String fullUrl = this.connectionManager.getConfig().getUrl() + url + artID;
        return this.get(this.connectionManager.getConnection(), fullUrl, ArticleType.class);
    }

    public List<ArticleType> list(String[] keywords, String[] kwargs) throws RequestException, MalformedURLException {
        ArrayList<String> queryParams = new ArrayList<String>();
        for (String arg : keywords) {
            queryParams.add("keyword=" + arg);
        }
        String fullUrl = QueryBuilder.appendQuery(this.connectionManager.getConfig().getUrl() + url, queryParams);
        ArticlesType articlesType = this.get(this.connectionManager.getConnection(), fullUrl, ArticlesType.class);
        return FilterHelper.filterResults(articlesType.getArticle(), kwargs);
    }

    public ArticleType add(ArticleType art) throws Exception {
        String fullUrl = this.connectionManager.getConfig().getUrl() + url;
        Response resp = this.add(this.connectionManager.getConnection(), fullUrl, art);
        MultivaluedMap headers = resp.getStringHeaders();
        URL url = null;
        url = new URL((String)headers.getFirst((Object)"view-uri"));
        String path = url.getPath();
        art.setId(path.substring(path.lastIndexOf(47) + 1, path.length()));
        art.setViewUri(url.toString());
        return art;
    }
}

