/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.redhat_support_lib.infrastructure;

import com.redhat.gss.redhat_support_lib.errors.RequestException;
import com.redhat.gss.redhat_support_lib.helpers.FilterHelper;
import com.redhat.gss.redhat_support_lib.helpers.QueryBuilder;
import com.redhat.gss.redhat_support_lib.infrastructure.BaseQuery;
import com.redhat.gss.redhat_support_lib.parsers.CaseType;
import com.redhat.gss.redhat_support_lib.parsers.CasesType;
import com.redhat.gss.redhat_support_lib.parsers.ValueType;
import com.redhat.gss.redhat_support_lib.parsers.ValuesType;
import com.redhat.gss.redhat_support_lib.web.ConnectionManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public class Cases
extends BaseQuery {
    private ConnectionManager connectionManager = null;
    static String url = "/rs/cases/";

    public Cases(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public CaseType get(String caseNum) throws RequestException, MalformedURLException {
        String fullUrl = this.connectionManager.getConfig().getUrl() + url + caseNum;
        return this.get(this.connectionManager.getConnection(), fullUrl, CaseType.class);
    }

    public List<CaseType> list(String[] keywords, boolean includeClosed, boolean detail, String group, String startDate, String endDate, String count, String start, String[] kwargs) throws RequestException, MalformedURLException {
        StringBuilder xmlString = new StringBuilder();
        xmlString.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><caseFilter xmlns=\"http://www.redhat.com/gss/strata\">");
        if (keywords != null) {
            for (String keyword : keywords) {
                xmlString.append("<keyword>");
                xmlString.append(keyword);
                xmlString.append("</keyword>");
            }
        }
        if (includeClosed) {
            xmlString.append("<includeClosed>true</includeClosed>");
        }
        if (group != null) {
            xmlString.append("<groupNumber>");
            xmlString.append(group);
            xmlString.append("</groupNumber>");
        } else {
            xmlString.append("<onlyUngrouped>");
            xmlString.append("true");
            xmlString.append("</onlyUngrouped>");
        }
        if (startDate != null) {
            xmlString.append("<startDate>");
            xmlString.append(startDate);
            xmlString.append("</startDate>");
        }
        if (endDate != null) {
            xmlString.append("<endDate>");
            xmlString.append(endDate);
            xmlString.append("</endDate>");
        }
        if (count != null) {
            xmlString.append("<count>");
            xmlString.append(count);
            xmlString.append("</count>");
        }
        if (start != null) {
            xmlString.append("<start>");
            xmlString.append(start);
            xmlString.append("</start>");
        }
        xmlString.append("<ownerSSOName>");
        xmlString.append(this.connectionManager.getConfig().getUsername());
        xmlString.append("</ownerSSOName>");
        xmlString.append("</caseFilter>");
        ArrayList<String> queryParams = new ArrayList<String>();
        if (detail) {
            queryParams.add("detail=true");
        }
        String fullUrl = QueryBuilder.appendQuery(this.connectionManager.getConfig().getUrl() + url + "filter", queryParams);
        CasesType cases = this.add(this.connectionManager.getConnection(), fullUrl, xmlString.toString(), CasesType.class);
        return FilterHelper.filterResults(cases.getCase(), kwargs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CaseType add(CaseType cas) throws MalformedURLException, RequestException {
        CaseType caseType;
        Response response = null;
        try {
            String fullUrl = this.connectionManager.getConfig().getUrl() + url;
            response = this.add(this.connectionManager.getConnection(), fullUrl, cas);
            MultivaluedMap headers = response.getStringHeaders();
            URL caseurl = null;
            caseurl = new URL((String)headers.getFirst((Object)"Location"));
            String path = caseurl.getPath();
            cas.setCaseNumber(path.substring(path.lastIndexOf(47) + 1, path.length()));
            cas.setViewUri(caseurl.toString());
            caseType = cas;
        }
        catch (Throwable throwable) {
            this.safeClose(response);
            throw throwable;
        }
        this.safeClose(response);
        return caseType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CaseType update(CaseType cas) throws RequestException, MalformedURLException {
        CaseType caseType;
        String fullUrl = this.connectionManager.getConfig().getUrl() + url + cas.getCaseNumber();
        Response response = null;
        try {
            response = this.update(this.connectionManager.getConnection(), fullUrl, cas);
            caseType = cas;
        }
        catch (Throwable throwable) {
            this.safeClose(response);
            throw throwable;
        }
        this.safeClose(response);
        return caseType;
    }

    public List<ValueType> getSeverities() throws RequestException, MalformedURLException {
        String fullUrl = this.connectionManager.getConfig().getUrl() + "/rs/values/case/severity";
        ValuesType values = this.get(this.connectionManager.getConnection(), fullUrl, ValuesType.class);
        return values.getValue();
    }
}

