/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.redhat_support_lib.infrastructure;

import com.redhat.gss.redhat_support_lib.errors.RequestException;
import com.redhat.gss.redhat_support_lib.helpers.QueryBuilder;
import com.redhat.gss.redhat_support_lib.infrastructure.BaseQuery;
import com.redhat.gss.redhat_support_lib.parsers.CommentType;
import com.redhat.gss.redhat_support_lib.parsers.CommentsType;
import com.redhat.gss.redhat_support_lib.web.ConnectionManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public class Comments
extends BaseQuery {
    private ConnectionManager connectionManager = null;

    public Comments(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public CommentType get(String caseNumber, String commentID) throws RequestException, MalformedURLException {
        String url = "/rs/cases/{caseNumber}/comments/{commentID}";
        url = url.replace("{caseNumber}", caseNumber);
        url = url.replace("{commentID}", commentID);
        String fullUrl = this.connectionManager.getConfig().getUrl() + url;
        return this.get(this.connectionManager.getConnection(), fullUrl, CommentType.class);
    }

    public List<CommentType> list(String caseNumber, String startDate, String endDate, String[] kwargs) throws RequestException, MalformedURLException {
        String url = "/rs/cases/{caseNumber}/comments";
        url = url.replace("{caseNumber}", caseNumber);
        ArrayList<String> queryParams = new ArrayList<String>();
        if (startDate != null) {
            queryParams.add("startDate=" + startDate);
        }
        if (endDate != null) {
            queryParams.add("endDate=" + endDate);
        }
        String fullUrl = QueryBuilder.appendQuery(this.connectionManager.getConfig().getUrl() + url, queryParams);
        CommentsType comments = this.get(this.connectionManager.getConnection(), fullUrl, CommentsType.class);
        return comments.getComment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommentType add(CommentType comment) throws Exception {
        CommentType commentType;
        String url = "/rs/cases/{caseNumber}/comments";
        url = url.replace("{caseNumber}", comment.getCaseNumber());
        String fullUrl = this.connectionManager.getConfig().getUrl() + url;
        Response response = null;
        try {
            response = this.add(this.connectionManager.getConnection(), fullUrl, comment);
            MultivaluedMap headers = response.getStringHeaders();
            URL caseurl = null;
            caseurl = new URL((String)headers.getFirst((Object)"Location"));
            String path = caseurl.getPath();
            comment.setId(path.substring(path.lastIndexOf(47) + 1, path.length()));
            comment.setViewUri(caseurl.toString());
            commentType = comment;
        }
        catch (Throwable throwable) {
            this.safeClose(response);
            throw throwable;
        }
        this.safeClose(response);
        return commentType;
    }
}

