/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.redhat_support_lib.infrastructure;

import com.redhat.gss.redhat_support_lib.errors.RequestException;
import com.redhat.gss.redhat_support_lib.helpers.FilterHelper;
import com.redhat.gss.redhat_support_lib.infrastructure.BaseQuery;
import com.redhat.gss.redhat_support_lib.parsers.ProductType;
import com.redhat.gss.redhat_support_lib.parsers.ProductsType;
import com.redhat.gss.redhat_support_lib.parsers.VersionsType;
import com.redhat.gss.redhat_support_lib.web.ConnectionManager;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.List;

public class Products
extends BaseQuery {
    private ConnectionManager connectionManager = null;

    public Products(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public List<ProductType> list(String[] kwargs) throws RequestException, MalformedURLException {
        String url = "/rs/products/";
        String fullUrl = this.connectionManager.getConfig().getUrl() + url;
        ProductsType prods = this.get(this.connectionManager.getConnection(), fullUrl, ProductsType.class);
        return FilterHelper.filterResults(prods.getProduct(), kwargs);
    }

    public List<String> getVersions(String prodName) throws RequestException, MalformedURLException, UnsupportedEncodingException {
        String url = "/rs/products/{prodName}/versions";
        prodName = URLEncoder.encode(prodName, "UTF-8").replace("+", "%20");
        url = url.replace("{prodName}", prodName);
        String fullUrl = this.connectionManager.getConfig().getUrl() + url;
        VersionsType vers = this.get(this.connectionManager.getConnection(), fullUrl, VersionsType.class);
        return vers.getVersion();
    }
}

