/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.maven;

import com.h3xstream.maven.victims.AffectedVersion;
import com.h3xstream.maven.victims.CveVulnerability;
import java.util.Arrays;
import java.util.List;

public class VersionUtil {
    public static boolean isAffected(String fullArtifactId, String version, CveVulnerability cve) {
        for (AffectedVersion affectedVersion : cve.getAffectedVersions()) {
            if (!fullArtifactId.equals(affectedVersion.getFullArtifactId())) continue;
            for (String versionExpr : affectedVersion.getLowerThan()) {
                String lastVulnerableVersion;
                int result;
                String[] versionParts = versionExpr.split(",");
                if (versionParts.length > 1 && !version.startsWith(versionParts[1]) || !versionParts[0].startsWith("<=") || (result = VersionUtil.compare(version, lastVulnerableVersion = versionParts[0].substring(2))) > 0) continue;
                return true;
            }
        }
        return false;
    }

    private static int compare(String v1, String v2) {
        v1 = v1.replaceAll("\\s", "");
        v2 = v2.replaceAll("\\s", "");
        String[] a1 = v1.split("\\.");
        String[] a2 = v2.split("\\.");
        List<String> l1 = Arrays.asList(a1);
        List<String> l2 = Arrays.asList(a2);
        int i = 0;
        while (true) {
            Double d1 = null;
            Double d2 = null;
            try {
                d1 = Double.parseDouble(l1.get(i));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                d2 = Double.parseDouble(l2.get(i));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (d1 != null && d2 != null) {
                if (d1 > d2) {
                    return 1;
                }
                if (d1 < d2) {
                    return -1;
                }
            } else if (d2 == null && d1 != null) {
                if (d1 > 0.0) {
                    return 1;
                }
            } else {
                if (d1 != null || d2 == null) break;
                if (d2 > 0.0) {
                    return -1;
                }
            }
            ++i;
        }
        return 0;
    }
}

