/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns;

import com.relayrides.pushy.apns.ApnsEnvironment;
import com.relayrides.pushy.apns.ExpiredToken;
import com.relayrides.pushy.apns.FeedbackConnectionException;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.Future;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FeedbackServiceClient {
    private final ApnsEnvironment environment;
    private final SSLContext sslContext;
    private final NioEventLoopGroup eventLoopGroup;
    private final Vector<ExpiredToken> expiredTokens;
    private static final Logger log = LoggerFactory.getLogger(FeedbackServiceClient.class);

    public FeedbackServiceClient(ApnsEnvironment environment, SSLContext sslContext, NioEventLoopGroup eventLoopGroup) {
        this.environment = environment;
        this.sslContext = sslContext;
        this.eventLoopGroup = eventLoopGroup;
        this.expiredTokens = new Vector();
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized List<ExpiredToken> getExpiredTokens(final long timeout, final TimeUnit timeoutUnit) throws InterruptedException, FeedbackConnectionException {
        this.expiredTokens.clear();
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group((EventLoopGroup)this.eventLoopGroup);
        bootstrap.channel(NioSocketChannel.class);
        final FeedbackServiceClient feedbackClient = this;
        bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                SSLEngine sslEngine = feedbackClient.sslContext.createSSLEngine();
                sslEngine.setUseClientMode(true);
                pipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
                pipeline.addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler(timeout, timeoutUnit));
                pipeline.addLast("decoder", (ChannelHandler)new ExpiredTokenDecoder());
                pipeline.addLast("handler", (ChannelHandler)new FeedbackClientHandler(feedbackClient));
            }
        });
        ChannelFuture connectFuture = bootstrap.connect(this.environment.getFeedbackHost(), this.environment.getFeedbackPort()).await();
        if (!connectFuture.isSuccess()) {
            log.debug("Failed to connect to feedback service.", connectFuture.cause());
            throw new FeedbackConnectionException(connectFuture.cause());
        }
        log.debug("Connected to feedback service.");
        SslHandler sslHandler = (SslHandler)connectFuture.channel().pipeline().get(SslHandler.class);
        if (sslHandler == null) {
            log.warn("Feedback client failed to get SSL handler and could not wait for TLS handshake.");
            connectFuture.channel().close().await();
            throw new FeedbackConnectionException(null);
        }
        Future handshakeFuture = sslHandler.handshakeFuture().await();
        if (handshakeFuture.isSuccess()) {
            log.debug("Completed TLS handshake with feedback service.");
            connectFuture.channel().closeFuture().await();
            return new ArrayList<ExpiredToken>(this.expiredTokens);
        }
        log.debug("Failed to complete TLS handshake with feedback service.", handshakeFuture.cause());
        connectFuture.channel().close().await();
        throw new FeedbackConnectionException(handshakeFuture.cause());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FeedbackClientHandler
    extends SimpleChannelInboundHandler<ExpiredToken> {
        private final FeedbackServiceClient feedbackClient;

        public FeedbackClientHandler(FeedbackServiceClient feedbackClient) {
            this.feedbackClient = feedbackClient;
        }

        protected void channelRead0(ChannelHandlerContext context, ExpiredToken expiredToken) {
            this.feedbackClient.expiredTokens.add(expiredToken);
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
            if (!(cause instanceof ReadTimeoutException)) {
                log.debug("Caught an unexpected exception while waiting for feedback.", cause);
            }
            context.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExpiredTokenDecoder
    extends ReplayingDecoder<ExpiredTokenDecoderState> {
        private Date expiration;
        private byte[] token;

        public ExpiredTokenDecoder() {
            super((Object)ExpiredTokenDecoderState.EXPIRATION);
        }

        protected void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) {
            switch ((ExpiredTokenDecoderState)((Object)this.state())) {
                case EXPIRATION: {
                    long timestamp = ((long)in.readInt() & 0xFFFFFFFFL) * 1000L;
                    this.expiration = new Date(timestamp);
                    this.checkpoint((Object)ExpiredTokenDecoderState.TOKEN_LENGTH);
                    break;
                }
                case TOKEN_LENGTH: {
                    this.token = new byte[in.readShort() & 0xFFFF];
                    this.checkpoint((Object)ExpiredTokenDecoderState.TOKEN);
                    break;
                }
                case TOKEN: {
                    in.readBytes(this.token);
                    out.add(new ExpiredToken(this.token, this.expiration));
                    this.checkpoint((Object)ExpiredTokenDecoderState.EXPIRATION);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExpiredTokenDecoderState {
        EXPIRATION,
        TOKEN_LENGTH,
        TOKEN;

    }
}

