/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns.util;

import com.relayrides.pushy.apns.ApnsPushNotification;
import com.relayrides.pushy.apns.util.TokenUtil;
import java.util.Arrays;
import java.util.Date;

public class SimpleApnsPushNotification
implements ApnsPushNotification {
    private final byte[] token;
    private final String payload;
    private final Date invalidationTime;

    public SimpleApnsPushNotification(byte[] token, String payload) {
        this(token, payload, null);
    }

    public SimpleApnsPushNotification(byte[] token, String payload, Date invalidationTime) {
        this.token = token;
        this.payload = payload;
        this.invalidationTime = invalidationTime;
    }

    public byte[] getToken() {
        return this.token;
    }

    public String getPayload() {
        return this.payload;
    }

    public Date getDeliveryInvalidationTime() {
        return this.invalidationTime;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.invalidationTime == null ? 0 : this.invalidationTime.hashCode());
        result = 31 * result + (this.payload == null ? 0 : this.payload.hashCode());
        result = 31 * result + Arrays.hashCode(this.token);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleApnsPushNotification other = (SimpleApnsPushNotification)obj;
        if (this.invalidationTime == null ? other.invalidationTime != null : !this.invalidationTime.equals(other.invalidationTime)) {
            return false;
        }
        if (this.payload == null ? other.payload != null : !this.payload.equals(other.payload)) {
            return false;
        }
        return Arrays.equals(this.token, other.token);
    }

    public String toString() {
        return "SimpleApnsPushNotification [token=" + TokenUtil.tokenBytesToString(this.token) + ", payload=" + this.payload + ", expiration=" + this.invalidationTime + "]";
    }
}

