/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier.wrapper;

import com.rollbar.notifier.wrapper.ThrowableWrapper;
import java.util.Arrays;

public class RollbarThrowableWrapper
implements ThrowableWrapper {
    private final String className;
    private final String message;
    private final StackTraceElement[] stackTraceElements;
    private final ThrowableWrapper cause;
    private final Throwable throwable;

    public RollbarThrowableWrapper(Throwable throwable) {
        this(throwable.getClass().getName(), throwable.getMessage(), throwable.getStackTrace(), throwable.getCause() != null ? new RollbarThrowableWrapper(throwable.getCause()) : null, throwable);
    }

    public RollbarThrowableWrapper(String className, String message, StackTraceElement[] stackTraceElements, ThrowableWrapper cause) {
        this(className, message, stackTraceElements, cause, null);
    }

    private RollbarThrowableWrapper(String className, String message, StackTraceElement[] stackTraceElements, ThrowableWrapper cause, Throwable throwable) {
        this.className = className;
        this.message = message;
        this.stackTraceElements = stackTraceElements;
        this.cause = cause;
        this.throwable = throwable;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return Arrays.copyOf(this.stackTraceElements, this.stackTraceElements.length);
    }

    @Override
    public ThrowableWrapper getCause() {
        return this.cause;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    public String toString() {
        return "RollbarThrowableWrapper{className='" + this.className + '\'' + ", message='" + this.message + '\'' + ", stackTraceElements=" + Arrays.toString(this.stackTraceElements) + ", cause=" + this.cause + ", throwable=" + this.throwable + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RollbarThrowableWrapper that = (RollbarThrowableWrapper)o;
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (!Arrays.equals(this.stackTraceElements, that.stackTraceElements)) {
            return false;
        }
        if (this.cause != null ? !this.cause.equals(that.cause) : that.cause != null) {
            return false;
        }
        return this.throwable != null ? this.throwable.equals(that.throwable) : that.throwable == null;
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.stackTraceElements);
        result = 31 * result + (this.cause != null ? this.cause.hashCode() : 0);
        result = 31 * result + (this.throwable != null ? this.throwable.hashCode() : 0);
        return result;
    }
}

