/*
 * Decompiled with CFR 0.152.
 */
package com.rudikershaw.gitbuildhook;

import com.rudikershaw.gitbuildhook.hook.type.GitHookType;
import com.rudikershaw.gitbuildhook.validation.GitRepositoryValidator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

@Mojo(name="install", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class InstallMojo
extends GitRepositoryValidator {
    @Parameter(readonly=true)
    private final Map<String, String> installHooks = new HashMap<String, String>();
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoFailureException {
        this.validateGitRepository(this.project);
        FileRepositoryBuilder repoBuilder = new FileRepositoryBuilder();
        repoBuilder.findGitDir(this.project.getBasedir());
        String hooksDirectory = repoBuilder.getGitDir().toString() + "/hooks";
        for (Map.Entry<String, String> hook : this.installHooks.entrySet()) {
            String hookName = hook.getKey();
            if (GitHookType.isValidHookName(hookName)) {
                this.installGitHook(hookName, hook.getValue(), hooksDirectory);
                continue;
            }
            throw new MojoFailureException("'" + hookName + "' is not a valid hook file name.");
        }
    }

    private void installGitHook(String hookName, String filePath, String hooksDirectory) {
        if (Objects.nonNull(filePath)) {
            String gitHookPathStr = hooksDirectory + File.separator + hookName;
            if (Paths.get(filePath, new String[0]).toFile().isFile()) {
                this.copyFromFile(filePath, gitHookPathStr);
            } else {
                this.copyFromClasspath(filePath, gitHookPathStr);
            }
        }
    }

    private void copyFromFile(String filePath, String gitHookPathStr) {
        try {
            Files.copy(Paths.get(filePath, new String[0]), Paths.get(gitHookPathStr, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Could not move file into .git/hooks directory", (Throwable)e);
        }
    }

    private void copyFromClasspath(String filePath, String gitHookPathStr) {
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(filePath);
        if (Objects.isNull(resource)) {
            this.getLog().warn((CharSequence)"Could not find file on filesystem or classpath");
        } else {
            try {
                File gitHookFile = Paths.get(gitHookPathStr, new String[0]).toFile();
                IOUtils.copy((InputStream)resource.openStream(), (OutputStream)new FileOutputStream(gitHookFile));
                gitHookFile.setExecutable(true);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Could not move file from classpath into .git/hooks directory", (Throwable)e);
            }
        }
    }
}

