/*
 * Decompiled with CFR 0.152.
 */
package com.samaxes.maven.minify.common;

import com.google.common.base.Strings;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DependencyOptions;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClosureConfig {
    private final CompilerOptions.LanguageMode languageIn;
    private final CompilerOptions.LanguageMode languageOut;
    private final CompilerOptions.Environment environment;
    private final CompilationLevel compilationLevel;
    private final DependencyOptions dependencyOptions;
    private final List<SourceFile> externs;
    private final SourceMap.Format sourceMapFormat;
    private final Map<DiagnosticGroup, CheckLevel> warningLevels;
    private final Boolean colorizeErrorOutput;
    private final Boolean angularPass;
    private final List<String> extraAnnotations;
    private final Map<String, Object> defineReplacements = new HashMap<String, Object>();

    public ClosureConfig(CompilerOptions.LanguageMode languageIn, CompilerOptions.LanguageMode languageOut, CompilerOptions.Environment environment, CompilationLevel compilationLevel, DependencyOptions dependencyOptions, List<SourceFile> externs, boolean createSourceMap, Map<DiagnosticGroup, CheckLevel> warningLevels, boolean angularPass, List<String> extraAnnotations, Map<String, String> defineReplacements) {
        this.languageIn = languageIn;
        this.languageOut = languageOut;
        this.environment = environment;
        this.compilationLevel = compilationLevel;
        this.dependencyOptions = dependencyOptions;
        this.externs = externs;
        this.sourceMapFormat = createSourceMap ? SourceMap.Format.V3 : null;
        this.warningLevels = warningLevels;
        this.colorizeErrorOutput = Boolean.TRUE;
        this.angularPass = angularPass;
        this.extraAnnotations = extraAnnotations;
        for (Map.Entry<String, String> defineReplacement : defineReplacements.entrySet()) {
            if (Strings.isNullOrEmpty((String)defineReplacement.getValue())) {
                throw new RuntimeException("Define replacement " + defineReplacement.getKey() + " does not have a value.");
            }
            if (String.valueOf(true).equals(defineReplacement.getValue()) || String.valueOf(false).equals(defineReplacement.getValue())) {
                this.defineReplacements.put(defineReplacement.getKey(), Boolean.valueOf(defineReplacement.getValue()));
                continue;
            }
            try {
                this.defineReplacements.put(defineReplacement.getKey(), Integer.valueOf(defineReplacement.getValue()));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    this.defineReplacements.put(defineReplacement.getKey(), Double.valueOf(defineReplacement.getValue()));
                }
                catch (NumberFormatException numberFormatException2) {
                    this.defineReplacements.put(defineReplacement.getKey(), defineReplacement.getValue());
                }
            }
        }
    }

    public CompilerOptions.LanguageMode getLanguageIn() {
        return this.languageIn;
    }

    public CompilerOptions.LanguageMode getLanguageOut() {
        return this.languageOut;
    }

    public CompilerOptions.Environment getEnvironment() {
        return this.environment;
    }

    public CompilationLevel getCompilationLevel() {
        return this.compilationLevel;
    }

    public DependencyOptions getDependencyOptions() {
        return this.dependencyOptions;
    }

    public List<SourceFile> getExterns() {
        return this.externs;
    }

    public SourceMap.Format getSourceMapFormat() {
        return this.sourceMapFormat;
    }

    public Map<DiagnosticGroup, CheckLevel> getWarningLevels() {
        return this.warningLevels;
    }

    public Boolean getColorizeErrorOutput() {
        return this.colorizeErrorOutput;
    }

    public Boolean getAngularPass() {
        return this.angularPass;
    }

    public List<String> getExtraAnnotations() {
        return this.extraAnnotations;
    }

    public Map<String, Object> getDefineReplacements() {
        return this.defineReplacements;
    }
}

