/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import com.sap.db.util.Dbg;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

@Immutable
public final class MessageTranslator {
    private static final String MESSAGES = "com.sap.db.jdbc.messages";
    private static final String MESSAGES_ID_POSTFIX = ".id";
    private static final String SQLSTATE_POSTFIX = ".sqlstate";
    private static final int DEFAULT_MESSAGE_ID = -10899;
    private static final String DEFAULT_SQL_STATE = "";
    private static final ResourceBundle BUNDLE;

    private MessageTranslator() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static ResourceBundle getMessages() {
        return BUNDLE;
    }

    public static String translate(String key, Object ... args) {
        Object[] nonNullArgs = MessageTranslator._getNonNullArgs(args);
        if (BUNDLE == null) {
            return MessageTranslator._getNoBundleMessage(key, nonNullArgs);
        }
        try {
            return MessageFormat.format(BUNDLE.getString(key), nonNullArgs);
        }
        catch (MissingResourceException e) {
            return MessageTranslator._getNoBundleMessage(key, nonNullArgs);
        }
    }

    public static int getMessageID(String key) {
        if (BUNDLE == null) {
            return -10899;
        }
        try {
            return Integer.parseInt(BUNDLE.getString(key + MESSAGES_ID_POSTFIX));
        }
        catch (NumberFormatException | MissingResourceException e) {
            return -10899;
        }
    }

    public static String getSQLState(String key) {
        if (BUNDLE == null) {
            return DEFAULT_SQL_STATE;
        }
        try {
            return BUNDLE.getString(key + SQLSTATE_POSTFIX);
        }
        catch (MissingResourceException e) {
            return DEFAULT_SQL_STATE;
        }
    }

    private static Object[] _getNonNullArgs(Object ... args) {
        boolean found = false;
        for (Object arg : args) {
            if (arg != null) continue;
            found = true;
            break;
        }
        if (!found) {
            return args;
        }
        int len = args.length;
        Object[] ret = new Object[len];
        for (int i = 0; i < len; ++i) {
            Object a = args[i];
            ret[i] = a == null ? DEFAULT_SQL_STATE : a;
        }
        return ret;
    }

    private static String _getNoBundleMessage(String key, Object ... args) {
        StringBuilder builder = new StringBuilder(128);
        builder.append("No message available for locale ");
        builder.append(Locale.getDefault().toString());
        builder.append(", key ");
        builder.append(key);
        if (args == null || args.length == 0) {
            builder.append(".");
        } else {
            builder.append(", arguments [");
            for (Object arg : args) {
                builder.append(arg);
                builder.append(", ");
            }
            builder.setLength(builder.length() - 2);
            builder.append("].");
        }
        return builder.toString();
    }

    static {
        ResourceBundle bundle;
        HashSet<Integer> forbiddenErrorCodes = null;
        if (Dbg.runtimeEnabled) {
            forbiddenErrorCodes = new HashSet<Integer>(Arrays.asList(-11202, -11205, -11206, -11208, -11211, -11219, -11220, -11221, -11222, -11225, -11226, -11227, -11228, -11229, -11230, -11231, -11232, -11233, -11234, -11235, -11236, -11237, -11238, -11240, -11241, -11244, -11250, -11252, -11254, -11255, -11256, -11257, -11259, -11260, -11261, -11263, -11265, -11266, -11270, -11275, -11276, -11277, -11278, -11279, -11280, -11281, -11282, -11284, -11285, -11287, -11288, -11289, -11290, -11291, -11292, -11293, -11294, -11295, -11298, -11299, -11304, -11305, -11308, -11309, -11310, -11311, -11313, -11314, -11315, -11316, -11317, -11318, -11319, -11320, -11321, -11322, -11324, -11325, -11326, -11327, -11328, -11329, -11330, -11331, -11332, -11334, -11335, -11336, -11342, -11345, -11346, -11347, -11348, -11349, -11350, -11351, -11353, -11354, -11355, -11356, -11357, -11358, -11359, -11360, -11361, -11362, -11363, -11365, -11366, -11368, -11369, -11375, -11377, -11379, -11380, -11383, -11385, -11386, -11403, -11404, -11405, -11406, -11407, -11408, -11409, -11411, -11415, -11416, -11417, -11418, -11426, -11457, -11458, -11461, -11465, -11493, -11510));
        }
        try {
            bundle = ResourceBundle.getBundle(MESSAGES);
            if (Dbg.runtimeEnabled) {
                for (String key : bundle.keySet()) {
                    if (!key.endsWith(MESSAGES_ID_POSTFIX)) continue;
                    String value = bundle.getString(key);
                    try {
                        int intValue = Integer.parseInt(value);
                        if (forbiddenErrorCodes.contains(intValue)) {
                            throw new AssertionError((Object)("Forbidden error code " + intValue + " used for resource " + key));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
            }
        }
        catch (MissingResourceException e) {
            bundle = null;
        }
        BUNDLE = bundle;
    }
}

