/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbcext;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbcext.XAExceptionSAP;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.HexUtils;
import com.sap.db.util.JdbcObject;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

@ThreadSafe
public class XidSAP
extends JdbcObject
implements Xid {
    public static final int XID_SIZE = 140;
    private final int _formatId;
    private final byte[] _globalTransactionId;
    private final byte[] _branchQualifier;
    private final AtomicReference<String> _string;
    private final AtomicReference<byte[]> _bytes;

    public static byte[] getBytes(Xid xid) {
        return xid instanceof XidSAP ? ((XidSAP)xid).getBytes() : XidSAP._getBytes(xid);
    }

    public XidSAP(int formatId, byte[] globalTransactionId, byte[] branchQualifier) {
        this._formatId = formatId;
        this._globalTransactionId = globalTransactionId;
        this._branchQualifier = branchQualifier;
        this._string = new AtomicReference();
        this._bytes = new AtomicReference();
    }

    public XidSAP(byte[] bytes) throws XAException {
        this(bytes, false);
    }

    public XidSAP(byte[] bytes, boolean isLittleEndian) throws XAException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes).order(isLittleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        this._formatId = byteBuffer.getInt();
        int globalTransactionIdLength = byteBuffer.getInt();
        if (globalTransactionIdLength < 1 || globalTransactionIdLength > 64) {
            throw new XAExceptionSAP(-4, "Wrong global transaction size: " + globalTransactionIdLength);
        }
        int branchQualifierLength = byteBuffer.getInt();
        if (branchQualifierLength < 1 || branchQualifierLength > 64) {
            throw new XAExceptionSAP(-4, "Wrong branch qualifier size: " + branchQualifierLength);
        }
        this._globalTransactionId = new byte[globalTransactionIdLength];
        byteBuffer.get(this._globalTransactionId);
        this._branchQualifier = new byte[branchQualifierLength];
        byteBuffer.get(this._branchQualifier);
        this._string = new AtomicReference();
        this._bytes = new AtomicReference();
    }

    @Override
    public int getFormatId() {
        return this._formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return (byte[])this._globalTransactionId.clone();
    }

    @Override
    public byte[] getBranchQualifier() {
        return (byte[])this._branchQualifier.clone();
    }

    @Override
    public String toString() {
        this._string.compareAndSet(null, this._toString());
        return this._string.get();
    }

    public byte[] getBytes() {
        this._bytes.compareAndSet(null, XidSAP._getBytes(this));
        return this._bytes.get();
    }

    private String _toString() {
        return String.format("%08x", this._formatId) + '-' + HexUtils.toHexString(this._globalTransactionId) + '-' + HexUtils.toHexString(this._branchQualifier);
    }

    private static byte[] _getBytes(Xid xid) {
        int formatId = xid.getFormatId();
        byte[] globalTransactionId = xid.getGlobalTransactionId();
        byte[] branchQualifier = xid.getBranchQualifier();
        int globalTransactionIdLength = Math.min(globalTransactionId.length, 64);
        int branchQualifierLength = Math.min(branchQualifier.length, 64);
        byte[] bytes = new byte[140];
        ByteUtils.putInt(formatId, bytes, 0);
        ByteUtils.putInt(globalTransactionIdLength, bytes, 4);
        ByteUtils.putInt(branchQualifierLength, bytes, 8);
        System.arraycopy(globalTransactionId, 0, bytes, 12, globalTransactionIdLength);
        System.arraycopy(branchQualifier, 0, bytes, 12 + globalTransactionIdLength, branchQualifierLength);
        return bytes;
    }
}

