/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.packet.HAuthenticationPart;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.security.AbstractAuthenticationMethod;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;

@ThreadSafe
class SessionCookieAuthentication
extends AbstractAuthenticationMethod {
    static final String METHOD_NAME = "SessionCookie";
    private final ConnectionSapDB _connection;

    SessionCookieAuthentication(ConnectionSapDB connection) {
        this._connection = connection;
    }

    @Override
    String getMethodName() {
        return METHOD_NAME;
    }

    @Override
    byte[] getInitialData(byte[] passwd) throws SQLException {
        String cookie = this._connection.getCookie();
        String termID = this._connection.getTermID();
        byte[] combined = (cookie + termID).getBytes(StandardCharsets.UTF_8);
        return combined;
    }

    @Override
    byte[] getFinalData(String passwd, String x509) throws SQLException {
        return new byte[0];
    }

    @Override
    byte[] evaluateAuthenticateReply(Tracer tracer, HAuthenticationPart authenticationPart) throws SQLException {
        return null;
    }

    @Override
    String evaluateConnectReply(Tracer tracer, HAuthenticationPart authenticationPart) throws SQLException {
        return null;
    }
}

