/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.model;

import com.sdicons.json.model.JSONNumber;
import java.math.BigInteger;

public class JSONInteger
extends JSONNumber {
    private BigInteger value;

    public JSONInteger(BigInteger value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.value = value;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public String toString() {
        return "JSONInteger(" + this.getLine() + ":" + this.getCol() + ")[" + this.value.toString() + "]";
    }

    protected String render(boolean pretty, String indent) {
        if (pretty) {
            return indent + this.value;
        }
        return "" + this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSONInteger that = (JSONInteger)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Object strip() {
        return this.value;
    }
}

