/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.serializer.helper.impl;

import com.sdicons.json.model.JSONArray;
import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONString;
import com.sdicons.json.model.JSONValue;
import com.sdicons.json.serializer.helper.MarshallHelper;
import com.sdicons.json.serializer.marshall.JSONMarshall;
import com.sdicons.json.serializer.marshall.MarshallException;
import java.util.Collection;
import java.util.HashMap;

public class CollectionHelper
implements MarshallHelper {
    public void renderValue(Object aObj, JSONObject aObjectElement, JSONMarshall aMarshall, HashMap aPool) throws MarshallException {
        JSONArray lArray = new JSONArray();
        aObjectElement.getValue().put("=", lArray);
        Collection lCollection = (Collection)aObj;
        for (Object lColEl : lCollection) {
            lArray.getValue().add(aMarshall.marshallImpl(lColEl, aPool));
        }
    }

    public Object parseValue(JSONObject aObjectElement, JSONMarshall aMarshall, HashMap aPool) throws MarshallException {
        JSONArray lArray = (JSONArray)aObjectElement.getValue().get("=");
        JSONMarshall.requireStringAttribute(aObjectElement, "c");
        String lCollectionClassName = ((JSONString)aObjectElement.get("c")).getValue();
        try {
            Class<?> lCollectionClass = Class.forName(lCollectionClassName);
            Collection lCollection = (Collection)lCollectionClass.newInstance();
            for (JSONValue lVal : lArray.getValue()) {
                lCollection.add(aMarshall.unmarshallImpl((JSONObject)lVal, aPool));
            }
            return lCollection;
        }
        catch (IllegalAccessException e) {
            String lMsg = "IllegalAccessException while trying to instantiate collection: " + lCollectionClassName;
            throw new MarshallException(lMsg);
        }
        catch (InstantiationException e) {
            String lMsg = "InstantiationException while trying to instantiate collection: " + lCollectionClassName;
            throw new MarshallException(lMsg);
        }
        catch (ClassNotFoundException e) {
            String lMsg = "ClassNotFoundException while trying to instantiate collection: " + lCollectionClassName;
            throw new MarshallException(lMsg);
        }
    }

    public Class getHelpedClass() {
        return Collection.class;
    }
}

