/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.reduction.RelevantInstructionReducer;
import com.sebastian_daschner.jaxrs_analyzer.analysis.classes.ContextClassReader;
import com.sebastian_daschner.jaxrs_analyzer.analysis.classes.ProjectMethodClassVisitor;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.InvokeInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.ProjectMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.results.MethodResult;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

abstract class MethodContentAnalyzer {
    private static final int PROJECT_PACKAGE_HIERARCHIES = 2;
    private final RelevantInstructionReducer instructionReducer = new RelevantInstructionReducer();
    private String projectPackagePrefix;

    MethodContentAnalyzer() {
    }

    List<Instruction> interpretRelevantInstructions(List<Instruction> instructions) {
        return this.instructionReducer.reduceInstructions(instructions);
    }

    void buildPackagePrefix(String className) {
        int lastPackageSeparator = className.lastIndexOf(47);
        String packageName = className.substring(0, lastPackageSeparator == -1 ? className.length() : lastPackageSeparator);
        String[] splitPackage = packageName.split("/");
        this.projectPackagePrefix = splitPackage.length >= 2 ? IntStream.range(0, 2).mapToObj(i -> splitPackage[i]).collect(Collectors.joining("/")) : packageName;
    }

    Set<ProjectMethod> findProjectMethods(List<Instruction> instructions) {
        HashSet<ProjectMethod> projectMethods = new HashSet<ProjectMethod>();
        this.addProjectMethods(instructions, projectMethods);
        return projectMethods;
    }

    private void addProjectMethods(List<Instruction> instructions, Set<ProjectMethod> projectMethods) {
        Set<MethodIdentifier> projectMethodIdentifiers = this.findUnhandledProjectMethodIdentifiers(instructions, projectMethods);
        for (MethodIdentifier identifier : projectMethodIdentifiers) {
            MethodResult methodResult = this.visitProjectMethod(identifier);
            if (methodResult == null) continue;
            List<Instruction> nestedMethodInstructions = this.interpretRelevantInstructions(methodResult.getInstructions());
            projectMethods.add(new ProjectMethod(identifier, nestedMethodInstructions));
            this.addProjectMethods(nestedMethodInstructions, projectMethods);
        }
    }

    private MethodResult visitProjectMethod(MethodIdentifier identifier) {
        try {
            ContextClassReader classReader = new ContextClassReader(identifier.getContainingClass());
            MethodResult methodResult = new MethodResult();
            methodResult.setOriginalMethodSignature(identifier);
            ProjectMethodClassVisitor visitor = new ProjectMethodClassVisitor(methodResult, identifier);
            classReader.accept(visitor, 8);
            return methodResult;
        }
        catch (IOException e) {
            LogProvider.error("Could not analyze project method " + identifier.getContainingClass() + "#" + identifier.getMethodName());
            LogProvider.debug(e);
            return null;
        }
    }

    private Set<MethodIdentifier> findUnhandledProjectMethodIdentifiers(List<Instruction> instructions, Set<ProjectMethod> projectMethods) {
        return instructions.stream().filter(i -> i.getType() == Instruction.InstructionType.INVOKE || i.getType() == Instruction.InstructionType.METHOD_HANDLE).map(i -> (InvokeInstruction)i).filter(this::isProjectMethod).map(InvokeInstruction::getIdentifier).filter(i -> projectMethods.stream().noneMatch(m -> m.matches((MethodIdentifier)i))).collect(Collectors.toSet());
    }

    private boolean isProjectMethod(InvokeInstruction instruction) {
        MethodIdentifier identifier = instruction.getIdentifier();
        return identifier.getContainingClass().startsWith(this.projectPackagePrefix);
    }
}

