/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation;

import com.sebastian_daschner.jaxrs_analyzer.model.elements.Element;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.HttpResponse;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonValue;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.MethodHandle;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.IdentifiableMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.Method;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

enum KnownResponseResultMethod implements IdentifiableMethod
{
    RESPONSE_BUILDER_BUILD(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "build", "Ljavax/ws/rs/core/Response;", new String[0]), (object, arguments) -> object),
    RESPONSE_BUILDER_CACHE_CONTROL(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "cacheControl", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljavax/ws/rs/core/CacheControl;"), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Cache-Control")),
    RESPONSE_BUILDER_CONTENT_LOCATION(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "contentLocation", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/net/URI;"), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Content-Location")),
    RESPONSE_BUILDER_COOKIE(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "cookie", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "[Ljavax/ws/rs/core/NewCookie;"), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Set-Cookie")),
    RESPONSE_BUILDER_ENCODING(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "encoding", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/lang/String;"), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Content-Encoding")),
    RESPONSE_BUILDER_ENTITY(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "entity", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/lang/Object;"), (object, arguments) -> KnownResponseResultMethod.addEntity(object, (Element)arguments.get(0))),
    RESPONSE_BUILDER_ENTITY_ANNOTATION(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "entity", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/lang/Object;", "[Ljava/lang/annotation/Annotation;"), (object, arguments) -> KnownResponseResultMethod.addEntity(object, (Element)arguments.get(0))),
    RESPONSE_BUILDER_EXPIRES(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "expires", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/util/Date;"), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Expires")),
    RESPONSE_BUILDER_HEADER(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "header", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/lang/String;", "Ljava/lang/Object;"), (object, arguments) -> {
        ((Element)arguments.get(0)).getPossibleValues().stream().map(header -> (String)header).forEach(h -> KnownResponseResultMethod.addHeader(object, h));
        return object;
    }),
    RESPONSE_BUILDER_LANGUAGE_LOCALE(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "language", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/util/Locale;"), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Content-Language")),
    RESPONSE_BUILDER_LANGUAGE_STRING(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "language", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/lang/String;"), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Content-Language")),
    RESPONSE_BUILDER_LAST_MODIFIED(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "lastModified", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/util/Date;"), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Last-Modified")),
    RESPONSE_BUILDER_LINK_URI(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "link", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/net/URI;", "Ljava/lang/String;"), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Link")),
    RESPONSE_BUILDER_LINK_STRING(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "link", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/lang/String;", "Ljava/lang/String;"), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Link")),
    RESPONSE_BUILDER_LINKS(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "links", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "[Ljavax/ws/rs/core/Link;"), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Link")),
    RESPONSE_BUILDER_LOCATION(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "location", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/net/URI;"), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Location")),
    RESPONSE_BUILDER_STATUS_ENUM(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "status", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljavax/ws/rs/core/Response$Status;"), (object, arguments) -> {
        ((Element)arguments.get(0)).getPossibleValues().stream().map(status -> ((Response.Status)status).getStatusCode()).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    RESPONSE_BUILDER_STATUS_INT(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "status", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "I"), (object, arguments) -> {
        ((Element)arguments.get(0)).getPossibleValues().stream().map(status -> (int)((Integer)status)).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    RESPONSE_BUILDER_TAG_ENTITY(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "tag", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljavax/ws/rs/core/EntityTag;"), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "ETag")),
    RESPONSE_BUILDER_TAG_STRING(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "tag", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/lang/String;"), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "ETag")),
    RESPONSE_BUILDER_TYPE(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "type", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljavax/ws/rs/core/MediaType;"), (object, arguments) -> {
        ((Element)arguments.get(0)).getPossibleValues().stream().map(m -> (MediaType)m).map(m -> m.getType() + '/' + m.getSubtype()).forEach(t -> KnownResponseResultMethod.addContentType(object, t));
        return object;
    }),
    RESPONSE_BUILDER_TYPE_STRING(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "type", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/lang/String;"), (object, arguments) -> {
        ((Element)arguments.get(0)).getPossibleValues().stream().map(t -> (String)t).forEach(t -> KnownResponseResultMethod.addContentType(object, t));
        return object;
    }),
    RESPONSE_BUILDER_VARIANT(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "variant", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljavax/ws/rs/core/Variant;"), (object, arguments) -> {
        KnownResponseResultMethod.addHeader(object, "Content-Language");
        KnownResponseResultMethod.addHeader(object, "Content-Encoding");
        return object;
    }),
    RESPONSE_BUILDER_VARIANTS_LIST(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "variants", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/util/List;"), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Vary")),
    RESPONSE_BUILDER_VARIANTS_ARRAY(MethodIdentifier.ofNonStatic("javax/ws/rs/core/Response$ResponseBuilder", "variants", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "[Ljavax/ws/rs/core/Variant;"), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Vary")),
    RESPONSE_STATUS_ENUM(MethodIdentifier.ofStatic("javax/ws/rs/core/Response", "status", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljavax/ws/rs/core/Response$Status;"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        ((Element)arguments.get(0)).getPossibleValues().stream().map(status -> ((Response.Status)status).getStatusCode()).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    RESPONSE_STATUS_INT(MethodIdentifier.ofStatic("javax/ws/rs/core/Response", "status", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "I"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        ((Element)arguments.get(0)).getPossibleValues().stream().map(status -> (int)((Integer)status)).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    RESPONSE_OK(MethodIdentifier.ofStatic("javax/ws/rs/core/Response", "ok", "Ljavax/ws/rs/core/Response$ResponseBuilder;", new String[0]), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.OK.getStatusCode());
    }),
    RESPONSE_OK_ENTITY(MethodIdentifier.ofStatic("javax/ws/rs/core/Response", "ok", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/lang/Object;"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.OK.getStatusCode());
        return KnownResponseResultMethod.addEntity(object, (Element)arguments.get(0));
    }),
    RESPONSE_OK_VARIANT(MethodIdentifier.ofStatic("javax/ws/rs/core/Response", "ok", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/lang/Object;", "Ljavax/ws/rs/core/Variant;"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.OK.getStatusCode());
        KnownResponseResultMethod.addEntity(object, (Element)arguments.get(0));
        KnownResponseResultMethod.addHeader(object, "Content-Language");
        return KnownResponseResultMethod.addHeader(object, "Content-Encoding");
    }),
    RESPONSE_OK_MEDIATYPE(MethodIdentifier.ofStatic("javax/ws/rs/core/Response", "ok", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/lang/Object;", "Ljavax/ws/rs/core/MediaType;"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.OK.getStatusCode());
        ((Element)arguments.get(1)).getPossibleValues().stream().map(m -> (MediaType)m).map(m -> m.getType() + '/' + m.getSubtype()).forEach(t -> KnownResponseResultMethod.addContentType(object, t));
        return KnownResponseResultMethod.addEntity(object, (Element)arguments.get(0));
    }),
    RESPONSE_OK_MEDIATYPE_STRING(MethodIdentifier.ofStatic("javax/ws/rs/core/Response", "ok", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/lang/Object;", "Ljava/lang/String;"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.OK.getStatusCode());
        ((Element)arguments.get(1)).getPossibleValues().stream().map(t -> (String)t).forEach(t -> KnownResponseResultMethod.addContentType(object, t));
        return KnownResponseResultMethod.addEntity(object, (Element)arguments.get(0));
    }),
    RESPONSE_ACCEPTED(MethodIdentifier.ofStatic("javax/ws/rs/core/Response", "accepted", "Ljavax/ws/rs/core/Response$ResponseBuilder;", new String[0]), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.ACCEPTED.getStatusCode());
    }),
    RESPONSE_ACCEPTED_ENTITY(MethodIdentifier.ofStatic("javax/ws/rs/core/Response", "accepted", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/lang/Object;"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.ACCEPTED.getStatusCode());
        return KnownResponseResultMethod.addEntity(object, (Element)arguments.get(0));
    }),
    RESPONSE_CREATED(MethodIdentifier.ofStatic("javax/ws/rs/core/Response", "created", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/net/URI;"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.CREATED.getStatusCode());
        return KnownResponseResultMethod.addHeader(object, "Location");
    }),
    RESPONSE_NO_CONTENT(MethodIdentifier.ofStatic("javax/ws/rs/core/Response", "noContent", "Ljavax/ws/rs/core/Response$ResponseBuilder;", new String[0]), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.NO_CONTENT.getStatusCode());
    }),
    RESPONSE_NOT_ACCEPTABLE(MethodIdentifier.ofStatic("javax/ws/rs/core/Response", "notAcceptable", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/util/List;"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.NOT_ACCEPTABLE.getStatusCode());
        return KnownResponseResultMethod.addHeader(object, "Vary");
    }),
    RESPONSE_NOT_MODIFIED(MethodIdentifier.ofStatic("javax/ws/rs/core/Response", "notModified", "Ljavax/ws/rs/core/Response$ResponseBuilder;", new String[0]), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.NOT_MODIFIED.getStatusCode());
    }),
    RESPONSE_NOT_MODIFIED_ENTITYTAG(MethodIdentifier.ofStatic("javax/ws/rs/core/Response", "notModified", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljavax/ws/rs/core/EntityTag;"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.NOT_MODIFIED.getStatusCode());
        return KnownResponseResultMethod.addHeader(object, "ETag");
    }),
    RESPONSE_NOT_MODIFIED_ENTITYTAG_STRING(MethodIdentifier.ofStatic("javax/ws/rs/core/Response", "notModified", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/lang/String;"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.NOT_MODIFIED.getStatusCode());
        return KnownResponseResultMethod.addHeader(object, "ETag");
    }),
    RESPONSE_SEE_OTHER(MethodIdentifier.ofStatic("javax/ws/rs/core/Response", "seeOther", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/net/URI;"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.SEE_OTHER.getStatusCode());
        return KnownResponseResultMethod.addHeader(object, "Location");
    }),
    RESPONSE_TEMPORARY_REDIRECT(MethodIdentifier.ofStatic("javax/ws/rs/core/Response", "temporaryRedirect", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "Ljava/net/URI;"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.TEMPORARY_REDIRECT.getStatusCode());
        return KnownResponseResultMethod.addHeader(object, "Location");
    }),
    RESPONSE_SERVER_ERROR(MethodIdentifier.ofStatic("javax/ws/rs/core/Response", "serverError", "Ljavax/ws/rs/core/Response$ResponseBuilder;", new String[0]), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }),
    WEB_APPLICATION_EXCEPTION_EMPTY(MethodIdentifier.ofNonStatic("javax/ws/rs/WebApplicationException", "<init>", "V", new String[0]), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }),
    WEB_APPLICATION_EXCEPTION_MESSAGE(MethodIdentifier.ofNonStatic("javax/ws/rs/WebApplicationException", "<init>", "V", "Ljava/lang/String;"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }),
    WEB_APPLICATION_EXCEPTION_RESPONSE(MethodIdentifier.ofNonStatic("javax/ws/rs/WebApplicationException", "<init>", "V", "Ljavax/ws/rs/core/Response;"), (notAvailable, arguments) -> (Element)arguments.get(0)),
    WEB_APPLICATION_EXCEPTION_MESSAGE_RESPONSE(MethodIdentifier.ofNonStatic("javax/ws/rs/WebApplicationException", "<init>", "V", "Ljava/lang/String;", "Ljavax/ws/rs/core/Response;"), (notAvailable, arguments) -> (Element)arguments.get(1)),
    WEB_APPLICATION_EXCEPTION_STATUS(MethodIdentifier.ofNonStatic("javax/ws/rs/WebApplicationException", "<init>", "V", "I"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        ((Element)arguments.get(0)).getPossibleValues().stream().map(status -> (int)((Integer)status)).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    WEB_APPLICATION_EXCEPTION_MESSAGE_STATUS(MethodIdentifier.ofNonStatic("javax/ws/rs/WebApplicationException", "<init>", "V", "Ljava/lang/String;", "I"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        ((Element)arguments.get(1)).getPossibleValues().stream().map(status -> (int)((Integer)status)).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    WEB_APPLICATION_EXCEPTION_RESPONSE_STATUS(MethodIdentifier.ofNonStatic("javax/ws/rs/WebApplicationException", "<init>", "V", "Ljavax/ws/rs/core/Response$Status;"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        ((Element)arguments.get(0)).getPossibleValues().stream().map(status -> ((Response.Status)status).getStatusCode()).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    WEB_APPLICATION_EXCEPTION_MESSAGE_RESPONSE_STATUS(MethodIdentifier.ofNonStatic("javax/ws/rs/WebApplicationException", "<init>", "V", "Ljava/lang/String;", "Ljavax/ws/rs/core/Response$Status;"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        ((Element)arguments.get(1)).getPossibleValues().stream().map(status -> ((Response.Status)status).getStatusCode()).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    WEB_APPLICATION_EXCEPTION_CAUSE(MethodIdentifier.ofNonStatic("javax/ws/rs/WebApplicationException", "<init>", "V", "Ljava/lang/Throwable;"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }),
    WEB_APPLICATION_EXCEPTION_MESSAGE_CAUSE(MethodIdentifier.ofNonStatic("javax/ws/rs/WebApplicationException", "<init>", "V", "Ljava/lang/String;", "Ljava/lang/Throwable;"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }),
    WEB_APPLICATION_EXCEPTION_CAUSE_RESPONSE(MethodIdentifier.ofNonStatic("javax/ws/rs/WebApplicationException", "<init>", "V", "Ljava/lang/Throwable;", "Ljavax/ws/rs/core/Response;"), (notAvailable, arguments) -> (Element)arguments.get(1)),
    WEB_APPLICATION_EXCEPTION_MESSAGE_CAUSE_RESPONSE(MethodIdentifier.ofNonStatic("javax/ws/rs/WebApplicationException", "<init>", "V", "Ljava/lang/String;", "Ljava/lang/Throwable;", "Ljavax/ws/rs/core/Response;"), (notAvailable, arguments) -> (Element)arguments.get(2)),
    WEB_APPLICATION_EXCEPTION_CAUSE_STATUS(MethodIdentifier.ofNonStatic("javax/ws/rs/WebApplicationException", "<init>", "V", "Ljava/lang/Throwable;", "I"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        ((Element)arguments.get(1)).getPossibleValues().stream().map(status -> (int)((Integer)status)).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    WEB_APPLICATION_EXCEPTION_MESSAGE_CAUSE_STATUS(MethodIdentifier.ofNonStatic("javax/ws/rs/WebApplicationException", "<init>", "V", "Ljava/lang/String;", "Ljava/lang/Throwable;", "I"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        ((Element)arguments.get(2)).getPossibleValues().stream().map(status -> (int)((Integer)status)).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    WEB_APPLICATION_EXCEPTION_CAUSE_RESPONSE_STATUS(MethodIdentifier.ofNonStatic("javax/ws/rs/WebApplicationException", "<init>", "V", "Ljava/lang/Throwable;", "Ljavax/ws/rs/core/Response$Status;"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        ((Element)arguments.get(1)).getPossibleValues().stream().map(status -> ((Response.Status)status).getStatusCode()).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    WEB_APPLICATION_EXCEPTION_MESSAGE_CAUSE_RESPONSE_STATUS(MethodIdentifier.ofNonStatic("javax/ws/rs/WebApplicationException", "<init>", "V", "Ljava/lang/String;", "Ljava/lang/Throwable;", "Ljavax/ws/rs/core/Response$Status;"), (notAvailable, arguments) -> {
        Element object = new Element("Ljavax/ws/rs/core/Response;", new HttpResponse());
        ((Element)arguments.get(2)).getPossibleValues().stream().map(status -> ((Response.Status)status).getStatusCode()).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    RESOURCE_CONTEXT_INIT(MethodIdentifier.ofNonStatic("javax/ws/rs/container/ResourceContext", "getResource", "Ljava/lang/Object;", "Ljava/lang/Class;"), (object, arguments) -> new Element(((Element)arguments.get(0)).getPossibleValues().stream().filter(s -> s instanceof String).map(s -> (String)s).collect(Collectors.toSet()), new Object[0])),
    RESOURCE_CONTEXT_GET(MethodIdentifier.ofNonStatic("javax/ws/rs/container/ResourceContext", "initResource", "Ljava/lang/Object;", "Ljava/lang/Object;"), (object, arguments) -> new Element(((Element)arguments.get(0)).getTypes(), new Object[0])),
    INTEGER_VALUE_OF(MethodIdentifier.ofStatic("java/lang/Integer", "valueOf", "I", "Ljava/lang/Integer;"), (object, arguments) -> new Element("Ljava/lang/Integer;", ((Element)arguments.get(0)).getPossibleValues().toArray())),
    DOUBLE_VALUE_OF(MethodIdentifier.ofStatic("java/lang/Double", "valueOf", "D", "Ljava/lang/Double;"), (object, arguments) -> new Element("Ljava/lang/Integer;", ((Element)arguments.get(0)).getPossibleValues().toArray())),
    LONG_VALUE_OF(MethodIdentifier.ofStatic("java/lang/Long", "valueOf", "J", "Ljava/lang/Long;"), (object, arguments) -> new Element("Ljava/lang/Integer;", ((Element)arguments.get(0)).getPossibleValues().toArray())),
    LIST_STREAM(MethodIdentifier.ofNonStatic("java/util/List", "stream", "Ljava/util/stream/Stream;", new String[0]), (object, arguments) -> new Element(object.getTypes(), new Object[0])),
    LIST_FOR_EACH(MethodIdentifier.ofNonStatic("java/util/List", "forEach", "V", "Ljava/util/function/Consumer;"), (object, arguments) -> {
        if (arguments.get(0) instanceof MethodHandle) {
            ((Method)arguments.get(0)).invoke(null, Collections.singletonList(object));
        }
        return null;
    }),
    SET_STREAM(MethodIdentifier.ofNonStatic("java/util/Set", "stream", "Ljava/util/stream/Stream;", new String[0]), (object, arguments) -> new Element(object.getTypes(), new Object[0])),
    SET_FOR_EACH(MethodIdentifier.ofNonStatic("java/util/Set", "forEach", "V", "Ljava/util/function/Consumer;"), (object, arguments) -> {
        if (arguments.get(0) instanceof MethodHandle) {
            ((Method)arguments.get(0)).invoke(null, Collections.singletonList(object));
        }
        return null;
    }),
    STREAM_COLLECT(MethodIdentifier.ofNonStatic("java/util/stream/Stream", "collect", "Ljava/lang/Object;", "Ljava/util/function/Supplier;", "Ljava/util/function/BiConsumer;", "Ljava/util/function/BiConsumer;"), (object, arguments) -> {
        if (arguments.get(0) instanceof MethodHandle && arguments.get(1) instanceof MethodHandle) {
            Element collectionElement = ((Method)arguments.get(0)).invoke(null, Collections.emptyList());
            ((Method)arguments.get(1)).invoke(null, Arrays.asList(collectionElement, object));
            return collectionElement;
        }
        return new Element();
    }),
    STREAM_FOR_EACH(MethodIdentifier.ofNonStatic("java/util/stream/Stream", "forEach", "V", "Ljava/util/function/Consumer;"), (object, arguments) -> {
        if (arguments.get(0) instanceof MethodHandle) {
            ((Method)arguments.get(0)).invoke(null, Collections.singletonList(object));
        }
        return null;
    }),
    STREAM_MAP(MethodIdentifier.ofNonStatic("java/util/stream/Stream", "map", "Ljava/util/stream/Stream;", "Ljava/util/function/Function;"), (object, arguments) -> {
        if (arguments.get(0) instanceof MethodHandle) {
            return ((MethodHandle)arguments.get(0)).invoke(null, Collections.singletonList(object));
        }
        return new Element();
    });

    private final MethodIdentifier identifier;
    private final BiFunction<Element, List<Element>, Element> function;

    private KnownResponseResultMethod(MethodIdentifier identifier, BiFunction<Element, List<Element>, Element> function) {
        this.identifier = identifier;
        this.function = function;
    }

    @Override
    public Element invoke(Element object, List<Element> arguments) {
        if (arguments.size() != this.identifier.getParameters().size()) {
            throw new IllegalArgumentException("Method arguments do not match expected signature!");
        }
        return this.function.apply(object, arguments);
    }

    @Override
    public boolean matches(MethodIdentifier identifier) {
        return this.identifier.equals(identifier);
    }

    private static Element addHeader(Element object, String header) {
        object.getPossibleValues().stream().filter(r -> r instanceof HttpResponse).map(r -> (HttpResponse)r).forEach(r -> r.getHeaders().add(header));
        return object;
    }

    private static Element addEntity(Element object, Element argument) {
        object.getPossibleValues().stream().filter(r -> r instanceof HttpResponse).map(r -> (HttpResponse)r).forEach(r -> {
            r.getEntityTypes().addAll(argument.getTypes());
            argument.getPossibleValues().stream().filter(j -> j instanceof JsonValue).map(j -> (JsonValue)j).forEach(j -> r.getInlineEntities().add((JsonValue)j));
        });
        return object;
    }

    private static Element addStatus(Element object, Integer status) {
        object.getPossibleValues().stream().filter(r -> r instanceof HttpResponse).map(r -> (HttpResponse)r).forEach(r -> r.getStatuses().add(status));
        return object;
    }

    private static Element addContentType(Element object, String type) {
        object.getPossibleValues().stream().filter(r -> r instanceof HttpResponse).map(r -> (HttpResponse)r).forEach(r -> r.getContentTypes().add(type));
        return object;
    }
}

