/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.javadoc;

import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import com.github.javaparser.javadoc.description.JavadocDescription;
import com.sebastian_daschner.jaxrs_analyzer.analysis.javadoc.ResponseCommentExtractor;
import com.sebastian_daschner.jaxrs_analyzer.model.javadoc.ClassComment;
import com.sebastian_daschner.jaxrs_analyzer.model.javadoc.MemberParameterTag;
import com.sebastian_daschner.jaxrs_analyzer.model.javadoc.MethodComment;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.utils.Pair;
import com.sebastian_daschner.jaxrs_analyzer.utils.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JavaDocParserVisitor
extends VoidVisitorAdapter<Void> {
    private String packageName;
    private String className;
    private final Map<MethodIdentifier, MethodComment> methodComments;
    private final Map<String, ClassComment> classComments = new HashMap<String, ClassComment>();

    public JavaDocParserVisitor(Map<MethodIdentifier, MethodComment> methodComments) {
        this.methodComments = methodComments;
    }

    @Override
    public void visit(PackageDeclaration packageDeclaration, Void arg) {
        this.packageName = packageDeclaration.getNameAsString();
        super.visit(packageDeclaration, arg);
    }

    @Override
    public void visit(ClassOrInterfaceDeclaration classOrInterface, Void arg) {
        this.className = this.calculateClassName(classOrInterface);
        classOrInterface.getComment().filter(Comment::isJavadocComment).map(this::toJavaDoc).ifPresent(this::recordClassComment);
        super.visit(classOrInterface, arg);
    }

    private Javadoc toJavaDoc(Comment comment) {
        return comment.asJavadocComment().parse();
    }

    private boolean isDeprecated(Javadoc javadoc) {
        return javadoc.getBlockTags().stream().anyMatch(t -> t.getType() == JavadocBlockTag.Type.DEPRECATED);
    }

    private String calculateClassName(ClassOrInterfaceDeclaration classOrInterface) {
        if (StringUtils.isBlank(this.packageName)) {
            return classOrInterface.getNameAsString();
        }
        return this.packageName.replace('.', '/') + "/" + classOrInterface.getNameAsString();
    }

    private void recordClassComment(Javadoc javadoc) {
        String comment = javadoc.getDescription().toText();
        Map<Integer, String> responseComments = this.createResponseComments(javadoc);
        this.classComments.put(this.className, new ClassComment(comment, responseComments, this.isDeprecated(javadoc)));
    }

    @Override
    public void visit(FieldDeclaration field, Void arg) {
        field.getComment().filter(Comment::isJavadocComment).map(this::toJavaDoc).ifPresent(c -> this.createFieldComment((Javadoc)c, field));
        super.visit(field, arg);
    }

    private void createFieldComment(Javadoc javadoc, FieldDeclaration field) {
        ClassComment classComment = this.classComments.get(this.className);
        if (classComment == null) {
            classComment = new ClassComment();
            this.classComments.put(this.className, classComment);
        }
        classComment.getFieldComments().add(this.createMemberParamTag(javadoc.getDescription(), field.getAnnotations().stream()));
    }

    @Override
    public void visit(MethodDeclaration method, Void arg) {
        method.getComment().filter(Comment::isJavadocComment).map(this::toJavaDoc).ifPresent(c -> this.recordMethodComment((Javadoc)c, method));
        super.visit(method, arg);
    }

    private void recordMethodComment(Javadoc javadoc, MethodDeclaration method) {
        MethodIdentifier identifier = this.calculateMethodIdentifier(method);
        String comment = javadoc.getDescription().toText();
        List<MemberParameterTag> tags = this.createMethodParameterTags(javadoc, method);
        Map<Integer, String> responseComments = this.createResponseComments(javadoc);
        this.methodComments.put(identifier, new MethodComment(comment, tags, responseComments, this.classComments.get(this.className), this.isDeprecated(javadoc)));
    }

    private List<MemberParameterTag> createMethodParameterTags(Javadoc javadoc, MethodDeclaration method) {
        return javadoc.getBlockTags().stream().filter(t -> t.getType() == JavadocBlockTag.Type.PARAM).map(t -> this.createMethodParameterTag((JavadocBlockTag)t, method)).collect(Collectors.toList());
    }

    private MemberParameterTag createMethodParameterTag(JavadocBlockTag tag, MethodDeclaration method) {
        Stream annotations = method.getParameterByName(tag.getName().orElse(null)).map(Parameter::getAnnotations).map(Collection::stream).orElseGet(Stream::empty);
        return this.createMemberParamTag(tag.getContent(), annotations);
    }

    private MemberParameterTag createMemberParamTag(JavadocDescription javadocDescription, Stream<AnnotationExpr> annotationStream) {
        Map<String, String> annotations = annotationStream.filter(Expression::isSingleMemberAnnotationExpr).collect(Collectors.toMap(a -> a.getName().getIdentifier(), this::createMemberParamValue));
        return new MemberParameterTag(javadocDescription.toText(), annotations);
    }

    private String createMemberParamValue(AnnotationExpr a) {
        Expression memberValue = a.asSingleMemberAnnotationExpr().getMemberValue();
        if (memberValue.getClass().isAssignableFrom(StringLiteralExpr.class)) {
            return memberValue.asStringLiteralExpr().asString();
        }
        if (memberValue.getClass().isAssignableFrom(NameExpr.class)) {
            return memberValue.asNameExpr().getNameAsString();
        }
        throw new IllegalArgumentException(String.format("Javadoc param type (%s) not supported.", memberValue.toString()));
    }

    private Map<Integer, String> createResponseComments(Javadoc javadoc) {
        return javadoc.getBlockTags().stream().filter(t -> "response".equalsIgnoreCase(t.getTagName())).map(t -> t.getContent().toText()).map(ResponseCommentExtractor::extract).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    private MethodIdentifier calculateMethodIdentifier(MethodDeclaration method) {
        String[] parameters = (String[])method.getParameters().stream().map(p -> p.getType().asString()).map(p -> p.replace('.', '/')).toArray(String[]::new);
        String returnType = method.getType().asString().replace('.', '/');
        if (method.isStatic()) {
            return MethodIdentifier.ofStatic(this.className, method.getNameAsString(), returnType, parameters);
        }
        return MethodIdentifier.ofNonStatic(this.className, method.getNameAsString(), returnType, parameters);
    }
}

