/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.results;

import com.sebastian_daschner.jaxrs_analyzer.model.Types;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.Element;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonValue;
import java.util.Set;
import java.util.function.Function;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

final class JsonMapper {
    private JsonMapper() {
        throw new UnsupportedOperationException();
    }

    static javax.json.JsonValue map(JsonValue jsonValue) {
        if (jsonValue instanceof com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonArray) {
            return JsonMapper.map((com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonArray)jsonValue);
        }
        return JsonMapper.map((com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonObject)jsonValue);
    }

    private static JsonArray map(com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonArray jsonArray) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        jsonArray.getElements().stream().forEach(e -> JsonMapper.addToArray(builder, e));
        return builder.build();
    }

    private static void addToArray(JsonArrayBuilder builder, Element value) {
        if (value.getTypes().contains("Ljava/lang/String;")) {
            builder.add("string");
        }
        if (value.getTypes().stream().anyMatch(Types.INTEGER_TYPES::contains)) {
            builder.add(0);
        }
        if (value.getTypes().stream().anyMatch(Types.DOUBLE_TYPES::contains)) {
            builder.add(0.0);
        }
        if (value.getTypes().contains("Ljava/lang/Boolean;") || value.getTypes().contains("Z")) {
            builder.add(false);
        }
        if (value.getTypes().stream().anyMatch(Types.JSON_TYPES::contains)) {
            value.getPossibleValues().stream().filter(v -> v instanceof JsonValue).findFirst().ifPresent(v -> builder.add(JsonMapper.map((JsonValue)v)));
        }
    }

    private static JsonObject map(com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonObject jsonObject) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        jsonObject.getStructure().entrySet().stream().forEach(e -> JsonMapper.addToObject(builder, (String)e.getKey(), (Element)e.getValue()));
        return builder.build();
    }

    private static void addToObject(JsonObjectBuilder builder, String key, Element value) {
        if (value.getTypes().stream().anyMatch(Types.JSON_TYPES::contains)) {
            value.getPossibleValues().stream().filter(v -> v instanceof JsonValue).findFirst().ifPresent(v -> builder.add(key, JsonMapper.map((JsonValue)v)));
            return;
        }
        JsonMapper.addToObject(builder, key, value.getTypes());
    }

    private static void addToObject(JsonObjectBuilder builder, String key, Set<String> types) {
        if (types.contains("Ljava/lang/String;")) {
            builder.add(key, "string");
        }
        if (types.stream().anyMatch(Types.INTEGER_TYPES::contains)) {
            builder.add(key, 0);
        }
        if (types.stream().anyMatch(Types.DOUBLE_TYPES::contains)) {
            builder.add(key, 0.0);
        }
        if (types.contains("Ljava/lang/Boolean;") || types.contains("Z")) {
            builder.add(key, false);
        }
    }

    static void addToObject(JsonObjectBuilder builder, String key, String type, Function<String, javax.json.JsonValue> defaultBehavior) {
        if ("Ljava/lang/String;".equals(type)) {
            builder.add(key, "string");
            return;
        }
        if ("Ljava/lang/Boolean;".equals(type) || "Z".equals(type)) {
            builder.add(key, false);
            return;
        }
        builder.add(key, defaultBehavior.apply(type));
    }

    static void addToArray(JsonArrayBuilder builder, String type, Function<String, javax.json.JsonValue> defaultBehavior) {
        if ("Ljava/lang/String;".equals(type)) {
            builder.add("string");
            return;
        }
        if ("Ljava/lang/Boolean;".equals(type) || "Z".equals(type)) {
            builder.add(false);
            return;
        }
        builder.add(defaultBehavior.apply(type));
    }
}

